/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.type;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.FakeCamera;

public class FrameCountTest {
    @Test
    public void testCalcFromLengthResolution() {
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(10.0f));
        fakeCameraWithSetFieldOfView.setWidth(new PixelWidth(100));
        fakeCameraWithSetFieldOfView.setFieldOfView(new FieldOfView(10.0f));
        MatcherAssert.assertThat((Object)new FrameCount((LengthValue)new LengthValue((float)10.0f), (Camera)fakeCameraWithSetFieldOfView).value, (Matcher)CoreMatchers.is((Object)100));
        fakeCameraWithSetFieldOfView.setFramesToAverage(2);
        MatcherAssert.assertThat((Object)new FrameCount((LengthValue)new LengthValue((float)10.0f), (Camera)fakeCameraWithSetFieldOfView).value, (Matcher)CoreMatchers.is((Object)100));
    }

    @Test
    public void testCalcFromLengthAndFrameRate() {
        Speed speed = new Speed(10.0f);
        LengthValue lengthValue = new LengthValue(10.0f);
        FakeCamera fakeCamera = new FakeCamera();
        fakeCamera.setFrameRate(new FrameRate(10.0f));
        FrameCount frameCount = new FrameCount(lengthValue, speed, fakeCamera.getFrameRate(), fakeCamera.getFramesToAverage());
        MatcherAssert.assertThat((Object)frameCount.value, (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)Float.valueOf(new Speed((Camera)fakeCamera, (FrameCount)frameCount, (float)lengthValue.value).value), (Matcher)CoreMatchers.is((Object)Float.valueOf(speed.value)));
        fakeCamera.setFramesToAverage(2);
        MatcherAssert.assertThat((Object)Float.valueOf(new Speed((Camera)fakeCamera, (FrameCount)frameCount, (float)lengthValue.value).value), (Matcher)CoreMatchers.is((Object)Float.valueOf(speed.value / (float)fakeCamera.getFramesToAverage())));
        FrameCount frameCount2 = new FrameCount(lengthValue, speed, fakeCamera.getFrameRate(), fakeCamera.getFramesToAverage());
        MatcherAssert.assertThat((Object)frameCount2.value, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testFromReference() {
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(10.0f));
        fakeCameraWithSetFieldOfView.setFieldOfView(new FieldOfView(100.0f));
        fakeCameraWithSetFieldOfView.setWidth(new PixelWidth(100));
        FakeCamera fakeCamera = new FakeCamera();
        fakeCamera.setFrameRate(new FrameRate(20.0f));
        MatcherAssert.assertThat((Object)FrameCount.fromReference((MeasurementLength)new MeasurementLength((float)10.0f), (Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCamera).value, (Matcher)CoreMatchers.is((Object)20));
        fakeCamera.setFramesToAverage(2);
        MatcherAssert.assertThat((Object)FrameCount.fromReference((MeasurementLength)new MeasurementLength((float)10.0f), (Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCamera).value, (Matcher)CoreMatchers.is((Object)10));
        fakeCameraWithSetFieldOfView.setFramesToAverage(2);
        MatcherAssert.assertThat((Object)FrameCount.fromReference((MeasurementLength)new MeasurementLength((float)10.0f), (Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCamera).value, (Matcher)CoreMatchers.is((Object)20));
        fakeCamera.setFramesToAverage(1);
        MatcherAssert.assertThat((Object)FrameCount.fromReference((MeasurementLength)new MeasurementLength((float)10.0f), (Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCamera).value, (Matcher)CoreMatchers.is((Object)40));
    }
}

