/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.util.type;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.FakeCamera;

public class FrameRateTest {
    @Test
    public void testFrameRateFromSpeedLengthFrames() {
        MatcherAssert.assertThat((Object)Float.valueOf(new FrameRate((Speed)new Speed((float)10.0f), (LengthValue)new LengthValue((float)10.0f), (FrameCount)new FrameCount((int)25)).value), (Matcher)Matchers.is((Object)Float.valueOf(25.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(new FrameRate((Speed)new Speed((float)100.0f), (LengthValue)new LengthValue((float)10.0f), (FrameCount)new FrameCount((int)25)).value), (Matcher)Matchers.is((Object)Float.valueOf(250.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(new FrameRate((Speed)new Speed((float)10.0f), (LengthValue)new LengthValue((float)100.0f), (FrameCount)new FrameCount((int)25)).value), (Matcher)Matchers.is((Object)Float.valueOf(2.5f)));
    }

    @Test
    public void testFrameRateTimeMs() {
        MatcherAssert.assertThat((Object)Float.valueOf(new FrameRate(400.0f).timeMs(1000)), (Matcher)Matchers.is((Object)Float.valueOf(2500.0f)));
    }

    @Test
    public void testFromSecondCamera() {
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView.setWidth(new PixelWidth(1800));
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(100.0f));
        fakeCameraWithSetFieldOfView.setFieldOfView(new FieldOfView(100.0f));
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView2 = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView2.setWidth(new PixelWidth(900));
        fakeCameraWithSetFieldOfView2.setFieldOfView(new FieldOfView(100.0f));
        MatcherAssert.assertThat((Object)FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value, (Matcher)Matchers.closeTo((double)50.0, (double)0.001));
        fakeCameraWithSetFieldOfView2.setWidth(new PixelWidth(384));
        MatcherAssert.assertThat((Object)FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value, (Matcher)Matchers.closeTo((double)21.333f, (double)0.001));
        fakeCameraWithSetFieldOfView2.setFieldOfView(new FieldOfView(110.0f));
        MatcherAssert.assertThat((Object)FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value, (Matcher)Matchers.closeTo((double)19.394f, (double)0.001));
    }

    @Test
    public void testTwoHySpexCameraAlignmentPrecisionIssues() {
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView.setFieldOfView(new FieldOfView(93.38786f));
        fakeCameraWithSetFieldOfView.setWidth(new PixelWidth(1024));
        FakeCamera.FakeCameraWithSetFieldOfView fakeCameraWithSetFieldOfView2 = new FakeCamera.FakeCameraWithSetFieldOfView();
        fakeCameraWithSetFieldOfView2.setFieldOfView(new FieldOfView(94.26384f));
        fakeCameraWithSetFieldOfView2.setWidth(new PixelWidth(640));
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(this.FrameRateFromFramePeriod(15000.0f)));
        fakeCameraWithSetFieldOfView2.setFramesToAverage(1);
        MatcherAssert.assertThat((Object)FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value, (Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(24225.0f), (double)0.001));
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(this.FrameRateFromFramePeriod(8000.0f)));
        fakeCameraWithSetFieldOfView2.setFramesToAverage(1);
        MatcherAssert.assertThat((Object)FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value, (Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(12920.0f), (double)0.001));
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(this.FrameRateFromFramePeriod(8000.0f)));
        fakeCameraWithSetFieldOfView2.setFramesToAverage(2);
        MatcherAssert.assertThat((Object)FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value, (Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(6460.0f), (double)0.001));
        fakeCameraWithSetFieldOfView2.setFramesToAverage(2);
        fakeCameraWithSetFieldOfView.setFrameRate(new FrameRate(this.FrameRateFromFramePeriod(7000.0f)));
        float f = FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView, (Camera)fakeCameraWithSetFieldOfView2).value;
        MatcherAssert.assertThat((String)"The calculated frame rate corresponds to a value between two frame period integer values", (Object)f, (Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(5652.528f), (double)0.001));
        MatcherAssert.assertThat((String)"and the integer below it does not match with enough precision", (Object)f, (Matcher)Matchers.not((Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(5652.0f), (double)0.001)));
        MatcherAssert.assertThat((String)"and the integer above it does not match with enough precision", (Object)f, (Matcher)Matchers.not((Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(5653.0f), (double)0.001)));
        fakeCameraWithSetFieldOfView2.setFrameRate(new FrameRate(this.FrameRateFromFramePeriod(5653.0f)));
        float f2 = FrameRate.calculateTargetFrameRate((Camera)fakeCameraWithSetFieldOfView2, (Camera)fakeCameraWithSetFieldOfView).value;
        MatcherAssert.assertThat((String)"The use of the HySpex integer makes the calculated frame rate 1 greater than in the previous test", (Object)f2, (Matcher)Matchers.closeTo((double)this.FrameRateFromFramePeriod(7001.0f), (double)0.01));
    }

    private float FrameRateFromFramePeriod(float f) {
        return 1000000.0f / f;
    }
}

