/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.error;

import java.awt.image.BufferedImage;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;

public class ErrorHandlerTest {
    @Test
    public void shouldInvokeScreenshotCallbackOnLogIfItIsSet() {
        BoolHolder boolHolder = new BoolHolder(false);
        ErrorHandler.setScreenshotCallback(() -> {
            boolHolder.setTrue();
            return new BufferedImage(1, 1, 5);
        });
        String string = ErrorHandler.logAndReportException((Throwable)new RuntimeException());
        MatcherAssert.assertThat((String)"screenshot callback was called", (boolean)boolHolder.getValue());
        this.assertScreenshotFileExistAndDelete(string);
    }

    @Test
    public void shouldReturnWithoutInvokingScreenshotCallbackIfScreenshotCallbackCausesInfiniteLoop() {
        IntHolder intHolder = new IntHolder(0);
        ErrorHandler.setScreenshotCallback(() -> {
            intHolder.add(1);
            if (intHolder.getValue() < 10) {
                ErrorHandler.logAndReportException((Throwable)new RuntimeException("infinite loop exception"));
            }
            return new BufferedImage(1, 1, 5);
        });
        String string = ErrorHandler.logAndReportException((Throwable)new RuntimeException("original exception"));
        MatcherAssert.assertThat((String)"screenshot callback was called only once", (Object)intHolder.getValue(), (Matcher)CoreMatchers.is((Object)1));
        this.assertScreenshotFileExistAndDelete(string);
    }

    private void assertScreenshotFileExistAndDelete(String string) {
        File file = new File(IniManager.getOrCreatePredikteraDir((UpdateHelper.Product)UpdateHelper.Product.Breeze), "error-screenshots");
        File file2 = new File(file, "error-screenshot-" + string + ".png");
        MatcherAssert.assertThat((String)"screenshot file created", (boolean)file2.exists());
        file2.delete();
    }
}

