/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4GRImage;
import ncsa.hdf.object.h4.H4Group;
import ncsa.hdf.object.h4.H4SDS;
import ncsa.hdf.object.h4.H4Vdata;

public class H4File
extends FileFormat {
    public static final long serialVersionUID = 240L;
    private int flag;
    private DefaultMutableTreeNode rootNode;
    private List objList;
    private int grid;
    private boolean isNetCDF = false;
    private int sdid;
    private boolean showAll = false;

    public H4File() {
        this("", 1);
    }

    public H4File(String string) {
        this(string, 1);
    }

    public H4File(String string, int n) {
        super(string);
        this.isReadOnly = n == 0;
        this.objList = new Vector();
        this.fid = -1;
        this.flag = n == 0 ? 1 : (n == 1 ? 2 : (n == 2 ? 4 : n));
        String string2 = System.getProperty("h4showall");
        if (string2 != null) {
            this.showAll = true;
        }
    }

    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof H4File;
    }

    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = HDFLibrary.Hishdf((String)string);
        }
        catch (HDFException hDFException) {
            bl = false;
        }
        if (!bl) {
            bl = this.isNetCDF(string);
        }
        return bl;
    }

    public FileFormat createFile(String string, int n) throws Exception {
        File file;
        Boolean bl = true;
        if (n == 11 && (file = new File(string)).exists()) {
            bl = false;
        }
        if (bl.booleanValue()) {
            int n2 = HDFLibrary.Hopen((String)string, (int)4);
            try {
                HDFLibrary.Hclose((int)n2);
            }
            catch (HDFException hDFException) {
                // empty catch block
            }
        }
        return new H4File(string, 1);
    }

    public FileFormat createInstance(String string, int n) throws Exception {
        return new H4File(string, n);
    }

    public int open() throws Exception {
        if (this.fid >= 0) {
            return this.fid;
        }
        if (this.flag < 0) {
            throw new HDFException("Invalid access identifer -- " + this.flag);
        }
        if (this.flag == 1) {
            if (!this.exists()) {
                throw new HDFException("File does not exist -- " + this.fullFileName);
            }
            if (this.exists() && !this.canRead()) {
                throw new HDFException("Cannot read file -- " + this.fullFileName);
            }
        } else if ((this.flag == 2 || this.flag == 4) && this.exists() && !this.canWrite()) {
            throw new HDFException("Cannot write file, try open as read-only -- " + this.fullFileName);
        }
        this.isNetCDF = this.isNetCDF(this.fullFileName);
        if (this.isNetCDF) {
            this.isReadOnly = true;
        }
        if (this.isNetCDF) {
            this.fid = 0;
        } else {
            this.fid = HDFLibrary.Hopen((String)this.fullFileName, (int)this.flag);
            HDFLibrary.Vstart((int)this.fid);
            this.grid = HDFLibrary.GRstart((int)this.fid);
        }
        this.sdid = HDFLibrary.SDstart((String)this.fullFileName, (int)this.flag);
        this.rootNode = this.loadTree();
        return this.fid;
    }

    public void close() throws HDFException {
        if (this.rootNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            HObject hObject = null;
            Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (hObject instanceof Dataset) {
                    ((Dataset)hObject).clearData();
                }
                hObject = null;
                defaultMutableTreeNode = null;
            }
        }
        try {
            HDFLibrary.GRend((int)this.grid);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        try {
            HDFLibrary.SDend((int)this.sdid);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        try {
            HDFLibrary.Vend((int)this.fid);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        HDFLibrary.Hclose((int)this.fid);
        this.fid = -1;
        this.objList = null;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public Group createGroup(String string, Group group) throws Exception {
        return H4Group.create(string, group);
    }

    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        return new H4Datatype(n, n2, n3, n4);
    }

    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        throw new UnsupportedOperationException("HDF4 does not support named datatype.");
    }

    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        return H4SDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
    }

    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        H4GRImage h4GRImage = H4GRImage.create(string, group, datatype, lArray, lArray2, lArray3, n, n2, n3, object);
        return h4GRImage;
    }

    public void delete(HObject hObject) throws Exception {
        throw new UnsupportedOperationException("Cannot delete HDF4 object.");
    }

    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        TreeNode treeNode = null;
        if (hObject == null || group == null) {
            return null;
        }
        if (string == null) {
            string = hObject.getName();
        }
        if (hObject instanceof H4SDS) {
            treeNode = new DefaultMutableTreeNode(((H4SDS)hObject).copy(group, string, null, null));
        } else if (hObject instanceof H4GRImage) {
            treeNode = new DefaultMutableTreeNode(((H4GRImage)hObject).copy(group, string, null, null));
        } else if (hObject instanceof H4Vdata) {
            treeNode = new DefaultMutableTreeNode(((H4Vdata)hObject).copy(group, null, null, null));
        } else if (hObject instanceof H4Group) {
            treeNode = this.copyGroup((H4Group)hObject, (H4Group)group);
        }
        return treeNode;
    }

    public HObject createLink(Group group, String string, HObject hObject) throws Exception {
        throw new UnsupportedOperationException("createLink() is not supported");
    }

    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws HDFException {
        Object object;
        String string = attribute.getName();
        int n = attribute.getType().toNative();
        long[] lArray = attribute.getDataDims();
        int n2 = 1;
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                n2 *= (int)lArray[i];
            }
        }
        if (Array.get(object = attribute.getValue(), 0) instanceof String) {
            String string2 = (String)Array.get(object, 0);
            if (string2.length() > n2) {
                string2 = string2.substring(0, n2);
                Array.set(object, 0, string2);
            } else {
                for (int i = string2.length(); i < n2; ++i) {
                    string2 = string2 + " ";
                }
            }
            byte[] byArray = string2.getBytes();
            byArray[string2.length() - 1] = 0;
            object = byArray;
        }
        if (hObject instanceof H4Group && ((H4Group)hObject).isRoot()) {
            if (bl) {
                HDFLibrary.SDsetattr((int)this.sdid, (String)string, (int)n, (int)n2, (Object)object);
            } else {
                HDFLibrary.GRsetattr((int)this.grid, (String)string, (int)n, (int)n2, (Object)object);
            }
            return;
        }
        int n3 = hObject.open();
        if (hObject instanceof H4Group) {
            HDFLibrary.Vsetattr((int)n3, (String)string, (int)n, (int)n2, (Object)object);
        } else if (hObject instanceof H4SDS) {
            HDFLibrary.SDsetattr((int)n3, (String)string, (int)n, (int)n2, (Object)object);
        } else if (hObject instanceof H4GRImage) {
            HDFLibrary.GRsetattr((int)n3, (String)string, (int)n, (int)n2, (Object)object);
        } else if (hObject instanceof H4Vdata) {
            HDFLibrary.VSsetattr((int)n3, (int)-1, (String)string, (int)n, (int)n2, (Object)object);
        }
        hObject.close(n3);
    }

    private TreeNode copyGroup(H4Group h4Group, H4Group h4Group2) throws Exception {
        int n;
        H4Group h4Group3 = null;
        String string = null;
        String string2 = null;
        int n2 = HDFLibrary.Vattach((int)this.fid, (int)-1, (String)"w");
        if (n2 < 0) {
            return null;
        }
        string = h4Group.getName();
        int n3 = h4Group.open();
        HDFLibrary.Vsetname((int)n2, (String)string);
        int n4 = HDFLibrary.VQueryref((int)n2);
        int n5 = HDFLibrary.VQuerytag((int)n2);
        if (h4Group2.isRoot()) {
            string2 = "/";
        } else {
            string2 = h4Group2.getPath() + h4Group2.getName() + "/";
            n = h4Group2.open();
            HDFLibrary.Vinsert((int)n, (int)n2);
            h4Group2.close(n);
        }
        n = 0;
        try {
            n = HDFLibrary.Vnattrs((int)n3);
        }
        catch (Exception exception) {
            n = 0;
        }
        String[] stringArray = new String[1];
        byte[] byArray = null;
        int[] nArray = new int[3];
        for (int i = 0; i < n; ++i) {
            try {
                stringArray[0] = "";
                HDFLibrary.Vattrinfo((int)n3, (int)i, (String[])stringArray, (int[])nArray);
                byArray = new byte[nArray[2]];
                HDFLibrary.Vgetattr((int)n3, (int)i, (byte[])byArray);
                HDFLibrary.Vsetattr((int)n2, (String)stringArray[0], (int)nArray[0], (int)nArray[2], (byte[])byArray);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long[] lArray = new long[]{n5, n4};
        h4Group3 = new H4Group(this, string, string2, h4Group2, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode((Object)h4Group3){
            public static final long serialVersionUID = 240L;

            public boolean isLeaf() {
                return false;
            }
        };
        h4Group2.addToMemberList((HObject)h4Group3);
        List list = h4Group.getMemberList();
        if (list != null && list.size() > 0) {
            for (HObject hObject : list) {
                try {
                    defaultMutableTreeNode.add((MutableTreeNode)this.copy(hObject, h4Group3));
                }
                catch (Exception exception) {}
            }
        }
        h4Group.close(n3);
        try {
            HDFLibrary.Vdetach((int)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode loadTree() {
        Object object;
        int n;
        if (this.fid < 0) {
            return null;
        }
        long[] lArray = new long[]{0L, 0L};
        int n2 = 0;
        int n3 = -1;
        int[] nArray = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        H4Group h4Group = new H4Group(this, this.getName(), null, null, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)h4Group){
            public static final long serialVersionUID = 240L;

            public boolean isLeaf() {
                return false;
            }
        };
        int[] nArray2 = new int[1];
        int[] nArray3 = null;
        try {
            n2 = HDFLibrary.Vlone((int)this.fid, (int[])nArray2, (int)0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.Vlone((int)this.fid, (int[])nArray3, (int)n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        int n4 = Math.max(0, this.getStartMembers());
        int n5 = this.getMaxMembers();
        if (n5 >= n2) {
            n5 = n2;
            n4 = 0;
        }
        n5 += n4;
        n5 = Math.min(n5, n2);
        for (n = n4; n < n5; ++n) {
            n3 = nArray3[n];
            H4Group h4Group2 = this.getVGroup(1965, n3, "/", h4Group, false);
            if (h4Group2 == null) continue;
            defaultMutableTreeNode = new DefaultMutableTreeNode((Object)h4Group2){
                public static final long serialVersionUID = 240L;

                public boolean isLeaf() {
                    return false;
                }
            };
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h4Group.addToMemberList((HObject)h4Group2);
            this.depth_first(defaultMutableTreeNode, null);
        }
        nArray = new int[2];
        n = 0;
        try {
            n = HDFLibrary.GRfileinfo((int)this.grid, (int[])nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                object = this.getGRImage(306, i, "/", false);
                if (object == null) continue;
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h4Group.addToMemberList((HObject)object);
            }
        }
        try {
            n = HDFLibrary.SDfileinfo((int)this.sdid, (int[])nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                object = this.getSDS(720, i, "/", false);
                if (object == null) continue;
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h4Group.addToMemberList((HObject)object);
            }
        }
        try {
            n2 = HDFLibrary.VSlone((int)this.fid, (int[])nArray2, (int)0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.VSlone((int)this.fid, (int[])nArray3, (int)n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        for (int i = 0; i < n2; ++i) {
            n3 = nArray3[i];
            object = this.getVdata(1963, n3, "/", false);
            if (object == null) continue;
            defaultMutableTreeNode = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            h4Group.addToMemberList((HObject)object);
        }
        if (h4Group != null) {
            List list = null;
            try {
                list = h4Group.getMetadata();
            }
            catch (HDFException hDFException) {
                // empty catch block
            }
            if (list != null) {
                try {
                    this.getFileAnnotation(this.fid, list);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
                try {
                    this.getGRglobleAttribute(this.grid, list);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
                try {
                    this.getSDSglobleAttribute(this.sdid, list);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
            }
        }
        return defaultMutableTreeNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depth_first(MutableTreeNode mutableTreeNode, H4Group h4Group) {
        if (h4Group == null && mutableTreeNode == null) {
            return;
        }
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int[] nArray = null;
        int[] nArray2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (mutableTreeNode != null) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode;
            h4Group = (H4Group)((Object)defaultMutableTreeNode2.getUserObject());
        }
        String string = h4Group.getPath() + h4Group.getName() + "/";
        int n5 = h4Group.open();
        if (n5 == -1) {
            return;
        }
        try {
            n = HDFLibrary.Vntagrefs((int)n5);
            nArray = new int[n];
            nArray2 = new int[n];
            n = HDFLibrary.Vgettagrefs((int)n5, (int[])nArray, (int[])nArray2, (int)n);
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        finally {
            h4Group.close(n5);
        }
        int n6 = Math.max(0, this.getStartMembers());
        int n7 = this.getMaxMembers();
        if (n7 >= n) {
            n7 = n;
            n6 = 0;
        }
        n7 += n6;
        n7 = Math.min(n7, n);
        block15: for (int i = n6; i < n7; ++i) {
            n3 = nArray[i];
            n2 = nArray2[i];
            switch (n3) {
                case 202: 
                case 302: 
                case 306: {
                    try {
                        n4 = HDFLibrary.GRreftoindex((int)this.grid, (short)((short)n2));
                    }
                    catch (HDFException hDFException) {
                        n4 = -1;
                    }
                    if (n4 == -1) continue block15;
                    Object object = this.getGRImage(n3, n4, string, true);
                    h4Group.addToMemberList((HObject)object);
                    if (object == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    continue block15;
                }
                case 700: 
                case 702: 
                case 720: {
                    try {
                        n4 = HDFLibrary.SDreftoindex((int)this.sdid, (int)n2);
                    }
                    catch (HDFException hDFException) {
                        n4 = -1;
                    }
                    if (n4 == -1) continue block15;
                    Object object = this.getSDS(n3, n4, string, true);
                    h4Group.addToMemberList((HObject)object);
                    if (object == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    continue block15;
                }
                case 1962: 
                case 1963: {
                    Object object = this.getVdata(n3, n2, string, true);
                    h4Group.addToMemberList((HObject)object);
                    if (object == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    continue block15;
                }
                case 1965: {
                    H4Group h4Group2 = this.getVGroup(n3, n2, string, h4Group, true);
                    h4Group.addToMemberList((HObject)h4Group2);
                    if (h4Group2 == null || defaultMutableTreeNode2 == null) continue block15;
                    defaultMutableTreeNode = new DefaultMutableTreeNode((Object)h4Group2){
                        public static final long serialVersionUID = 240L;

                        public boolean isLeaf() {
                            return false;
                        }
                    };
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    boolean bl = false;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2;
                    while (defaultMutableTreeNode3 != null && !bl) {
                        long[] lArray;
                        H4Group h4Group3 = (H4Group)((Object)defaultMutableTreeNode3.getUserObject());
                        if (h4Group3.equalsOID(lArray = new long[]{n3, n2})) {
                            bl = true;
                            continue;
                        }
                        defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
                    }
                    if (bl) continue block15;
                    this.depth_first(defaultMutableTreeNode, null);
                    continue block15;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4GRImage getGRImage(int n, int n2, String string, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        H4GRImage h4GRImage = null;
        String[] stringArray = new String[]{""};
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{0, 0};
        try {
            n3 = HDFLibrary.GRselect((int)this.grid, (int)n2);
            n4 = HDFLibrary.GRidtoref((int)n3);
            HDFLibrary.GRgetiminfo((int)n3, (String[])stringArray, (int[])nArray, (int[])nArray2);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.GRendaccess((int)n3);
            }
            catch (HDFException hDFException) {}
        }
        if (n3 != -1) {
            long[] lArray = new long[]{n, n4};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            h4GRImage = new H4GRImage(this, stringArray[0], string, lArray);
        }
        return h4GRImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4SDS getSDS(int n, int n2, String string, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        H4SDS h4SDS = null;
        String[] stringArray = new String[]{""};
        int[] nArray = new int[32];
        int[] nArray2 = new int[]{0, 0, 0};
        boolean bl2 = false;
        try {
            n3 = HDFLibrary.SDselect((int)this.sdid, (int)n2);
            if (this.isNetCDF) {
                n4 = n2;
                n = 67687001;
            } else {
                n4 = HDFLibrary.SDidtoref((int)n3);
            }
            HDFLibrary.SDgetinfo((int)n3, (String[])stringArray, (int[])nArray, (int[])nArray2);
            bl2 = HDFLibrary.SDiscoordvar((int)n3);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.SDendaccess((int)n3);
            }
            catch (HDFException hDFException) {}
        }
        if (bl2) {
            stringArray[0] = stringArray[0] + " (dimension)";
        }
        if (n3 != -1) {
            long[] lArray = new long[]{n, n4};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            h4SDS = new H4SDS(this, stringArray[0], string, lArray);
        }
        return h4SDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4Vdata getVdata(int n, int n2, String string, boolean bl) {
        int n3 = -1;
        H4Vdata h4Vdata = null;
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        long[] lArray = new long[]{n, n2};
        if (bl) {
            this.objList.add(lArray);
        } else if (this.find(lArray)) {
            return null;
        }
        try {
            n3 = HDFLibrary.VSattach((int)this.fid, (int)n2, (String)"r");
            HDFLibrary.VSgetclass((int)n3, (String[])stringArray2);
            stringArray2[0] = stringArray2[0].trim();
            HDFLibrary.VSgetname((int)n3, (String[])stringArray);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.VSdetach((int)n3);
            }
            catch (HDFException hDFException) {}
        }
        if (this.showAll || n3 != -1 && !stringArray2[0].equalsIgnoreCase("Attr0.0") && !stringArray2[0].startsWith("_HDF_CHK_TBL_") && !stringArray2[0].equalsIgnoreCase("CDF0.0")) {
            h4Vdata = new H4Vdata(this, stringArray[0], string, lArray);
        }
        return h4Vdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4Group getVGroup(int n, int n2, String string, H4Group h4Group, boolean bl) {
        int n3 = -1;
        H4Group h4Group2 = null;
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        long[] lArray = new long[]{n, n2};
        if (bl) {
            this.objList.add(lArray);
        } else if (this.find(lArray)) {
            return null;
        }
        try {
            n3 = HDFLibrary.Vattach((int)this.fid, (int)n2, (String)"r");
            HDFLibrary.Vgetclass((int)n3, (String[])stringArray2);
            stringArray2[0] = stringArray2[0].trim();
            HDFLibrary.Vgetname((int)n3, (String[])stringArray);
        }
        catch (HDFException hDFException) {
            n3 = -1;
        }
        finally {
            try {
                HDFLibrary.Vdetach((int)n3);
            }
            catch (HDFException hDFException) {}
        }
        if (this.showAll || n3 != -1 && !stringArray2[0].equalsIgnoreCase("RIG0.0") && !stringArray2[0].equalsIgnoreCase("RI0.0") && !stringArray2[0].equalsIgnoreCase("RIATTR0.0N") && !stringArray2[0].equalsIgnoreCase("RIATTR0.0C") && !stringArray2[0].equalsIgnoreCase("CDF0.0")) {
            h4Group2 = new H4Group(this, stringArray[0], string, h4Group, lArray);
        }
        return h4Group2;
    }

    private final boolean find(long[] lArray) {
        boolean bl = false;
        if (this.objList == null) {
            return false;
        }
        int n = this.objList.size();
        long[] lArray2 = null;
        for (int i = 0; i < n; ++i) {
            lArray2 = (long[])this.objList.get(i);
            if (lArray2[0] != lArray[0] || lArray2[1] != lArray[1]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.objList.add(lArray);
        }
        return bl;
    }

    int getGRAccessID() {
        return this.grid;
    }

    int getSDAccessID() {
        return this.sdid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFileAnnotation(int n, List vector) throws HDFException {
        if (n < 0) {
            return vector;
        }
        int n2 = -1;
        try {
            n2 = HDFLibrary.ANstart((int)n);
            int[] nArray = new int[4];
            HDFLibrary.ANfileinfo((int)n2, (int[])nArray);
            if (nArray[0] + nArray[1] <= 0) {
                try {
                    HDFLibrary.ANend((int)n2);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
                Vector<Attribute> vector2 = vector;
                return vector2;
            }
            if (vector == null) {
                vector = new Vector<Attribute>(nArray[0] + nArray[1], 5);
            }
            int n3 = -1;
            int[] nArray2 = new int[]{2, 3};
            for (int i = 0; i < 2; ++i) {
                String string = null;
                string = i == 0 ? "File Label" : "File Description";
                for (int j = 0; j < nArray[i]; ++j) {
                    try {
                        n3 = HDFLibrary.ANselect((int)n2, (int)j, (int)nArray2[i]);
                    }
                    catch (HDFException hDFException) {
                        n3 = -1;
                    }
                    if (n3 == -1) {
                        try {
                            HDFLibrary.ANendaccess((int)n3);
                        }
                        catch (HDFException hDFException) {}
                        continue;
                    }
                    int n4 = 0;
                    try {
                        n4 = HDFLibrary.ANannlen((int)n3) + 1;
                    }
                    catch (HDFException hDFException) {
                        n4 = 0;
                    }
                    if (n4 > 0) {
                        boolean bl = false;
                        String[] stringArray = new String[]{""};
                        try {
                            bl = HDFLibrary.ANreadann((int)n3, (String[])stringArray, (int)n4);
                        }
                        catch (HDFException hDFException) {
                            bl = false;
                        }
                        if (bl && stringArray[0].length() > 0) {
                            long[] lArray = new long[]{stringArray[0].length()};
                            Attribute attribute = new Attribute(string + " #" + j, (Datatype)new H4Datatype(4), lArray);
                            vector.add(attribute);
                            attribute.setValue((Object)stringArray[0]);
                        }
                    }
                    try {
                        HDFLibrary.ANendaccess((int)n3);
                        continue;
                    }
                    catch (HDFException hDFException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            try {
                HDFLibrary.ANend((int)n2);
            }
            catch (HDFException hDFException) {}
        }
        return vector;
    }

    private List getGRglobleAttribute(int n, List vector) throws HDFException {
        if (n == -1) {
            return vector;
        }
        int[] nArray = new int[]{0, 0};
        HDFLibrary.GRfileinfo((int)n, (int[])nArray);
        int n2 = nArray[1];
        if (n2 > 0) {
            if (vector == null) {
                vector = new Vector<Attribute>(n2, 5);
            }
            String[] stringArray = new String[1];
            for (int i = 0; i < n2; ++i) {
                stringArray[0] = "";
                boolean bl = false;
                try {
                    bl = HDFLibrary.GRattrinfo((int)n, (int)i, (String[])stringArray, (int[])nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray[1]};
                Attribute attribute = new Attribute(stringArray[0], (Datatype)new H4Datatype(nArray[0]), lArray);
                vector.add(attribute);
                String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                try {
                    HDFLibrary.GRgetattr((int)n, (int)i, (Object)stringArray2);
                }
                catch (HDFException hDFException) {
                    stringArray2 = null;
                }
                if (stringArray2 == null) continue;
                if (nArray[0] == 4 || nArray[0] == 3) {
                    stringArray2 = Dataset.byteToString((byte[])((byte[])stringArray2), (int)nArray[1]);
                }
                attribute.setValue((Object)stringArray2);
            }
        }
        return vector;
    }

    private List getSDSglobleAttribute(int n, List vector) throws HDFException {
        if (n == -1) {
            return vector;
        }
        int[] nArray = new int[]{0, 0};
        HDFLibrary.SDfileinfo((int)n, (int[])nArray);
        int n2 = nArray[1];
        if (n2 > 0) {
            if (vector == null) {
                vector = new Vector<Attribute>(n2, 5);
            }
            String[] stringArray = new String[1];
            for (int i = 0; i < n2; ++i) {
                stringArray[0] = "";
                boolean bl = false;
                try {
                    bl = HDFLibrary.SDattrinfo((int)n, (int)i, (String[])stringArray, (int[])nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray[1]};
                Attribute attribute = new Attribute(stringArray[0], (Datatype)new H4Datatype(nArray[0]), lArray);
                vector.add(attribute);
                String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                try {
                    HDFLibrary.SDreadattr((int)n, (int)i, (Object)stringArray2);
                }
                catch (HDFException hDFException) {
                    stringArray2 = null;
                }
                if (stringArray2 == null) continue;
                if (nArray[0] == 4 || nArray[0] == 3) {
                    stringArray2 = Dataset.byteToString((byte[])((byte[])stringArray2), (int)nArray[1]);
                }
                attribute.setValue((Object)stringArray2);
            }
        }
        return vector;
    }

    public String getLibversion() {
        int[] nArray = new int[3];
        String string = "HDF ";
        String[] stringArray = new String[]{""};
        try {
            HDFLibrary.Hgetlibversion((int[])nArray, (String[])stringArray);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        string = string + nArray[0] + "." + nArray[1] + "." + nArray[2];
        return string;
    }

    private boolean isNetCDF(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray = new byte[4];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            bl = byArray[0] == 67 && byArray[1] == 68 && byArray[2] == 70 && byArray[3] == 1;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public HObject get(String string) throws Exception {
        if (this.objList == null) {
            this.objList = new Vector();
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (!(string = string.replace('\\', '/')).startsWith("/")) {
            string = "/" + string;
        }
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (string.equals("/")) {
            string2 = "/";
            bl = true;
        } else {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 2);
            }
            int n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
            string3 = n == 0 ? "/" : string.substring(0, n);
        }
        H4Group h4Group = null;
        this.isReadOnly = false;
        if (this.fid < 0) {
            this.fid = HDFLibrary.Hopen((String)this.fullFileName, (int)2);
            if (this.fid < 0) {
                this.isReadOnly = true;
                this.fid = HDFLibrary.Hopen((String)this.fullFileName, (int)1);
            }
            HDFLibrary.Vstart((int)this.fid);
            this.grid = HDFLibrary.GRstart((int)this.fid);
            this.sdid = HDFLibrary.SDstart((String)this.fullFileName, (int)this.flag);
        }
        h4Group = bl ? this.getRootGroup() : this.getAttachedObject(string3, string2);
        return h4Group;
    }

    private H4Group getRootGroup() {
        Object object;
        int n;
        H4Group h4Group = null;
        long[] lArray = new long[]{0L, 0L};
        int n2 = 0;
        int n3 = -1;
        int[] nArray = null;
        h4Group = new H4Group(this, "/", null, null, lArray);
        int[] nArray2 = new int[1];
        int[] nArray3 = null;
        try {
            n2 = HDFLibrary.Vlone((int)this.fid, (int[])nArray2, (int)0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.Vlone((int)this.fid, (int[])nArray3, (int)n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        for (n = 0; n < n2; ++n) {
            n3 = nArray3[n];
            H4Group h4Group2 = this.getVGroup(1965, n3, "/", h4Group, false);
            if (h4Group2 == null) continue;
            h4Group.addToMemberList((HObject)h4Group2);
        }
        nArray = new int[2];
        n = 0;
        try {
            n = HDFLibrary.GRfileinfo((int)this.grid, (int[])nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                object = this.getGRImage(306, i, "/", false);
                if (object == null) continue;
                h4Group.addToMemberList((HObject)object);
            }
        }
        try {
            n = HDFLibrary.SDfileinfo((int)this.sdid, (int[])nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        if (n != 0) {
            n2 = nArray[0];
            for (int i = 0; i < n2; ++i) {
                object = this.getSDS(720, i, "/", false);
                if (object == null) continue;
                h4Group.addToMemberList((HObject)object);
            }
        }
        try {
            n2 = HDFLibrary.VSlone((int)this.fid, (int[])nArray2, (int)0);
            nArray3 = new int[n2];
            n2 = HDFLibrary.VSlone((int)this.fid, (int[])nArray3, (int)n2);
        }
        catch (HDFException hDFException) {
            n2 = 0;
        }
        for (int i = 0; i < n2; ++i) {
            n3 = nArray3[i];
            object = this.getVdata(1963, n3, "/", false);
            if (object == null) continue;
            h4Group.addToMemberList((HObject)object);
        }
        if (h4Group != null) {
            List list = null;
            try {
                list = h4Group.getMetadata();
            }
            catch (HDFException hDFException) {
                // empty catch block
            }
            if (list != null) {
                try {
                    this.getFileAnnotation(this.fid, list);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
                try {
                    this.getGRglobleAttribute(this.grid, list);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
                try {
                    this.getSDSglobleAttribute(this.sdid, list);
                }
                catch (HDFException hDFException) {
                    // empty catch block
                }
            }
        }
        return h4Group;
    }

    private HObject getAttachedObject(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            return null;
        }
        HObject hObject = null;
        String[] stringArray = new String[]{""};
        int n = -1;
        try {
            n = HDFLibrary.GRnametoindex((int)this.grid, (String)string2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n >= 0) {
            return this.getGRImage(306, n, "/", false);
        }
        try {
            n = HDFLibrary.SDnametoindex((int)this.sdid, (String)string2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n >= 0) {
            return this.getSDS(720, n, "/", false);
        }
        int n2 = 0;
        try {
            n2 = HDFLibrary.Vfind((int)this.fid, (String)string2);
        }
        catch (HDFException hDFException) {
            n2 = -1;
        }
        if (n2 > 0) {
            long[] lArray = new long[]{1965L, n2};
            H4Group h4Group = new H4Group(this, stringArray[0], string, null, lArray);
            this.depth_first(null, h4Group);
            return h4Group;
        }
        try {
            n2 = HDFLibrary.VSfind((int)this.fid, (String)string2);
        }
        catch (HDFException hDFException) {
            n2 = -1;
        }
        if (n2 > 0) {
            return this.getVdata(1963, n2, "/", false);
        }
        return hObject;
    }
}

