/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFDeflateCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4GRImage
extends ScalarDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private int grid;
    private int ncomp;
    private int datatypeID = -1;

    public H4GRImage(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H4GRImage(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.palette = null;
        this.isImageDisplay = true;
        this.isImage = true;
        this.unsignedConverted = false;
        if (fileFormat instanceof H4File) {
            this.grid = ((H4File)fileFormat).getGRAccessID();
            int n = this.open();
            String[] stringArray = new String[]{""};
            int[] nArray = new int[4];
            int[] nArray2 = new int[2];
            try {
                HDFLibrary.GRgetiminfo((int)n, (String[])stringArray, (int[])nArray, (int[])nArray2);
                this.hasAttribute = nArray[3] > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close(n);
        }
    }

    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        H4GRImage h4GRImage = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        int[] nArray = null;
        if (group == null) {
            return null;
        }
        string2 = group.isRoot() ? "/" : group.getPath() + group.getName() + "/";
        n = this.open();
        if (n < 0) {
            return null;
        }
        if (lArray != null) {
            nArray = new int[]{(int)lArray[0], (int)lArray[1]};
        }
        int[] nArray2 = new int[4];
        try {
            String[] stringArray = new String[]{""};
            int[] nArray3 = new int[2];
            HDFLibrary.GRgetiminfo((int)n, (String[])stringArray, (int[])nArray2, (int[])nArray3);
            if (nArray == null) {
                nArray = nArray3;
            }
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        n2 = HDFLibrary.GRcreate((int)((H4File)group.getFileFormat()).getGRAccessID(), (String)string, (int)n3, (int)n4, (int)n5, (int[])nArray);
        if (n2 < 0) {
            return null;
        }
        short s = HDFLibrary.GRidtoref((int)n2);
        if (!group.isRoot()) {
            int n7 = group.open();
            HDFLibrary.Vaddtagref((int)n7, (int)306, (int)s);
            group.close(n7);
        }
        int[] nArray4 = new int[]{0, 0};
        if (object == null) {
            object = new byte[nArray[0] * nArray[1] * HDFLibrary.DFKNTsize((int)n4)];
            HDFLibrary.GRreadimage((int)n, (int[])nArray4, null, (int[])nArray, (Object)object);
        }
        HDFLibrary.GRwriteimage((int)n2, (int[])nArray4, null, (int[])nArray, (Object)object);
        int n8 = HDFLibrary.GRgetlutid((int)n, (int)0);
        int[] nArray5 = new int[4];
        HDFLibrary.GRgetlutinfo((int)n8, (int[])nArray5);
        nArray5[1] = 21;
        int n9 = nArray5[0] * nArray5[3];
        byte[] byArray = new byte[n9];
        HDFLibrary.GRreadlut((int)n8, (byte[])byArray);
        n8 = HDFLibrary.GRgetlutid((int)n2, (int)0);
        HDFLibrary.GRwritelut((int)n8, (int)nArray5[0], (int)nArray5[1], (int)nArray5[2], (int)nArray5[3], (byte[])byArray);
        this.copyAttribute(n, n2, n6);
        long[] lArray2 = new long[]{306L, s};
        h4GRImage = new H4GRImage(group.getFileFormat(), string, string2, lArray2);
        group.addToMemberList((HObject)h4GRImage);
        this.close(n);
        try {
            HDFLibrary.GRendaccess((int)n2);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        return h4GRImage;
    }

    public byte[][] readPalette(int n) {
        return null;
    }

    public byte[] getPaletteRefs() {
        return null;
    }

    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(this.datatypeID);
        }
        return this.datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws HDFException {
        int n;
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((n = this.open()) < 0) {
            return null;
        }
        try {
            HDFLibrary.GRreqimageil((int)n, (int)this.interlace);
            int n2 = this.getWidth() * this.getHeight() * this.ncomp;
            int n3 = HDFLibrary.DFKNTsize((int)this.datatypeID) * n2;
            byArray = new byte[n3];
            int[] nArray = new int[]{(int)this.startDims[0], (int)this.startDims[1]};
            int[] nArray2 = new int[]{(int)this.selectedDims[0], (int)this.selectedDims[1]};
            int[] nArray3 = null;
            if (this.selectedStride != null) {
                nArray3 = new int[this.rank];
                for (int i = 0; i < this.rank; ++i) {
                    nArray3[i] = (int)this.selectedStride[i];
                }
            }
            HDFLibrary.GRreadimage((int)n, (int[])nArray, (int[])nArray3, (int[])nArray2, (byte[])byArray);
        }
        finally {
            this.close(n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read() throws HDFException {
        int n;
        Object object = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((n = this.open()) < 0) {
            return null;
        }
        try {
            HDFLibrary.GRreqimageil((int)n, (int)this.interlace);
            int n2 = this.getWidth() * this.getHeight() * this.ncomp;
            object = H4Datatype.allocateArray(this.datatypeID, n2);
            if (object != null) {
                HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
                int[] nArray = new int[]{(int)this.startDims[0], (int)this.startDims[1]};
                int[] nArray2 = new int[]{(int)this.selectedDims[0], (int)this.selectedDims[1]};
                int[] nArray3 = null;
                if (this.selectedStride != null) {
                    nArray3 = new int[this.rank];
                    for (int i = 0; i < this.rank; ++i) {
                        nArray3[i] = (int)this.selectedStride[i];
                    }
                }
                HDFLibrary.GRreadimage((int)n, (int[])nArray, (int[])nArray3, (int[])nArray2, (Object)object);
            }
        }
        finally {
            this.close(n);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object) throws HDFException {
        if (object == null) {
            return;
        }
        int n = this.open();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                nArray3[i] = (int)this.selectedStride[i];
            }
        }
        Object object2 = object;
        try {
            if (this.isUnsigned && this.unsignedConverted) {
                object2 = H4GRImage.convertToUnsignedC((Object)object);
            }
            HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
            HDFLibrary.GRwriteimage((int)n, (int[])nArray2, (int[])nArray3, (int[])nArray, (Object)object2);
        }
        finally {
            object2 = null;
            this.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = this.open();
        String[] stringArray = new String[]{""};
        int[] nArray = new int[4];
        int[] nArray2 = new int[2];
        try {
            HDFLibrary.GRgetiminfo((int)n, (String[])stringArray, (int[])nArray, (int[])nArray2);
            nArray[1] = nArray[1] & 0xFFFFBFFF;
            int n2 = nArray[3];
            if (this.attributeList == null && n2 > 0) {
                this.attributeList = new Vector(n2, 5);
            }
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[]{0, 0};
            for (int i = 0; i < n2; ++i) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.GRattrinfo((int)n, (int)i, (String[])stringArray2, (int[])nArray3);
                    nArray3[0] = nArray3[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray3[1]};
                Attribute attribute = new Attribute(stringArray2[0], (Datatype)new H4Datatype(nArray3[0]), lArray);
                this.attributeList.add(attribute);
                String[] stringArray3 = H4Datatype.allocateArray(nArray3[0], nArray3[1]);
                try {
                    HDFLibrary.GRgetattr((int)n, (int)i, (Object)stringArray3);
                }
                catch (HDFException hDFException) {
                    stringArray3 = null;
                }
                if (stringArray3 == null) continue;
                if (nArray3[0] == 4 || nArray3[0] == 3) {
                    stringArray3 = Dataset.byteToString((byte[])((byte[])stringArray3), (int)nArray3[1]);
                }
                attribute.setValue((Object)stringArray3);
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute((HObject)this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    public void removeMetadata(Object object) throws HDFException {
    }

    public int open() {
        int n = -1;
        try {
            int n2 = HDFLibrary.GRreftoindex((int)this.grid, (short)((short)this.oid[1]));
            n = HDFLibrary.GRselect((int)this.grid, (int)n2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        return n;
    }

    public void close(int n) {
        try {
            HDFLibrary.GRendaccess((int)n);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int n = this.open();
        String[] stringArray = new String[]{""};
        int[] nArray = new int[4];
        int[] nArray2 = new int[2];
        try {
            HDFCompInfo hDFCompInfo;
            HDFLibrary.GRgetiminfo((int)n, (String[])stringArray, (int[])nArray, (int[])nArray2);
            nArray[1] = nArray[1] & 0xFFFFBFFF;
            this.datatypeID = nArray[1];
            try {
                hDFCompInfo = new HDFCompInfo();
                boolean bl = HDFLibrary.GRgetcompress((int)n, (HDFCompInfo)hDFCompInfo);
                if (hDFCompInfo.ctype == 4) {
                    this.compression = "GZIP";
                } else if (hDFCompInfo.ctype == 5) {
                    this.compression = "SZIP";
                } else if (hDFCompInfo.ctype == 7) {
                    this.compression = "JPEG";
                } else if (hDFCompInfo.ctype == 3) {
                    this.compression = "SKPHUFF";
                } else if (hDFCompInfo.ctype == 1) {
                    this.compression = "RLE";
                } else if (hDFCompInfo.ctype == 2) {
                    this.compression = "NBIT";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hDFCompInfo = new HDFChunkInfo();
                int[] nArray3 = new int[]{0};
                boolean bl = HDFLibrary.GRgetchunkinfo((int)n, (HDFChunkInfo)hDFCompInfo, (int[])nArray3);
                if (nArray3[0] == 0) {
                    this.chunkSize = null;
                } else {
                    this.chunkSize = new long[this.rank];
                    for (int i = 0; i < this.rank; ++i) {
                        this.chunkSize[i] = hDFCompInfo.chunk_lengths[i];
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (HDFException hDFException) {
        }
        finally {
            this.close(n);
        }
        this.isUnsigned = H4Datatype.isUnsigned(this.datatypeID);
        if (nArray2 == null) {
            return;
        }
        this.ncomp = nArray[0];
        this.isTrueColor = this.ncomp >= 3;
        this.interlace = nArray[2];
        this.rank = 2;
        this.selectedIndex[0] = 1;
        this.selectedIndex[1] = 0;
        this.dims = new long[this.rank];
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = nArray2[i];
            this.dims[i] = nArray2[i];
        }
    }

    public byte[][] getPalette() {
        if (this.palette != null) {
            return this.palette;
        }
        int n = this.open();
        if (n < 0) {
            return null;
        }
        int n2 = -1;
        int[] nArray = new int[4];
        try {
            n2 = HDFLibrary.GRgetlutid((int)n, (int)0);
            HDFLibrary.GRgetlutinfo((int)n2, (int[])nArray);
        }
        catch (HDFException hDFException) {
            this.close(n);
            return null;
        }
        if (nArray[0] != 3 || nArray[2] < 0 | nArray[3] != 256) {
            this.close(n);
            return null;
        }
        boolean bl = false;
        byte[] byArray = new byte[768];
        try {
            HDFLibrary.GRreqlutil((int)n, (int)nArray[2]);
            bl = HDFLibrary.GRreadlut((int)n2, (byte[])byArray);
        }
        catch (HDFException hDFException) {
            bl = false;
        }
        if (!bl) {
            this.close(n);
            return null;
        }
        this.palette = new byte[3][256];
        if (nArray[2] == 0) {
            for (int i = 0; i < 256; ++i) {
                this.palette[0][i] = byArray[i * 3];
                this.palette[1][i] = byArray[i * 3 + 1];
                this.palette[2][i] = byArray[i * 3 + 2];
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                this.palette[0][i] = byArray[i];
                this.palette[1][i] = byArray[256 + i];
                this.palette[2][i] = byArray[512 + i];
            }
        }
        this.close(n);
        return this.palette;
    }

    public int getComponentCount() {
        return this.ncomp;
    }

    public static H4GRImage create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        Object object2;
        int n4;
        H4GRImage h4GRImage = null;
        if (string == null || group == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H4File h4File = (H4File)group.getFileFormat();
        if (h4File == null) {
            return null;
        }
        String string2 = "/";
        if (!group.isRoot()) {
            string2 = group.getPath() + group.getName() + "/";
        }
        n3 = n3 == 2 ? 2 : 0;
        int n5 = 2;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = (int)lArray[i];
            nArray2[i] = lArray2 != null ? (int)lArray2[i] : nArray[i];
            nArray3[i] = 0;
        }
        int[] nArray4 = null;
        if (lArray3 != null) {
            nArray4 = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray4[n4] = (int)lArray3[n4];
            }
        }
        int n6 = h4File.getGRAccessID();
        int n7 = datatype.toNative();
        n4 = HDFLibrary.GRcreate((int)n6, (String)string, (int)n2, (int)n7, (int)n3, (int[])nArray);
        if (n4 < 0) {
            throw new HDFException("Unable to create the new dataset.");
        }
        if (n4 > 0 && object != null) {
            HDFLibrary.GRwriteimage((int)n4, (int[])nArray3, null, (int[])nArray, (Object)object);
        }
        if (lArray3 != null) {
            HDFChunkInfo hDFChunkInfo = new HDFChunkInfo(nArray4);
            HDFLibrary.GRsetchunk((int)n4, (HDFChunkInfo)hDFChunkInfo, (int)1);
        }
        if (n > 0) {
            int n8 = 4;
            object2 = new HDFDeflateCompInfo();
            object2.level = n;
            HDFLibrary.GRsetcompress((int)n4, (int)n8, (HDFCompInfo)object2);
        }
        short s = HDFLibrary.GRidtoref((int)n4);
        if (!group.isRoot()) {
            int n9 = group.open();
            if (n9 < 0) {
                if (n4 > 0) {
                    HDFLibrary.GRendaccess((int)n4);
                }
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vaddtagref((int)n9, (int)302, (int)s);
            group.close(n9);
        }
        try {
            if (n4 > 0) {
                HDFLibrary.GRendaccess((int)n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = new long[]{720L, s};
        h4GRImage = new H4GRImage(h4File, string, string2, (long[])object2);
        if (h4GRImage != null) {
            group.addToMemberList((HObject)h4GRImage);
        }
        return h4GRImage;
    }

    private void copyAttribute(int n, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        try {
            boolean bl = false;
            String[] stringArray = new String[1];
            int[] nArray = new int[]{0, 0};
            for (int i = 0; i < n3; ++i) {
                stringArray[0] = "";
                try {
                    bl = HDFLibrary.GRattrinfo((int)n, (int)i, (String[])stringArray, (int[])nArray);
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                byte[] byArray = new byte[nArray[1] * HDFLibrary.DFKNTsize((int)nArray[0])];
                try {
                    HDFLibrary.GRgetattr((int)n, (int)i, (byte[])byArray);
                }
                catch (Exception exception) {
                    byArray = null;
                }
                if (byArray == null) continue;
                HDFLibrary.GRsetattr((int)n2, (String)stringArray[0], (int)nArray[0], (int)nArray[1], (byte[])byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

