/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4Group
extends Group {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private static final long[] DEFAULT_OID = new long[]{0L, 0L};

    public H4Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    public H4Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, group, lArray == null ? DEFAULT_OID : lArray);
        if (fileFormat instanceof H4File) {
            int n = this.open();
            try {
                this.hasAttribute = HDFLibrary.Vnattrs((int)n) > 0;
                this.nMembersInFile = HDFLibrary.Vntagrefs((int)n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        this.attributeList = new Vector();
        int n = this.open();
        if (n <= 0) {
            return this.attributeList;
        }
        int n2 = -1;
        try {
            n2 = HDFLibrary.Vnattrs((int)n);
            boolean bl = false;
            String[] stringArray = new String[1];
            int[] nArray = new int[3];
            for (int i = 0; i < n2; ++i) {
                stringArray[0] = "";
                try {
                    bl = HDFLibrary.Vattrinfo((int)n, (int)i, (String[])stringArray, (int[])nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray[1]};
                Attribute attribute = new Attribute(stringArray[0], (Datatype)new H4Datatype(nArray[0]), lArray);
                this.attributeList.add(attribute);
                String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                try {
                    HDFLibrary.Vgetattr((int)n, (int)i, (Object)stringArray2);
                }
                catch (HDFException hDFException) {
                    stringArray2 = null;
                }
                if (stringArray2 == null) continue;
                if (nArray[0] == 4 || nArray[0] == 3) {
                    stringArray2 = Dataset.byteToString((byte[])((byte[])stringArray2), (int)nArray[1]);
                }
                attribute.setValue((Object)stringArray2);
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute((HObject)this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    public void removeMetadata(Object object) throws HDFException {
    }

    public int open() {
        int n = -1;
        try {
            n = HDFLibrary.Vattach((int)this.getFID(), (int)((int)this.oid[1]), (String)"w");
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n < 0) {
            try {
                n = HDFLibrary.Vattach((int)this.getFID(), (int)((int)this.oid[1]), (String)"r");
            }
            catch (HDFException hDFException) {
                n = -1;
            }
        }
        return n;
    }

    public void close(int n) {
        try {
            HDFLibrary.Vdetach((int)n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static H4Group create(String string, Group group) throws Exception {
        int n;
        H4Group h4Group = null;
        if (group == null || string == null) {
            return null;
        }
        H4File h4File = (H4File)group.getFileFormat();
        if (h4File == null) {
            return null;
        }
        String string2 = "/";
        if (!group.isRoot()) {
            string2 = group.getPath() + group.getName() + "/";
        }
        if ((n = h4File.open()) < 0) {
            return null;
        }
        int n2 = HDFLibrary.Vattach((int)n, (int)-1, (String)"w");
        if (n2 < 0) {
            return null;
        }
        HDFLibrary.Vsetname((int)n2, (String)string);
        int n3 = HDFLibrary.VQueryref((int)n2);
        int n4 = HDFLibrary.VQuerytag((int)n2);
        if (!group.isRoot()) {
            int n5 = group.open();
            if (n5 < 0) {
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vinsert((int)n5, (int)n2);
            group.close(n5);
        }
        try {
            HDFLibrary.Vdetach((int)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long[] lArray = new long[]{n4, n3};
        h4Group = new H4Group(h4File, string, string2, group, lArray);
        if (h4Group != null) {
            group.addToMemberList((HObject)h4Group);
        }
        return h4Group;
    }
}

