/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFDeflateCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4SDS
extends ScalarDS {
    public static final long serialVersionUID = 240L;
    public static final int DFTAG_NDG_NETCDF = 67687001;
    private List attributeList;
    private int sdid;
    private int datatypeID = -1;

    public H4SDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H4SDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.unsignedConverted = false;
        if (fileFormat instanceof H4File) {
            this.sdid = ((H4File)fileFormat).getSDAccessID();
            this.init();
        }
    }

    public byte[][] readPalette(int n) {
        return null;
    }

    public byte[] getPaletteRefs() {
        return null;
    }

    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(this.datatypeID);
        }
        return this.datatype;
    }

    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        int n;
        H4SDS h4SDS = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        int n6 = 2;
        String string2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (group == null) {
            return null;
        }
        if (string == null) {
            string = this.getName();
        }
        string2 = group.isRoot() ? "/" : group.getPath() + group.getName() + "/";
        n2 = this.open();
        if (n2 < 0) {
            return null;
        }
        if (lArray == null) {
            n6 = this.getRank();
            if (n6 <= 0) {
                this.init();
            }
            n6 = this.getRank();
            lArray = this.getDims();
        } else {
            n6 = lArray.length;
        }
        nArray2 = new int[n6];
        nArray = new int[n6];
        for (n = 0; n < n6; ++n) {
            nArray2[n] = 0;
            nArray[n] = (int)lArray[n];
            n5 *= nArray[n];
        }
        n4 = this.datatypeID;
        n3 = HDFLibrary.SDcreate((int)((H4File)group.getFileFormat()).getSDAccessID(), (String)string, (int)n4, (int)n6, (int[])nArray);
        if (n3 < 0) {
            return null;
        }
        n = HDFLibrary.SDidtoref((int)n3);
        if (!group.isRoot()) {
            int n7 = group.open();
            HDFLibrary.Vaddtagref((int)n7, (int)720, (int)n);
            group.close(n7);
        }
        this.copyAttribute(n2, n3);
        if (object == null) {
            object = new byte[n5 * HDFLibrary.DFKNTsize((int)n4)];
            HDFLibrary.SDreaddata((int)n2, (int[])nArray2, null, (int[])nArray, (Object)object);
        }
        HDFLibrary.SDwritedata((int)n3, (int[])nArray2, null, (int[])nArray, (Object)object);
        long[] lArray2 = new long[]{720L, n};
        h4SDS = new H4SDS(group.getFileFormat(), string, string2, lArray2);
        group.addToMemberList((HObject)h4SDS);
        this.close(n2);
        try {
            HDFLibrary.SDendaccess((int)n3);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        return h4SDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws HDFException {
        int n;
        int n2;
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((n2 = this.open()) < 0) {
            return null;
        }
        int n3 = 1;
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            n3 *= (int)this.selectedDims[i];
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (n = 0; n < this.rank; ++n) {
                nArray3[n] = (int)this.selectedStride[n];
            }
        }
        try {
            n = HDFLibrary.DFKNTsize((int)this.datatypeID) * n3;
            byArray = new byte[n];
            HDFLibrary.SDreaddata((int)n2, (int[])nArray2, (int[])nArray3, (int[])nArray, (byte[])byArray);
        }
        finally {
            this.close(n2);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read() throws HDFException {
        int n;
        int n2;
        String[] stringArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((n2 = this.open()) < 0) {
            return null;
        }
        int n3 = 1;
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            n3 *= (int)this.selectedDims[i];
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (n = 0; n < this.rank; ++n) {
                nArray3[n] = (int)this.selectedStride[n];
            }
        }
        try {
            stringArray = H4Datatype.allocateArray(this.datatypeID, n3);
            if (stringArray != null) {
                HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
                n = HDFLibrary.SDreaddata((int)n2, (int[])nArray2, (int[])nArray3, (int[])nArray, (Object)stringArray) ? 1 : 0;
                if (this.isText) {
                    stringArray = H4SDS.byteToString((byte[])((byte[])stringArray), (int)nArray[0]);
                }
            }
        }
        finally {
            this.close(n2);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object) throws HDFException {
        if (object == null) {
            return;
        }
        int n = this.open();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            nArray[i] = (int)this.selectedDims[i];
            nArray2[i] = (int)this.startDims[i];
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                nArray3[i] = (int)this.selectedStride[i];
            }
        }
        Object object2 = object;
        try {
            if (this.isUnsigned && this.unsignedConverted) {
                object2 = H4SDS.convertToUnsignedC((Object)object);
            }
            HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
            HDFLibrary.SDwritedata((int)n, (int[])nArray2, (int[])nArray3, (int[])nArray, (Object)object2);
        }
        finally {
            object2 = null;
            this.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = this.open();
        String[] stringArray = new String[]{""};
        int[] nArray = new int[]{0, 0, 0};
        try {
            int[] nArray2 = new int[32];
            HDFLibrary.SDgetinfo((int)n, (String[])stringArray, (int[])nArray2, (int[])nArray);
            int n2 = nArray[2];
            if (this.attributeList == null && n2 > 0) {
                this.attributeList = new Vector(n2, 5);
            }
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[]{0, 0};
            for (int i = 0; i < n2; ++i) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.SDattrinfo((int)n, (int)i, (String[])stringArray2, (int[])nArray3);
                    nArray3[0] = nArray3[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                long[] lArray = new long[]{nArray3[1]};
                Attribute attribute = new Attribute(stringArray2[0], (Datatype)new H4Datatype(nArray3[0]), lArray);
                this.attributeList.add(attribute);
                String[] stringArray3 = H4Datatype.allocateArray(nArray3[0], nArray3[1]);
                try {
                    HDFLibrary.SDreadattr((int)n, (int)i, (Object)stringArray3);
                }
                catch (HDFException hDFException) {
                    stringArray3 = null;
                }
                if (stringArray3 == null) continue;
                if (nArray3[0] == 4 || nArray3[0] == 3) {
                    stringArray3 = Dataset.byteToString((byte[])((byte[])stringArray3), (int)nArray3[1]);
                }
                attribute.setValue((Object)stringArray3);
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute((HObject)this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    public void removeMetadata(Object object) throws HDFException {
    }

    public int open() {
        int n = -1;
        try {
            int n2 = 0;
            int n3 = (int)this.oid[0];
            n2 = n3 == 67687001 ? (int)this.oid[1] : HDFLibrary.SDreftoindex((int)this.sdid, (int)((int)this.oid[1]));
            n = HDFLibrary.SDselect((int)this.sdid, (int)n2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        return n;
    }

    public void close(int n) {
        try {
            HDFLibrary.SDendaccess((int)n);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int n = this.open();
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        int[] nArray = new int[]{0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0};
        int[] nArray3 = new int[32];
        try {
            HDFCompInfo hDFCompInfo;
            int n2;
            HDFLibrary.SDgetinfo((int)n, (String[])stringArray, (int[])nArray3, (int[])nArray2);
            nArray2[1] = nArray2[1] & 0xFFFFBFFF;
            this.hasAttribute = nArray2[2] > 0;
            this.rank = nArray2[0];
            if (this.rank <= 0) {
                this.rank = 1;
                nArray3[0] = 1;
            }
            this.datatypeID = nArray2[1];
            this.isText = this.datatypeID == 4 || this.datatypeID == 3;
            try {
                this.dimNames = new String[this.rank];
                for (int i = 0; i < this.rank; ++i) {
                    n2 = HDFLibrary.SDgetdimid((int)n, (int)i);
                    HDFLibrary.SDdiminfo((int)n2, (String[])stringArray2, (int[])nArray);
                    this.dimNames[i] = stringArray2[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hDFCompInfo = new HDFCompInfo();
                n2 = HDFLibrary.SDgetcompress((int)n, (HDFCompInfo)hDFCompInfo);
                if (hDFCompInfo.ctype == 4) {
                    this.compression = "GZIP";
                } else if (hDFCompInfo.ctype == 5) {
                    this.compression = "SZIP";
                } else if (hDFCompInfo.ctype == 7) {
                    this.compression = "JPEG";
                } else if (hDFCompInfo.ctype == 3) {
                    this.compression = "SKPHUFF";
                } else if (hDFCompInfo.ctype == 1) {
                    this.compression = "RLE";
                } else if (hDFCompInfo.ctype == 2) {
                    this.compression = "NBIT";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n3;
                hDFCompInfo = new HDFChunkInfo();
                int[] nArray4 = new int[]{0};
                try {
                    n3 = HDFLibrary.SDgetchunkinfo((int)n, (HDFChunkInfo)hDFCompInfo, (int[])nArray4);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (nArray4[0] == 0) {
                    this.chunkSize = null;
                } else {
                    this.chunkSize = new long[this.rank];
                    for (n3 = 0; n3 < this.rank; ++n3) {
                        this.chunkSize[n3] = hDFCompInfo.chunk_lengths[n3];
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (HDFException hDFException) {
        }
        finally {
            this.close(n);
        }
        this.isUnsigned = H4Datatype.isUnsigned(this.datatypeID);
        if (nArray3 == null) {
            return;
        }
        this.dims = new long[this.rank];
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            this.dims[i] = nArray3[i];
        }
        this.selectedIndex[0] = 0;
        this.selectedIndex[1] = 1;
        this.selectedIndex[2] = 2;
        if (this.rank == 1) {
            this.selectedDims[0] = this.dims[0];
        }
        if (this.rank > 1) {
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.isText ? 1L : this.dims[1];
        }
    }

    public byte[][] getPalette() {
        return this.palette;
    }

    public static H4SDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        int n2;
        H4SDS h4SDS = null;
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H4File h4File = (H4File)group.getFileFormat();
        if (h4File == null) {
            return null;
        }
        String string2 = "/";
        if (!group.isRoot()) {
            string2 = group.getPath() + group.getName() + "/";
        }
        int n3 = 1;
        int n4 = lArray.length;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = (int)lArray[i];
            nArray2[i] = 0;
            n3 *= nArray[i];
        }
        if (lArray2 != null && lArray2[0] < 0L) {
            nArray[0] = 0;
        }
        int[] nArray3 = null;
        if (lArray3 != null) {
            nArray3 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray3[n2] = (int)lArray3[n2];
            }
        }
        n2 = h4File.getSDAccessID();
        int n5 = datatype.toNative();
        int n6 = HDFLibrary.SDcreate((int)n2, (String)string, (int)n5, (int)n4, (int[])nArray);
        int n7 = HDFLibrary.DFKNTsize((int)n5);
        Object object2 = new byte[n7];
        for (int i = 0; i < n7; ++i) {
            object2[i] = 0;
        }
        HDFLibrary.SDsetfillvalue((int)n6, (byte[])object2);
        if (n6 < 0) {
            throw new HDFException("Unable to create the new dataset.");
        }
        if (n6 > 0 && object != null) {
            HDFLibrary.SDwritedata((int)n6, (int[])nArray2, null, (int[])nArray, (Object)object);
        }
        if (lArray3 != null) {
            HDFChunkInfo hDFChunkInfo = new HDFChunkInfo(nArray3);
            HDFLibrary.SDsetchunk((int)n6, (HDFChunkInfo)hDFChunkInfo, (int)1);
        }
        if (n > 0) {
            n7 = 4;
            object2 = new HDFDeflateCompInfo();
            object2.level = n;
            HDFLibrary.SDsetcompress((int)n6, (int)n7, (HDFCompInfo)object2);
        }
        n7 = HDFLibrary.SDidtoref((int)n6);
        if (!group.isRoot()) {
            int n8 = group.open();
            if (n8 < 0) {
                if (n6 > 0) {
                    HDFLibrary.SDendaccess((int)n6);
                }
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vaddtagref((int)n8, (int)720, (int)n7);
            group.close(n8);
        }
        try {
            if (n6 > 0) {
                HDFLibrary.SDendaccess((int)n6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = new long[]{720L, n7};
        h4SDS = new H4SDS(h4File, string, string2, (long[])object2);
        if (h4SDS != null) {
            group.addToMemberList((HObject)h4SDS);
        }
        return h4SDS;
    }

    private void copyAttribute(int n, int n2) {
        try {
            String[] stringArray = new String[]{""};
            int[] nArray = new int[]{0, 0, 0};
            int[] nArray2 = new int[32];
            HDFLibrary.SDgetinfo((int)n, (String[])stringArray, (int[])nArray2, (int[])nArray);
            int n3 = nArray[2];
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[]{0, 0};
            for (int i = 0; i < n3; ++i) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.SDattrinfo((int)n, (int)i, (String[])stringArray2, (int[])nArray3);
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (!bl) continue;
                byte[] byArray = new byte[nArray3[1] * HDFLibrary.DFKNTsize((int)nArray3[0])];
                try {
                    HDFLibrary.SDreadattr((int)n, (int)i, (byte[])byArray);
                }
                catch (HDFException hDFException) {
                    byArray = null;
                }
                if (byArray == null) continue;
                HDFLibrary.SDsetattr((int)n2, (String)stringArray2[0], (int)nArray3[0], (int)nArray3[1], (byte[])byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

