/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junitx.util.PrivateAccessor;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.Population;
import org.jgap.impl.DefaultConfiguration;

public abstract class JGAPTestCase
extends TestCase {
    private static final String CVS_REVISION = "$Revision: 1.21 $";
    protected static final double DELTA = 1.0E-7;
    public static final PrivateAccessor privateAccessor = null;
    public Configuration conf;

    public JGAPTestCase(String a_name) {
        super(a_name);
    }

    public JGAPTestCase() {
    }

    public void setUp() {
        Genotype.setStaticConfiguration(null);
        System.setProperty("JGAPFACTORYCLASS", "");
        Configuration.resetProperty("JGAPFITEVALINST");
        Configuration.resetProperty("JGAPEVNTMGRINST");
        this.conf = new DefaultConfiguration();
    }

    public static boolean isChromosomesEqual(IChromosome[] a_list1, IChromosome[] a_list2) {
        if (a_list1 == null) {
            return a_list2 == null;
        }
        if (a_list2 == null) {
            return false;
        }
        if (a_list1.length != a_list2.length) {
            return false;
        }
        for (int i = 0; i < a_list1.length; ++i) {
            IChromosome c1 = a_list1[i];
            IChromosome c2 = a_list2[i];
            if (c1.equals(c2)) continue;
            return false;
        }
        return true;
    }

    public static void assertEqualsMap(Map a_map1, Map a_map2) {
    }

    public static void assertInList(Map a_list, Object a_object) {
        if (a_list.containsKey(a_object)) {
            a_list.remove(a_object);
        } else if (a_list.containsKey("java.lang." + a_object)) {
            a_list.remove("java.lang." + a_object);
        } else {
            JGAPTestCase.fail((String)("Object " + a_object + " not in list!"));
        }
    }

    public static void assertInList(List a_list, Object a_object) {
        if (a_list.contains(a_object)) {
            a_list.remove(a_object);
        } else if (a_list.contains("java.lang." + a_object)) {
            a_list.remove("java.lang." + a_object);
        } else {
            JGAPTestCase.fail((String)("Object " + a_object + " not in list!"));
        }
    }

    public boolean isSerializable(Object a_obj) {
        return Serializable.class.isInstance(a_obj);
    }

    public Object doSerialize(Object a_obj) throws Exception {
        File f = File.createTempFile("object", "ser");
        FileOutputStream os = new FileOutputStream(f);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(a_obj);
        oos.flush();
        oos.close();
        FileInputStream oi = new FileInputStream(f);
        ObjectInputStream ois = new ObjectInputStream(oi);
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public Object getNestedField(Object a_instance, String a_parentFieldName, String a_childFieldName) throws NoSuchFieldException {
        Object parentField = PrivateAccessor.getField((Object)a_instance, (String)a_parentFieldName);
        Object childField = PrivateAccessor.getField((Object)parentField, (String)a_childFieldName);
        return childField;
    }

    public void setNestedField(Object a_instance, String a_parentFieldName, String a_childFieldName, Object a_value) throws NoSuchFieldException {
        Object parentField = PrivateAccessor.getField((Object)a_instance, (String)a_parentFieldName);
        PrivateAccessor.setField((Object)parentField, (String)a_childFieldName, (Object)a_value);
    }

    public boolean uniqueChromosomes(Population a_pop) {
        for (int i = 0; i < a_pop.size() - 1; ++i) {
            IChromosome c = a_pop.getChromosome(i);
            for (int j = i + 1; j < a_pop.size(); ++j) {
                IChromosome c2 = a_pop.getChromosome(j);
                if (c != c2) continue;
                return false;
            }
        }
        return true;
    }

    public void assertEquals(double a_one, double a_two) {
        JGAPTestCase.assertEquals((double)a_one, (double)a_two, (double)1.0E-7);
    }

    public class TestFitnessFunction
    extends FitnessFunction {
        protected double evaluate(IChromosome a_subject) {
            return 1.0;
        }
    }
}

