/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IChromosome;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.audit.IEvolutionMonitor;
import org.jgap.eval.PopulationContext;
import org.jgap.eval.PopulationHistoryIndexed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMonitor
implements IEvolutionMonitor {
    private static final String CVS_REVISION = "$Revision: 1.3 $";
    public static final int CONTEXT_UPDATE_CHROMOSOMES1 = 0;
    public static final int CONTEXT_OFFSET_NATURAL_SELECTOR1 = 1;
    public static final int CONTEXT_OFFSET_AFTER_OPERATE = 10;
    public static final int CONTEXT_AFTER_BULK_EVALUATION = 20;
    public static final int CONTEXT_UPDATE_CHROMOSOMES2 = 22;
    public static final int CONTEXT_NEW_CHROMOSOME = 22;
    public static final int CONTEXT_READD_FITTEST = 23;
    public static final int CONTEXT_OFFSET_NATURAL_SELECTOR2 = 30;
    public static final int CONTEXT_END_OF_CYCLE = 999;
    private int m_checks;
    private PopulationHistoryIndexed m_popHist;
    private int m_selectorIndex;
    private int m_operatorIndex;

    public EvolutionMonitor() {
        this.init();
    }

    protected void init() {
        this.m_popHist = new PopulationHistoryIndexed();
    }

    @Override
    public boolean nextCycle(Population a_pop, List<String> a_messages) {
        IChromosome best = a_pop.determineFittestChromosome();
        if (best != null) {
            // empty if block
        }
        Population popClone = (Population)a_pop.clone();
        PopulationContext context = new PopulationContext(popClone);
        context.setChromosome(best);
        this.m_popHist.addPopulation(this.m_checks, 999, context);
        ++this.m_checks;
        this.initCounters();
        return false;
    }

    @Override
    public void start(Configuration a_config) {
        this.initCounters();
    }

    private void initCounters() {
        this.m_selectorIndex = 0;
        this.m_operatorIndex = 0;
    }

    @Override
    public void event(String a_monitorEvent, int a_evolutionNo, Object[] a_information) {
        BulkFitnessFunction bulkFitnessFunction;
        List chromosomes;
        GeneticOperator operator;
        Population pop;
        NaturalSelector selector;
        PopulationContext context;
        Population pop2;
        if (a_monitorEvent == null) {
            return;
        }
        if (a_information == null) {
            return;
        }
        if (a_monitorEvent.equals("remove_chromosome")) {
            pop2 = (Population)a_information[0];
            Integer chromosomeIndex = (Integer)a_information[1];
            IChromosome chrom = pop2.getChromosome(chromosomeIndex);
        }
        if (a_monitorEvent.equals("before_update_chromosomes(1)")) {
            pop2 = (Population)a_information[0];
        }
        if (a_monitorEvent.equals("after_update_chromosomes(1)")) {
            pop2 = (Population)((Population)a_information[0]).clone();
            context = new PopulationContext(pop2);
            this.m_popHist.addPopulation(this.m_checks, 0, context);
        }
        if (a_monitorEvent.equals("before_select")) {
            selector = (NaturalSelector)a_information[0];
            pop = (Population)a_information[1];
            int selectionSize = (Integer)a_information[2];
            boolean a_processBeforeGeneticOperators = (Boolean)a_information[3];
        }
        if (a_monitorEvent.equals("after_select")) {
            selector = (NaturalSelector)a_information[0];
            pop = (Population)((Population)a_information[1]).clone();
            Population newPop = (Population)((Population)a_information[2]).clone();
            int selectionSize = (Integer)a_information[3];
            boolean a_processBeforeGeneticOperators = (Boolean)a_information[4];
            if (a_processBeforeGeneticOperators) {
                context = new PopulationContext(pop);
                context.setSelector(selector);
                this.m_popHist.addPopulation(this.m_checks, 1 + this.m_selectorIndex * 2 + 0, context);
                context = new PopulationContext(newPop);
                context.setSelector(selector);
                this.m_popHist.addPopulation(this.m_checks, 1 + this.m_selectorIndex * 2 + 1, context);
                ++this.m_selectorIndex;
            } else {
                context = new PopulationContext(pop);
                context.setSelector(selector);
                this.m_popHist.addPopulation(this.m_checks, 30 + this.m_selectorIndex * 2 + 0, context);
                context = new PopulationContext(newPop);
                context.setSelector(selector);
                this.m_popHist.addPopulation(this.m_checks, 30 + this.m_selectorIndex * 2 + 1, context);
            }
        }
        if (a_monitorEvent.equals("before_operate")) {
            operator = (GeneticOperator)a_information[0];
            pop = (Population)a_information[1];
            chromosomes = (List)a_information[2];
        }
        if (a_monitorEvent.equals("after_operate")) {
            operator = (GeneticOperator)a_information[0];
            pop = (Population)a_information[1];
            chromosomes = (List)a_information[2];
            context = new PopulationContext(pop);
            context.setOperator(operator);
            this.m_popHist.addPopulation(this.m_checks, 10 + this.m_operatorIndex, context);
            ++this.m_operatorIndex;
            this.m_selectorIndex = 0;
        }
        if (a_monitorEvent.equals("before_bulk_eval")) {
            bulkFitnessFunction = (BulkFitnessFunction)a_information[0];
            pop = (Population)a_information[1];
        }
        if (a_monitorEvent.equals("after_bulk_eval")) {
            bulkFitnessFunction = (BulkFitnessFunction)a_information[0];
            pop = (Population)((Population)a_information[1]).clone();
            context = new PopulationContext(pop);
            context.setBulkFitnessFunction(bulkFitnessFunction);
            this.m_popHist.addPopulation(this.m_checks, 20, context);
        }
        if (a_monitorEvent.equals("before_update_chromosomes(2)")) {
            pop2 = (Population)a_information[0];
        }
        if (a_monitorEvent.equals("after_update_chromosomes(2)")) {
            pop2 = (Population)a_information[0];
            context = new PopulationContext(pop2);
            this.m_popHist.addPopulation(this.m_checks, 22, context);
        }
        if (a_monitorEvent.equals("before_add_chromosome")) {
            pop2 = (Population)a_information[0];
            IChromosome newChromosome = (IChromosome)((IChromosome)a_information[1]).clone();
            context = new PopulationContext(pop2);
            context.setChromosome(newChromosome);
            this.m_popHist.addPopulation(this.m_checks, 22, context);
        }
        if (a_monitorEvent.equals("readd_fittest_chromosome")) {
            pop2 = (Population)a_information[0];
            IChromosome fittest = (IChromosome)((IChromosome)a_information[1]).clone();
            context = new PopulationContext(pop2);
            context.setChromosome(fittest);
            this.m_popHist.addPopulation(this.m_checks, 23, context);
        }
    }

    @Override
    public PopulationHistoryIndexed getPopulations() {
        return this.m_popHist;
    }
}

