/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IChromosome;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.audit.IEvolutionMonitor;
import org.jgap.eval.PopulationHistoryIndexed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnessImprovementMonitor
implements IEvolutionMonitor {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private int m_initialWaitSeconds;
    private int m_checkIntervalSeconds;
    private double m_improvedFitnessExpected;
    private long m_startMillis;
    private long m_lastCheckMillis;
    private double m_bestFitnessPreviously;
    private int m_checks;

    public FitnessImprovementMonitor(int a_initialWaitSeconds, int a_checkIntervalSeconds, double a_improvedFitnessExpected) {
        this.m_initialWaitSeconds = a_initialWaitSeconds;
        this.m_checkIntervalSeconds = a_checkIntervalSeconds;
        this.m_improvedFitnessExpected = a_improvedFitnessExpected;
        this.m_bestFitnessPreviously = -1.0;
    }

    @Override
    public boolean nextCycle(Population a_pop, List<String> a_messages) {
        long currentMillis = System.currentTimeMillis();
        boolean doCheck = false;
        if (this.m_checks == 0) {
            if (currentMillis - this.m_startMillis >= (long)(this.m_initialWaitSeconds * 1000)) {
                doCheck = true;
            }
        } else if (currentMillis - this.m_lastCheckMillis >= (long)(this.m_checkIntervalSeconds * 1000)) {
            doCheck = true;
        }
        if (doCheck) {
            IChromosome best = a_pop.determineFittestChromosome();
            if (best != null) {
                if (Math.abs(this.m_bestFitnessPreviously - -1.0) < 1.0E-7) {
                    this.m_bestFitnessPreviously = best.getFitnessValue();
                } else {
                    if (Math.abs(best.getFitnessValue() - this.m_bestFitnessPreviously) < this.m_improvedFitnessExpected) {
                        a_messages.add("Not enough progress was made after initial delay");
                        return false;
                    }
                    this.m_bestFitnessPreviously = best.getFitnessValue();
                }
            } else if (this.m_checks > 0) {
                a_messages.add("No solution at all was evolved during two check cycles.");
                return false;
            }
            this.m_lastCheckMillis = System.currentTimeMillis();
            ++this.m_checks;
        }
        return true;
    }

    @Override
    public void start(Configuration a_config) {
        this.m_startMillis = System.currentTimeMillis();
    }

    @Override
    public void event(String a_monitorEvent, int a_evolutionNo, Object[] a_information) {
        BulkFitnessFunction bulkFitnessFunction;
        GeneticOperator operator;
        Population pop;
        NaturalSelector selector;
        Population pop2;
        if (a_monitorEvent == null) {
            return;
        }
        if (a_information == null) {
            return;
        }
        if (a_monitorEvent.equals("remove_chromosome")) {
            pop2 = (Population)a_information[0];
            Integer chromosomeIndex = (Integer)a_information[1];
        }
        if (a_monitorEvent.equals("before_update_chromosomes(1)")) {
            pop2 = (Population)a_information[0];
        }
        if (a_monitorEvent.equals("after_update_chromosomes(1)")) {
            pop2 = (Population)a_information[0];
        }
        if (a_monitorEvent.equals("before_select")) {
            selector = (NaturalSelector)a_information[0];
            pop = (Population)a_information[1];
            int selectionSize = (Integer)a_information[2];
            boolean a_processBeforeGeneticOperators = (Boolean)a_information[3];
        }
        if (a_monitorEvent.equals("after_select")) {
            selector = (NaturalSelector)a_information[0];
            pop = (Population)a_information[1];
            Population newPop = (Population)a_information[2];
            int selectionSize = (Integer)a_information[3];
            boolean a_processBeforeGeneticOperators = (Boolean)a_information[4];
        }
        if (a_monitorEvent.equals("before_operate")) {
            operator = (GeneticOperator)a_information[0];
            pop = (Population)a_information[1];
            List chromosomes = (List)a_information[2];
        }
        if (a_monitorEvent.equals("after_operate")) {
            operator = (GeneticOperator)a_information[0];
            pop = (Population)a_information[1];
            List chromosomes = (List)a_information[2];
        }
        if (a_monitorEvent.equals("before_bulk_eval")) {
            bulkFitnessFunction = (BulkFitnessFunction)a_information[0];
            pop = (Population)a_information[1];
        }
        if (a_monitorEvent.equals("after_bulk_eval")) {
            bulkFitnessFunction = (BulkFitnessFunction)a_information[0];
            pop = (Population)a_information[1];
        }
        if (a_monitorEvent.equals("before_update_chromosomes(2)")) {
            pop2 = (Population)a_information[0];
        }
        if (a_monitorEvent.equals("after_update_chromosomes(2)")) {
            pop2 = (Population)a_information[0];
        }
        if (a_monitorEvent.equals("before_add_chromosome")) {
            pop2 = (Population)a_information[0];
            IChromosome newChromosome = (IChromosome)a_information[1];
        }
        if (a_monitorEvent.equals("readd_fittest_chromosome")) {
            pop2 = (Population)a_information[0];
            IChromosome fittest = (IChromosome)a_information[1];
        }
    }

    @Override
    public PopulationHistoryIndexed getPopulations() {
        return null;
    }
}

