/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.data;

import java.util.Map;
import java.util.Set;
import org.jgap.data.IDataCreators;
import org.jgap.data.IDataElement;
import org.jgap.data.IDataElementList;

public abstract class DocumentBuilderBase {
    private static final String CVS_REVISION = "$Revision: 1.8 $";

    public Object buildDocument(IDataCreators a_dataholder, Object a_document) throws Exception {
        IDataElementList tree = a_dataholder.getTree();
        int len = tree.getLength();
        for (int i = 0; i < len; ++i) {
            IDataElement elem = tree.item(i);
            this.doTraverse(elem, a_document, null);
        }
        return a_document;
    }

    private void doTraverse(IDataElement a_elem, Object a_document, Object a_Element) throws Exception {
        String tagName = a_elem.getTagName();
        Object element = this.createElementGeneric(a_document, a_Element, tagName);
        Map attributes = a_elem.getAttributes();
        Set keys = attributes.keySet();
        for (String key : keys) {
            String value = (String)attributes.get(key);
            this.setAttribute(element, key, value);
        }
        IDataElementList list = a_elem.getChildNodes();
        if (list != null) {
            for (int j = 0; j < list.getLength(); ++j) {
                IDataElement elem2 = list.item(j);
                this.doTraverse(elem2, a_document, element);
            }
        }
    }

    private Object createElementGeneric(Object a_document, Object a_element, String a_tagName) {
        Object element;
        if (a_element == null) {
            element = this.createElement(a_document, null, a_tagName);
            this.documentAppendChild(a_document, element);
        } else {
            Object xmlElement2 = this.createElement(a_document, a_element, a_tagName);
            this.elementAppendChild(a_element, xmlElement2);
            element = xmlElement2;
        }
        return element;
    }

    protected abstract Object documentAppendChild(Object var1, Object var2);

    protected abstract Object elementAppendChild(Object var1, Object var2);

    protected abstract Object createElement(Object var1, Object var2, String var3);

    protected abstract void setAttribute(Object var1, String var2, String var3);
}

