/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp;

import java.awt.Color;
import java.io.File;
import javax.swing.tree.TreeNode;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.SubProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.JGAPTreeBranchRenderer;
import org.jgap.gp.impl.JGAPTreeNode;
import org.jgap.gp.impl.JGAPTreeNodeRenderer;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.tree.TreeBranchRenderer;
import org.jgap.util.tree.TreeNodeRenderer;
import org.jgap.util.tree.TreeVisualizer;

public abstract class GPProblem {
    private static final String CVS_REVISION = "$Revision: 1.8 $";
    private GPConfiguration m_conf;

    public GPProblem(GPConfiguration a_conf) throws InvalidConfigurationException {
        if (a_conf == null) {
            throw new InvalidConfigurationException("Configuration must not be null!");
        }
        this.m_conf = a_conf;
    }

    public GPProblem() {
    }

    public abstract GPGenotype create() throws InvalidConfigurationException;

    public void showTree(IGPProgram a_prog, String a_filename) throws InvalidConfigurationException {
        if (a_prog == null) {
            return;
        }
        TreeNode myTree = this.createTree(a_prog);
        if (myTree == null) {
            return;
        }
        TreeVisualizer tv = new TreeVisualizer();
        tv.setTreeBranchRenderer(new JGAPTreeBranchRenderer());
        tv.setTreeNodeRenderer(new JGAPTreeNodeRenderer());
        tv.setBranchStartWidth(18.0);
        tv.setArenaColor(Color.black);
        tv.setBkgndColor(Color.black);
        tv.setRenderNodes(true);
        tv.setSide(1024);
        tv.setCircleDiminishFactor(0.5);
        tv.writeImageFile(tv.renderTree(myTree), new File(a_filename));
    }

    public void showTree(IGPProgram a_prog, String a_filename, TreeBranchRenderer a_treeBranchRenderer, TreeNodeRenderer a_treeNodeRenderer) throws InvalidConfigurationException {
        TreeNode myTree = this.createTree(a_prog);
        if (myTree == null) {
            return;
        }
        TreeVisualizer tv = new TreeVisualizer();
        tv.setTreeBranchRenderer(a_treeBranchRenderer);
        tv.setTreeNodeRenderer(a_treeNodeRenderer);
        tv.setBranchStartWidth(18.0);
        tv.setArenaColor(Color.black);
        tv.setBkgndColor(Color.black);
        tv.setRenderNodes(true);
        tv.setSide(1024);
        tv.setCircleDiminishFactor(0.5);
        tv.writeImageFile(tv.renderTree(myTree), new File(a_filename));
    }

    public TreeNode createTree(IGPProgram a_prog) throws InvalidConfigurationException {
        JGAPTreeNode tree;
        if (a_prog == null) {
            return null;
        }
        ProgramChromosome master = new ProgramChromosome(this.m_conf);
        master.setIndividual(a_prog);
        if (a_prog.size() > 1) {
            Class[] types = new Class[a_prog.size()];
            for (int i = 0; i < a_prog.size(); ++i) {
                types[i] = CommandGene.VoidClass;
            }
            master.setGene(0, new SubProgram(this.m_conf, types));
            int index = 1;
            for (int i = 0; i < a_prog.size(); ++i) {
                ProgramChromosome child = a_prog.getChromosome(i);
                for (int j = 0; j < child.size(); ++j) {
                    master.setGene(index++, child.getGene(j));
                }
            }
            master.redepth();
            tree = new JGAPTreeNode(master, 0);
        } else {
            tree = new JGAPTreeNode(a_prog.getChromosome(0), 0);
        }
        return tree;
    }

    public GPConfiguration getGPConfiguration() {
        return this.m_conf;
    }

    protected void setGPConfiguration(GPConfiguration a_conf) {
        this.m_conf = a_conf;
    }
}

