/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.io.Serializable;
import java.util.Vector;
import org.jgap.RandomGenerator;
import org.jgap.gp.IGPFitnessEvaluator;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.INaturalGPSelector;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;

public class TournamentSelector
implements INaturalGPSelector,
Serializable,
Cloneable {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private int m_tournament_size;

    public TournamentSelector() {
        this(5);
    }

    public TournamentSelector(int a_tournament_size) {
        this.setTournamentSize(a_tournament_size);
    }

    public void setTournamentSize(int a_tournament_size) {
        this.m_tournament_size = a_tournament_size;
    }

    public IGPProgram select(GPGenotype a_genotype) {
        int i;
        GPPopulation pop = a_genotype.getGPPopulation();
        IGPProgram bestProgram = null;
        int index = 0;
        RandomGenerator random = a_genotype.getGPConfiguration().getRandomGenerator();
        IGPFitnessEvaluator evaluator = a_genotype.getGPConfiguration().getGPFitnessEvaluator();
        int popSize = pop.getPopSize();
        Vector<Integer> indexes = new Vector<Integer>(popSize);
        for (i = 0; i < popSize; ++i) {
            indexes.add(i);
        }
        for (i = 0; i < this.m_tournament_size; ++i) {
            index = (int)(random.nextDouble() * (double)indexes.size());
            int realIndex = (Integer)indexes.get(index);
            if (bestProgram == null) {
                bestProgram = pop.getGPProgram(realIndex);
            } else {
                IGPProgram prog = pop.getGPProgram(realIndex);
                if (evaluator.isFitter(prog, bestProgram)) {
                    bestProgram = prog;
                }
            }
            if (i >= this.m_tournament_size - 1) continue;
            indexes.remove(index);
        }
        return bestProgram;
    }

    public Object clone() {
        TournamentSelector sel = new TournamentSelector(this.m_tournament_size);
        return sel;
    }
}

