/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jgap.BaseGeneticOperator;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICompositeGene;
import org.jgap.IUniversalRateCalculator;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.impl.CompositeGene;

public class AveragingCrossoverOperator
extends BaseGeneticOperator {
    private static final String CVS_REVISION = "$Revision: 1.29 $";
    private RandomGenerator m_crossoverGenerator;
    private int m_crossoverRate;
    private Map m_loci;
    private IUniversalRateCalculator m_crossoverRateCalc;

    private void init() {
        this.m_loci = new Hashtable();
        this.m_crossoverRate = 2;
    }

    public AveragingCrossoverOperator() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration(), (RandomGenerator)null);
    }

    public AveragingCrossoverOperator(Configuration a_configuration) throws InvalidConfigurationException {
        this(a_configuration, (RandomGenerator)null);
    }

    public AveragingCrossoverOperator(Configuration a_configuration, RandomGenerator a_generatorForAveraging) throws InvalidConfigurationException {
        super(a_configuration);
        this.init();
        this.m_crossoverGenerator = a_generatorForAveraging;
    }

    public AveragingCrossoverOperator(Configuration a_configuration, IUniversalRateCalculator a_crossoverRateCalculator) throws InvalidConfigurationException {
        super(a_configuration);
        this.init();
        this.setCrossoverRateCalc(a_crossoverRateCalculator);
    }

    private void setCrossoverRateCalc(IUniversalRateCalculator a_crossoverRateCalculator) {
        this.m_crossoverRateCalc = a_crossoverRateCalculator;
    }

    public void operate(Population a_population, List a_candidateChromosomes) {
        int size = Math.min(this.getConfiguration().getPopulationSize(), a_population.size());
        int numCrossovers = 0;
        numCrossovers = this.m_crossoverRateCalc == null ? size / this.m_crossoverRate : size / this.m_crossoverRateCalc.calculateCurrentRate();
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        if (this.m_crossoverGenerator == null) {
            this.m_crossoverGenerator = generator;
        }
        for (int i = 0; i < numCrossovers; ++i) {
            int locus;
            int index1 = generator.nextInt(size);
            int index2 = generator.nextInt(size);
            IChromosome origChrom1 = a_population.getChromosome(index1);
            IChromosome origChrom2 = a_population.getChromosome(index2);
            IChromosome firstMate = (IChromosome)origChrom1.clone();
            IChromosome secondMate = (IChromosome)origChrom2.clone();
            if (this.m_monitorActive) {
                firstMate.setUniqueIDTemplate(origChrom1.getUniqueID(), 1);
                firstMate.setUniqueIDTemplate(origChrom2.getUniqueID(), 2);
                secondMate.setUniqueIDTemplate(origChrom1.getUniqueID(), 1);
                secondMate.setUniqueIDTemplate(origChrom2.getUniqueID(), 2);
            }
            Gene[] firstGenes = firstMate.getGenes();
            Gene[] secondGenes = secondMate.getGenes();
            for (int j = locus = this.getLocus(this.m_crossoverGenerator, i, firstGenes.length); j < firstGenes.length; ++j) {
                Gene gene2;
                Gene gene1;
                if (firstGenes[j] instanceof ICompositeGene) {
                    index1 = generator.nextInt(firstGenes[j].size());
                    gene1 = ((ICompositeGene)firstGenes[j]).geneAt(index1);
                } else {
                    gene1 = firstGenes[j];
                }
                if (secondGenes[j] instanceof CompositeGene) {
                    index2 = generator.nextInt(secondGenes[j].size());
                    gene2 = ((ICompositeGene)secondGenes[j]).geneAt(index2);
                } else {
                    gene2 = secondGenes[j];
                }
                Object firstAllele = gene1.getAllele();
                gene1.setAllele(gene2.getAllele());
                gene2.setAllele(firstAllele);
            }
            a_candidateChromosomes.add(firstMate);
            a_candidateChromosomes.add(secondMate);
        }
    }

    protected int getLocus(RandomGenerator a_generator, int a_index, int a_max) {
        Integer locus = (Integer)this.m_loci.get(new Integer(a_index));
        if (locus == null) {
            locus = new Integer(a_generator.nextInt(a_max));
            this.m_loci.put(new Integer(a_index), locus);
        }
        return locus;
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        AveragingCrossoverOperator op = (AveragingCrossoverOperator)a_other;
        if (this.m_crossoverRateCalc == null) {
            if (op.m_crossoverRateCalc != null) {
                return -1;
            }
        } else if (op.m_crossoverRateCalc == null) {
            return 1;
        }
        if (this.m_crossoverRate != op.m_crossoverRate) {
            if (this.m_crossoverRate > op.m_crossoverRate) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public void setCrossoverRate(int a_rate) {
        this.m_crossoverRate = a_rate;
    }
}

