/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import gnu.trove.THashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgap.Configuration;
import org.jgap.FitnessEvaluator;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICloneHandler;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelectorExt;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.impl.Pool;
import org.jgap.impl.SlotCounter;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class WeightedRouletteSelector
extends NaturalSelectorExt
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.44 $";
    private static final double DELTA = 1.0E-6;
    private static final BigDecimal ZERO_BIG_DECIMAL = new BigDecimal(0.0);
    private THashMap m_wheel = new THashMap();
    private double m_totalNumberOfUsedSlots;
    private transient Pool m_counterPool;
    private WeightedRouletteSelConfig m_config = new WeightedRouletteSelConfig();

    public WeightedRouletteSelector() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public WeightedRouletteSelector(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
        this.m_counterPool = new Pool();
        this.m_config.m_doublettesAllowed = false;
    }

    protected synchronized void add(IChromosome a_chromosomeToAdd) {
        SlotCounter counter = (SlotCounter)this.m_wheel.get((Object)a_chromosomeToAdd);
        if (counter != null) {
            counter.increment();
        } else {
            a_chromosomeToAdd.setIsSelectedForNextGeneration(false);
            counter = (SlotCounter)this.m_counterPool.acquirePooledObject();
            if (counter == null) {
                counter = new SlotCounter();
            }
            counter.reset(a_chromosomeToAdd.getFitnessValue());
            this.m_wheel.put((Object)a_chromosomeToAdd, (Object)counter);
        }
    }

    public synchronized void selectChromosomes(int a_howManyToSelect, Population a_to_pop) {
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        this.scaleFitnessValues();
        Set entries = this.m_wheel.entrySet();
        int numberOfEntries = entries.size();
        double[] fitnessValues = new double[numberOfEntries];
        double[] counterValues = new double[numberOfEntries];
        IChromosome[] chromosomes = new IChromosome[numberOfEntries];
        this.m_totalNumberOfUsedSlots = 0.0;
        Iterator entryIterator = entries.iterator();
        for (int i = 0; i < numberOfEntries; ++i) {
            Map.Entry chromosomeEntry = (Map.Entry)entryIterator.next();
            IChromosome currentChromosome = (IChromosome)chromosomeEntry.getKey();
            SlotCounter currentCounter = (SlotCounter)chromosomeEntry.getValue();
            fitnessValues[i] = currentCounter.getFitnessValue();
            counterValues[i] = fitnessValues[i] * (double)currentCounter.getCounterValue();
            chromosomes[i] = currentChromosome;
            this.m_totalNumberOfUsedSlots += counterValues[i];
        }
        for (int i = 0; i < a_howManyToSelect; ++i) {
            IChromosome selectedChromosome = this.spinWheel(generator, fitnessValues, counterValues, chromosomes);
            selectedChromosome.setIsSelectedForNextGeneration(true);
            if (a_to_pop.contains(selectedChromosome)) {
                ICloneHandler cloner = this.getConfiguration().getJGAPFactory().getCloneHandlerFor(selectedChromosome, null);
                if (cloner != null) {
                    try {
                        IChromosome cloned = (IChromosome)cloner.perform(selectedChromosome, null, null);
                        a_to_pop.addChromosome(cloned);
                        if (!this.m_monitorActive) continue;
                        cloned.setUniqueIDTemplate(selectedChromosome.getUniqueID(), 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        a_to_pop.addChromosome(selectedChromosome);
                    }
                    continue;
                }
                a_to_pop.addChromosome(selectedChromosome);
                if (!this.m_monitorActive) continue;
                selectedChromosome.setUniqueIDTemplate(selectedChromosome.getUniqueID(), 1);
                continue;
            }
            a_to_pop.addChromosome(selectedChromosome);
            if (!this.m_monitorActive) continue;
            selectedChromosome.setUniqueIDTemplate("new", 1);
        }
    }

    private IChromosome spinWheel(RandomGenerator a_generator, double[] a_fitnessValues, double[] a_counterValues, IChromosome[] a_chromosomes) {
        double selectedSlot = a_generator.nextDouble() * this.m_totalNumberOfUsedSlots;
        if (selectedSlot > this.m_totalNumberOfUsedSlots) {
            selectedSlot = this.m_totalNumberOfUsedSlots;
        }
        double currentSlot = 0.0;
        FitnessEvaluator evaluator = this.getConfiguration().getFitnessEvaluator();
        boolean isFitter2_1 = evaluator.isFitter(2.0, 1.0);
        for (int i = 0; i < a_counterValues.length; ++i) {
            boolean found;
            if (isFitter2_1) {
                found = selectedSlot - currentSlot <= 1.0E-6;
            } else {
                boolean bl = found = Math.abs(currentSlot - selectedSlot) <= 1.0E-6;
            }
            if (found) {
                if (!this.getDoubletteChromosomesAllowed()) {
                    this.m_totalNumberOfUsedSlots -= a_counterValues[i];
                    a_counterValues[i] = 0.0;
                } else {
                    int n = i;
                    a_counterValues[n] = a_counterValues[n] - a_fitnessValues[i];
                    this.m_totalNumberOfUsedSlots -= a_fitnessValues[i];
                }
                if (Math.abs(this.m_totalNumberOfUsedSlots) < 1.0E-6) {
                    this.m_totalNumberOfUsedSlots = 0.0;
                }
                return a_chromosomes[i];
            }
            currentSlot += a_counterValues[i];
        }
        return a_chromosomes[a_counterValues.length - 1];
    }

    public synchronized void empty() {
        this.m_counterPool.releaseAllObjects(this.m_wheel.values());
        this.m_wheel.clear();
        this.m_totalNumberOfUsedSlots = 0.0;
    }

    private void scaleFitnessValues() {
        double largestFitnessValue = 0.0;
        BigDecimal totalFitness = ZERO_BIG_DECIMAL;
        for (SlotCounter counter : this.m_wheel.values()) {
            if (counter.getFitnessValue() > largestFitnessValue) {
                largestFitnessValue = counter.getFitnessValue();
            }
            BigDecimal counterFitness = new BigDecimal(counter.getFitnessValue());
            totalFitness = totalFitness.add(counterFitness.multiply(new BigDecimal(counter.getCounterValue())));
        }
        if (largestFitnessValue > 0.0 && (double)totalFitness.floatValue() > 1.0E-7) {
            double scalingFactor = totalFitness.divide(new BigDecimal(largestFitnessValue), 4).doubleValue();
            for (SlotCounter counter : this.m_wheel.values()) {
                counter.scaleFitnessValue(scalingFactor);
            }
        }
    }

    public boolean returnsUniqueChromosomes() {
        return false;
    }

    public void setDoubletteChromosomesAllowed(boolean a_doublettesAllowed) {
        throw new IllegalStateException("Weighted roulette selector does not support this parameter, please do not use it!");
    }

    public boolean getDoubletteChromosomesAllowed() {
        return true;
    }

    public Object clone() {
        try {
            WeightedRouletteSelector result = new WeightedRouletteSelector(this.getConfiguration());
            result.m_wheel = this.m_wheel.clone();
            result.m_config = new WeightedRouletteSelConfig();
            result.m_config.m_doublettesAllowed = this.m_config.m_doublettesAllowed;
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new CloneException(iex);
        }
    }

    public boolean equals(Object o) {
        WeightedRouletteSelector other = (WeightedRouletteSelector)o;
        if (other == null) {
            return false;
        }
        if (this.m_totalNumberOfUsedSlots != other.m_totalNumberOfUsedSlots) {
            return false;
        }
        if (other.m_config == null) {
            return false;
        }
        if (this.m_config.m_doublettesAllowed != other.m_config.m_doublettesAllowed) {
            return false;
        }
        if (other.m_counterPool == null) {
            return false;
        }
        return this.m_wheel.equals((Object)other.m_wheel);
    }

    class WeightedRouletteSelConfig
    implements Serializable {
        public boolean m_doublettesAllowed;

        WeightedRouletteSelConfig() {
        }
    }
}

