/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.perf;

import java.util.Calendar;
import java.util.TimeZone;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.IntegerGene;
import org.jgap.impl.RandomGeneratorForTesting;
import org.jgap.perf.TestOverallPerformanceFitnessFunc;

public class TestOverallPerformance {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private static final int MAX_ALLOWED_EVOLUTIONS = 1000;

    public void makeChangeForAmount(int a_targetChangeAmount) throws Exception {
        Configuration.reset();
        DefaultConfiguration conf = new DefaultConfiguration();
        RandomGeneratorForTesting gen = new RandomGeneratorForTesting();
        gen.setNextDouble(0.5);
        gen.setNextBoolean(true);
        gen.setNextInt(3);
        gen.setNextFloat(0.7f);
        gen.setNextLong(6L);
        conf.setRandomGenerator(gen);
        TestOverallPerformanceFitnessFunc myFunc = new TestOverallPerformanceFitnessFunc(a_targetChangeAmount);
        conf.setFitnessFunction(myFunc);
        Gene[] sampleGenes = new Gene[]{new IntegerGene(conf, 0, 3), new IntegerGene(conf, 0, 2), new IntegerGene(conf, 0, 1), new IntegerGene(conf, 0, 4), new IntegerGene(conf, 0, 3), new IntegerGene(conf, 0, 1), new IntegerGene(conf, 0, 1), new IntegerGene(conf, 0, 2), new IntegerGene(conf, 0, 3), new IntegerGene(conf, 0, 1)};
        Chromosome sampleChromosome = new Chromosome((Configuration)conf, sampleGenes);
        conf.setSampleChromosome(sampleChromosome);
        conf.setPopulationSize(10000);
        Genotype population = Genotype.randomInitialGenotype(conf);
        for (int i = 0; i < 1000; ++i) {
            population.evolve();
        }
        population.getFittestChromosome();
    }

    public static void main(String[] args) throws Exception {
        int amount = 287;
        int numRuns = 20;
        System.out.println("Test started.");
        long starttime = TestOverallPerformance.getCurrentMilliseconds();
        for (int i = 0; i < 20; ++i) {
            TestOverallPerformance runner = new TestOverallPerformance();
            runner.makeChangeForAmount(287);
        }
        long timeMillis = TestOverallPerformance.getCurrentMilliseconds() - starttime;
        System.out.println("Overall time needed for executing performance test: " + timeMillis + " [millisecs]");
    }

    private static long getCurrentMilliseconds() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        return cal.getTimeInMillis();
    }
}

