/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.PaletteView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultPaletteView
extends JDialog
implements PaletteView,
MouseListener,
MouseMotionListener,
ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private final Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue};
    private final String[] lineLabels = new String[]{"Red", "Green", "Blue"};
    private static String PALETTE_GRAY = "Gray";
    private static String PALETTE_REVERSE_GRAY = "Reverse Gray";
    private static String PALETTE_GRAY_WAVE = "GrayWave";
    private static String PALETTE_RAINBOW = "Rainbow";
    private static String PALETTE_NATURE = "Nature";
    private static String PALETTE_WAVE = "Wave";
    private JRadioButton checkRed;
    private JRadioButton checkGreen;
    private JRadioButton checkBlue;
    private ChartPanel chartP;
    private int x0;
    private int y0;
    private Image originalImage;
    private Image currentImage;
    boolean isPaletteChanged = false;
    byte[][] palette;
    private ScalarDS dataset;
    private ImageView imageView;
    private int[][] paletteData;
    private JComboBox choicePalette;
    private PaletteValueTable paletteValueTable;

    public DefaultPaletteView(ImageView imageView) {
        this(null, imageView);
    }

    public DefaultPaletteView(ViewManager viewManager, ImageView imageView) {
        super((Frame)((JFrame)((Object)viewManager)), true);
        this.setDefaultCloseOperation(2);
        this.imageView = imageView;
        this.dataset = (ScalarDS)this.imageView.getDataObject();
        this.choicePalette = new JComboBox();
        this.choicePalette.addItemListener(this);
        this.choicePalette.addItem("Select palette");
        this.choicePalette.addItem(PALETTE_GRAY);
        this.choicePalette.addItem(PALETTE_GRAY_WAVE);
        this.choicePalette.addItem(PALETTE_RAINBOW);
        this.choicePalette.addItem(PALETTE_NATURE);
        this.choicePalette.addItem(PALETTE_WAVE);
        this.chartP = new ChartPanel();
        this.chartP.setBackground(Color.white);
        this.paletteData = new int[3][256];
        byte[][] byArray = this.imageView.getPalette();
        this.setTitle("Image Palette for - " + this.dataset.getPath() + this.dataset.getName());
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 256; ++j) {
                n = byArray[i][j];
                if (n < 0) {
                    n += 256;
                }
                this.paletteData[i][j] = n;
            }
        }
        this.imageView = imageView;
        this.chartP.addMouseListener(this);
        this.chartP.addMouseMotionListener(this);
        this.y0 = 0;
        this.x0 = 0;
        this.originalImage = this.currentImage = this.imageView.getImage();
        this.palette = new byte[3][256];
        this.createUI();
        this.setVisible(true);
    }

    public HObject getDataObject() {
        return this.dataset;
    }

    private void createUI() {
        Window window = this.getOwner();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int n = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 500 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.add((Component)this.chartP, "Center");
        JButton jButton = new JButton("  Ok  ");
        jButton.addActionListener(this);
        jButton.setActionCommand("Ok");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new LineBorder(Color.GRAY));
        jPanel2.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jButton.setActionCommand("Cancel");
        jPanel2.add(jButton);
        jButton = new JButton("Preview");
        jButton.addActionListener(this);
        jButton.setActionCommand("Preview");
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(20, 2));
        jPanel3.add((Component)jPanel2, "East");
        this.checkRed = new JRadioButton("Red");
        this.checkRed.setForeground(Color.red);
        this.checkGreen = new JRadioButton("Green");
        this.checkGreen.setForeground(Color.green);
        this.checkBlue = new JRadioButton("Blue");
        this.checkBlue.setForeground(Color.blue);
        this.checkRed.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkRed);
        buttonGroup.add(this.checkGreen);
        buttonGroup.add(this.checkBlue);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new LineBorder(Color.GRAY));
        jPanel4.add(this.checkRed);
        jPanel4.add(this.checkGreen);
        jPanel4.add(this.checkBlue);
        jPanel3.add((Component)jPanel4, "West");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.setBorder(new LineBorder(Color.GRAY));
        JButton jButton2 = new JButton("Show Value");
        jButton2.setActionCommand("Show palette values");
        jButton2.addActionListener(this);
        jPanel5.add(this.choicePalette);
        jPanel5.add(jButton2);
        jPanel3.add((Component)jPanel5, "Center");
        jPanel.add((Component)jPanel3, "South");
        Point point = window.getLocation();
        point.x += 350;
        point.y += 200;
        this.setLocation(point);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            if (this.isPaletteChanged) {
                this.updatePalette();
                this.isPaletteChanged = false;
                this.imageView.setImage(this.currentImage);
                this.imageView.setPalette(this.palette);
            }
            super.dispose();
        } else if (string.equals("Cancel")) {
            this.imageView.setImage(this.originalImage);
            super.dispose();
        } else if (string.equals("Preview")) {
            this.updatePalette();
            this.imageView.setImage(this.currentImage);
        } else if (string.equals("Show palette values")) {
            if (this.paletteValueTable == null) {
                this.paletteValueTable = new PaletteValueTable(this);
            }
            this.paletteValueTable.setVisible(true);
        } else if (string.equals("Hide palette values") && this.paletteValueTable != null) {
            this.paletteValueTable.setVisible(false);
        }
    }

    public void dispose() {
        this.imageView.setImage(this.originalImage);
        super.dispose();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!object.equals(this.choicePalette)) {
            return;
        }
        int n = this.choicePalette.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        byte[][] byArray = null;
        Object object2 = this.choicePalette.getSelectedItem();
        if (object2.equals(PALETTE_GRAY)) {
            byArray = Tools.createGrayPalette();
        }
        if (object2.equals(PALETTE_REVERSE_GRAY)) {
            byArray = Tools.createReverseGrayPalette();
        } else if (object2.equals(PALETTE_GRAY_WAVE)) {
            byArray = Tools.createGrayWavePalette();
        } else if (object2.equals(PALETTE_RAINBOW)) {
            byArray = Tools.createRainbowPalette();
        } else if (object2.equals(PALETTE_NATURE)) {
            byArray = Tools.createNaturePalette();
        } else if (object2.equals(PALETTE_WAVE)) {
            byArray = Tools.createWavePalette();
        }
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 256; ++j) {
                n2 = byArray[i][j];
                if (n2 < 0) {
                    n2 += 256;
                }
                this.paletteData[i][j] = n2;
            }
        }
        this.chartP.repaint();
        this.isPaletteChanged = true;
    }

    private void updatePalette() {
        for (int i = 0; i < 256; ++i) {
            this.palette[0][i] = (byte)this.paletteData[0][i];
            this.palette[1][i] = (byte)this.paletteData[1][i];
            this.palette[2][i] = (byte)this.paletteData[2][i];
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, this.palette[0], this.palette[1], this.palette[2]);
        int n = this.dataset.getWidth();
        int n2 = this.dataset.getHeight();
        this.currentImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, (ColorModel)indexColorModel, this.imageView.getImageByteData(), 0, n));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.paletteValueTable != null && this.paletteValueTable.isVisible()) {
            this.paletteValueTable.paletteUpdated();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - 40;
        if (n < 0) {
            n = 0;
        }
        int n2 = mouseEvent.getY() + 20;
        Dimension dimension = this.chartP.getSize();
        double d = 255.0 / (double)dimension.height;
        double d2 = 255.0 / (double)dimension.width;
        int n3 = 0;
        if (this.checkGreen.isSelected()) {
            n3 = 1;
        } else if (this.checkBlue.isSelected()) {
            n3 = 2;
        }
        int n4 = 0;
        double d3 = (double)(n2 - this.y0) / (double)(n - this.x0);
        double d4 = (double)this.y0 - d3 * (double)this.x0;
        double d5 = (double)this.y0 * d;
        int n5 = Math.min(this.x0, n);
        int n6 = Math.max(this.x0, n);
        for (int i = n5; i < n6; ++i) {
            n4 = (int)(d2 * (double)i);
            if (n4 > 255) continue;
            d5 = 255.0 - (d4 + d3 * (double)i) * d;
            if (d5 < 0.0) {
                d5 = 0.0;
            } else if (d5 > 255.0) {
                d5 = 255.0;
            }
            this.paletteData[n3][n4] = (int)d5;
        }
        this.chartP.repaint();
        this.isPaletteChanged = true;
    }

    private final class ChartPanel
    extends JComponent {
        public static final long serialVersionUID = 240L;

        private ChartPanel() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = 20;
            int n2 = 60;
            int n3 = dimension.height - n;
            int n4 = dimension.width - 3 * n - n2;
            graphics.drawLine(2 * n, n3, n4 + 2 * n, n3);
            graphics.drawLine(2 * n, n3, 2 * n, 0);
            int n5 = n3 / 10;
            int n6 = n4 / 10;
            int n7 = 25;
            double d = 25.0;
            int n8 = 2 * n;
            int n9 = 0;
            int n10 = 0;
            double d2 = 0.0;
            graphics.drawString(String.valueOf((int)d2), 0, n3 + 8);
            graphics.drawString(String.valueOf(n10), n8 - 5, n3 + n);
            for (int i = 0; i < 10; ++i) {
                graphics.drawLine(n8 += n6, n3, n8, n3 - 5);
                graphics.drawLine(2 * n, n3 - (n9 += n5), 2 * n + 5, n3 - n9);
                graphics.drawString(String.valueOf((int)(d2 += d)), 0, n3 - n9 + 8);
                graphics.drawString(String.valueOf(n10 += n7), n8 - 5, n3 + n);
            }
            Color color = graphics.getColor();
            for (int i = 0; i < 3; ++i) {
                int n11;
                int n12;
                graphics.setColor(DefaultPaletteView.this.lineColors[i]);
                for (int j = 0; j < 255; ++j) {
                    n12 = n4 * j / 255 + 2 * n;
                    n11 = n3 - n3 * DefaultPaletteView.this.paletteData[i][j] / 255;
                    int n13 = n4 * (j + 1) / 255 + 2 * n;
                    int n14 = n3 - n3 * DefaultPaletteView.this.paletteData[i][j + 1] / 255;
                    graphics.drawLine(n12, n11, n13, n14);
                }
                n12 = n4 + n2;
                n11 = n + n * i;
                graphics.drawLine(n12, n11, n12 + 7, n11);
                graphics.drawString(DefaultPaletteView.this.lineLabels[i], n12 + 10, n11 + 3);
            }
            graphics.setColor(color);
            graphics.drawRect(n4 + n2 - 10, 10, n2, 10 * n);
        }
    }

    private final class PaletteValueTable
    extends JDialog {
        public static final long serialVersionUID = 240L;
        private JTable valueTable;
        private DefaultTableModel valueTableModel;
        String rgbName;

        public PaletteValueTable(DefaultPaletteView defaultPaletteView2) {
            super(defaultPaletteView2);
            this.rgbName = "Color";
            Object[] objectArray = new String[]{"Red", "Green", "Blue", this.rgbName};
            this.valueTableModel = new DefaultTableModel(objectArray, 256);
            this.valueTable = new JTable(this.valueTableModel){
                public static final long serialVersionUID = 240L;
                int lastSelectedRow;
                int lastSelectedCol;
                {
                    super(tableModel);
                    this.lastSelectedRow = -1;
                    this.lastSelectedCol = -1;
                }

                public boolean isCellEditable(int n, int n2) {
                    return n2 < 3;
                }

                public Object getValueAt(int n, int n2) {
                    if (n2 < 3) {
                        return String.valueOf(DefaultPaletteView.this.paletteData[n2][n]);
                    }
                    return "";
                }

                public void editingStopped(ChangeEvent changeEvent) {
                    int n = this.getEditingRow();
                    int n2 = this.getEditingColumn();
                    if (n2 > 2) {
                        return;
                    }
                    String string = (String)this.getValueAt(n, n2);
                    super.editingStopped(changeEvent);
                    Object object = changeEvent.getSource();
                    if (object instanceof CellEditor) {
                        CellEditor cellEditor = (CellEditor)object;
                        String string2 = (String)cellEditor.getCellEditorValue();
                        this.setValueAt(string, n, n2);
                        PaletteValueTable.this.updatePaletteValue(string2, n, n2);
                    }
                }
            };
            this.valueTable.getColumn(this.rgbName).setCellRenderer(new DefaultTableCellRenderer(){
                public static final long serialVersionUID = 240L;
                Color color = Color.white;

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    this.color = new Color(DefaultPaletteView.this.paletteData[0][n], DefaultPaletteView.this.paletteData[1][n], DefaultPaletteView.this.paletteData[2][n]);
                    component.setBackground(this.color);
                    return component;
                }
            });
            this.valueTable.setRowSelectionAllowed(false);
            this.valueTable.setCellSelectionEnabled(true);
            this.valueTable.getTableHeader().setReorderingAllowed(false);
            this.valueTable.setSelectionMode(0);
            int n = Math.max(16, this.valueTable.getFontMetrics(this.valueTable.getFont()).getHeight());
            this.valueTable.setRowHeight(n);
            JScrollPane jScrollPane = new JScrollPane(this.valueTable);
            JPanel jPanel = (JPanel)this.getContentPane();
            int n2 = 300 + (ViewProperties.getFontSize() - 12) * 10;
            int n3 = 600 + (ViewProperties.getFontSize() - 12) * 15;
            jPanel.setPreferredSize(new Dimension(n2, n3));
            jPanel.setLayout(new BorderLayout(5, 5));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.add((Component)jScrollPane, "Center");
            JButton jButton = new JButton("  Close  ");
            jButton.addActionListener(defaultPaletteView2);
            jButton.setActionCommand("Hide palette values");
            jPanel.add((Component)jButton, "South");
            Point point = defaultPaletteView2.getLocation();
            point.x += 100;
            point.y += 100;
            this.setLocation(point);
            this.pack();
        }

        private void updatePaletteValue(String string, int n, int n2) {
            int n3;
            if (string == null) {
                return;
            }
            ((DefaultPaletteView)DefaultPaletteView.this).paletteData[n2][n] = n3 = Integer.parseInt(string);
            DefaultPaletteView.this.chartP.repaint();
            DefaultPaletteView.this.isPaletteChanged = true;
        }

        public void paletteUpdated() {
            this.valueTable.updateUI();
        }
    }
}

