/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.Toolkit;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.view.DefaultFileFilter;

public class NewFileDialog
extends JFileChooser {
    public static final long serialVersionUID = 240L;
    private String fileType;
    private String currentDir;
    private String viewDir;
    private boolean fileCreated;
    private List fileList;
    private final Toolkit toolkit;
    private final JFrame viewer;
    private boolean isH5 = false;
    private boolean isH4 = false;

    public NewFileDialog(JFrame jFrame, String string, String string2, List list) {
        super(string);
        this.currentDir = string;
        this.viewer = jFrame;
        this.viewDir = string;
        this.fileType = string2;
        this.fileCreated = false;
        this.fileList = list;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.fileType == "HDF") {
            this.isH4 = true;
            this.setSelectedFile(new File("*.hdf"));
            this.setFileFilter(DefaultFileFilter.getFileFilterHDF4());
        } else if (this.fileType == "HDF5") {
            this.isH5 = true;
            this.setSelectedFile(new File("*.h5"));
            this.setFileFilter(DefaultFileFilter.getFileFilterHDF5());
        }
        this.currentDir = this.currentDir != null ? this.currentDir + File.separator : "";
        this.showSaveDialog(jFrame);
    }

    protected void fireActionPerformed(String string) {
        super.fireActionPerformed(string);
        this.fileCreated = string.equals("ApproveSelection") ? this.createNewFile() : false;
    }

    private boolean createNewFile() {
        String string5;
        Object object;
        File file = this.getSelectedFile();
        if (file == null) {
            return false;
        }
        String string2 = file.getAbsolutePath();
        if (string2 == null) {
            return false;
        }
        if ((string2 = string2.trim()) == null || string2.length() == 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Invalid file name.", this.viewer.getTitle(), 0);
            return false;
        }
        String string3 = FileFormat.getFileExtensions();
        boolean bl = true;
        if (string3 != null && string3.length() > 0) {
            object = new StringTokenizer(string3, ",");
            string5 = "";
            String string4 = string2.toLowerCase();
            while (((StringTokenizer)object).hasMoreTokens() && bl) {
                string5 = ((StringTokenizer)object).nextToken().trim().toLowerCase();
                bl = !string4.endsWith("." + string5);
            }
        }
        if (bl) {
            if (this.isH4) {
                string2 = string2 + ".hdf";
                file = new File(string2);
                this.setSelectedFile(file);
            } else if (this.isH5) {
                string2 = string2 + ".h5";
                file = new File(string2);
                this.setSelectedFile(file);
            }
        }
        if (file.exists() && file.isDirectory()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "File is a directory.", this.viewer.getTitle(), 0);
            return false;
        }
        object = file.getParentFile();
        if (object == null) {
            string2 = this.viewDir + File.separator + string2;
            file = new File(string2);
        } else if (!((File)object).exists()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "File path does not exist at\n" + ((File)object).getPath(), this.viewer.getTitle(), 0);
            return false;
        }
        if (this.fileList != null) {
            string5 = null;
            for (String string5 : this.fileList) {
                if (!string5.getFilePath().equals(string2)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to create the new file. \nThe file is being used.", this.viewer.getTitle(), 0);
                return false;
            }
        }
        int n = -1;
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.viewer.getTitle(), 0)) == 1) {
            return false;
        }
        this.currentDir = file.getParent();
        try {
            FileFormat.getFileFormat((String)this.fileType).create(string2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.viewer.getTitle(), 0);
            return false;
        }
        return true;
    }

    public boolean isFileCreated() {
        return this.fileCreated;
    }

    public String getFile() {
        String string = null;
        File file = this.getSelectedFile();
        if (file != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }
}

