/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewLinkDialog
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 240L;
    private JTextField nameField;
    private JComboBox parentChoice;
    private JComboBox linkToChoice;
    private JCheckBox checkUnsigned;
    private List groupList;
    private List objList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;

    public NewLinkDialog(JFrame jFrame, Group group, List list) {
        super(jFrame, "New Dataset...", true);
        Object object;
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.objList = list;
        this.parentChoice = new JComboBox();
        this.linkToChoice = new JComboBox();
        this.groupList = new Vector(list.size());
        HObject hObject = null;
        Iterator iterator = list.iterator();
        String string = null;
        int n = -1;
        int n2 = -1;
        while (iterator.hasNext()) {
            hObject = (HObject)iterator.next();
            ++n2;
            if (hObject instanceof Group) {
                object = (Group)hObject;
                this.groupList.add(hObject);
                if (object.isRoot()) {
                    string = "/";
                    n = n2;
                } else {
                    string = object.getPath() + object.getName() + "/";
                }
                this.parentChoice.addItem(string);
            } else {
                string = hObject.getPath() + hObject.getName();
            }
            this.linkToChoice.addItem(string);
        }
        this.linkToChoice.removeItemAt(n);
        this.objList.remove(n);
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(group.getPath() + group.getName() + "/");
        }
        object = (JPanel)this.getContentPane();
        ((Container)object).setLayout(new BorderLayout(5, 5));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n3 = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int n4 = 150 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object).setPreferredSize(new Dimension(n3, n4));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        ((Container)object).add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 1));
        jPanel3.add(new JLabel("Link name: "));
        jPanel3.add(new JLabel("Parent group: "));
        jPanel3.add(new JLabel("Link to: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 1));
        this.nameField = new JTextField();
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        jPanel3.add(this.linkToChoice);
        jPanel2.add((Component)jPanel3, "Center");
        ((Container)object).add((Component)jPanel2, "Center");
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 100;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.newObject = this.createLink();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        }
    }

    private HObject createLink() {
        String string = null;
        Group group = null;
        string = this.nameField.getText().trim();
        if (string == null || string.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        HObject hObject = (HObject)this.objList.get(this.linkToChoice.getSelectedIndex());
        if (hObject == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Target object is null.", this.getTitle(), 0);
            return null;
        }
        if (hObject instanceof Group && ((Group)hObject).isRoot()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot make a link to the root group.", this.getTitle(), 0);
            return null;
        }
        HObject hObject2 = null;
        try {
            hObject2 = this.fileFormat.createLink(group, string, hObject);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return null;
        }
        return hObject2;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

