/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import ncsa.hdf.object.FileFormat;

public class ViewProperties
extends Properties {
    public static final long serialVersionUID = 240L;
    public static final String VERSION = "2.4";
    public static final int MAX_RECENT_FILES = 15;
    private static final String USER_PROPERTY_FILE = ".hdfview2.4";
    public static final String DELIMITER_TAB = "Tab";
    public static final String DELIMITER_COMMA = "Comma";
    public static final String DELIMITER_SPACE = "Space";
    public static final String DELIMITER_COLON = "Colon";
    public static final String DELIMITER_SEMI_COLON = "Semi-Colon";
    private static String usersGuide = System.getProperty("user.dir") + "/UsersGuide/index.html";
    private static int fontSize = 12;
    private static String fontType = null;
    private static String h4toh5 = "";
    private static String delimiter = "Tab";
    private static Vector mrf;
    private static String rootDir;
    private static String workDir;
    private static String fileExt;
    private static ClassLoader extClassLoader;
    private static Vector srbAccountList;
    private static boolean isAutoContrast;
    private static boolean convertEnum;
    private static int max_members;
    private static int start_members;
    private static Icon hdfIcon;
    private static Icon h4Icon;
    private static Icon h5Icon;
    private static Icon largeHdfIcon;
    private static Icon blankIcon;
    private static Icon helpIcon;
    private static Icon fileopenIcon;
    private static Icon filesaveIcon;
    private static Icon filenewIcon;
    private static Icon filecloseIcon;
    private static Icon foldercloseIcon;
    private static Icon folderopenIcon;
    private static Icon foldercloseIconA;
    private static Icon folderopenIconA;
    private static Icon datasetIcon;
    private static Icon imageIcon;
    private static Icon tableIcon;
    private static Icon textIcon;
    private static Icon datasetIconA;
    private static Icon imageIconA;
    private static Icon tableIconA;
    private static Icon textIconA;
    private static Icon zoominIcon;
    private static Icon zoomoutIcon;
    private static Icon paletteIcon;
    private static Icon chartIcon;
    private static Icon brightIcon;
    private static Icon autocontrastIcon;
    private static Icon copyIcon;
    private static Icon cutIcon;
    private static Icon pasteIcon;
    private static Icon previousIcon;
    private static Icon nextIcon;
    private static Icon firstIcon;
    private static Icon lastIcon;
    private static Icon animationIcon;
    private static Icon datatypeIcon;
    private static Icon datatypeIconA;
    private static Icon linkIcon;
    private static String propertyFile;
    private static Vector moduleListTreeView;
    private static Vector moduleListMetaDataView;
    private static Vector moduleListTextView;
    private static Vector moduleListTableView;
    private static Vector moduleListImageView;
    private static Vector moduleListPaletteView;
    private static Vector moduleListHelpView;

    public ViewProperties(String string) {
        rootDir = string;
        mrf = new Vector(20);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = USER_PROPERTY_FILE;
        string2 = System.getProperty("user.home") + File.separator + string5;
        string3 = System.getProperty("user.dir") + File.separator + string5;
        string4 = string + File.separator + "lib" + File.separator + string5;
        if (new File(string2).exists()) {
            propertyFile = string2;
        } else if (new File(string3).exists()) {
            propertyFile = string3;
        } else {
            propertyFile = string2;
            File file = new File(string2);
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                propertyFile = null;
            }
        }
    }

    public synchronized Enumeration keys() {
        Enumeration<Object> enumeration = super.keys();
        Vector<Object> vector = new Vector<Object>(50);
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Collections.sort(vector);
        return vector.elements();
    }

    public static ClassLoader loadExtClass() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        if (extClassLoader != null) {
            return extClassLoader;
        }
        extClassLoader = ClassLoader.getSystemClassLoader();
        String string = System.getProperty("hdfview.root");
        String string2 = string + File.separator + "lib" + File.separator + "ext" + File.separator;
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length <= 0) {
            return extClassLoader;
        }
        Vector<String> vector = new Vector<String>(50);
        Vector<String> vector2 = new Vector<String>(50);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].endsWith(".jar")) continue;
            vector.add(stringArray[n2]);
            object4 = new File(file, stringArray[n2]);
            try {
                JarFile jarFile = new JarFile((File)object4, false, 1);
                object3 = jarFile.entries();
                while (object3.hasMoreElements()) {
                    object2 = (JarEntry)object3.nextElement();
                    object = ((ZipEntry)object2).getName();
                    n = ((String)object).indexOf(".class");
                    if (n <= 0 || ((String)object).indexOf(36) > 0) continue;
                    object = ((String)object).replace('/', '.');
                    vector2.add(((String)object).substring(0, n));
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n2 = vector.size();
        if (n2 <= 0) {
            return extClassLoader;
        }
        object4 = new URL[n2];
        for (int i = 0; i < n2; ++i) {
            try {
                object4[i] = new URL("file:///" + string + "/lib/ext/" + vector.get(i));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            extClassLoader = URLClassLoader.newInstance(object4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        n2 = vector2.size();
        block15: for (int i = 0; i < n2; ++i) {
            object3 = (String)vector2.get(i);
            try {
                object2 = null;
                try {
                    object2 = Class.forName((String)object3);
                }
                catch (Exception exception) {
                    object2 = extClassLoader.loadClass((String)object3);
                }
                object = ((Class)object2).getInterfaces();
                if (object == null) continue;
                for (n = 0; n < ((Class<?>[])object).length; ++n) {
                    String string3 = object[n].getName();
                    if ("ncsa.hdf.view.TreeView".equals(string3)) {
                        moduleListTreeView.add(object3);
                        continue block15;
                    }
                    if ("ncsa.hdf.view.MetaDataView".equals(string3)) {
                        moduleListMetaDataView.add(object3);
                        continue block15;
                    }
                    if ("ncsa.hdf.view.TextView".equals(string3)) {
                        moduleListTextView.add(object3);
                        continue block15;
                    }
                    if ("ncsa.hdf.view.TableView".equals(string3)) {
                        moduleListTableView.add(object3);
                        continue block15;
                    }
                    if ("ncsa.hdf.view.ImageView".equals(string3)) {
                        moduleListImageView.add(object3);
                        continue block15;
                    }
                    if ("ncsa.hdf.view.PaletteView".equals(string3)) {
                        moduleListPaletteView.add(object3);
                        continue block15;
                    }
                    if (!"ncsa.hdf.view.HelpView".equals(string3)) continue;
                    try {
                        moduleListHelpView.add(((Class)object2).newInstance());
                    }
                    catch (Throwable throwable) {}
                    continue block15;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return extClassLoader;
    }

    public static String getViewRoot() {
        return rootDir;
    }

    public static Icon getFoldercloseIcon() {
        return foldercloseIcon;
    }

    public static Icon getFoldercloseIconA() {
        return foldercloseIconA;
    }

    public static Icon getFolderopenIcon() {
        return folderopenIcon;
    }

    public static Icon getFolderopenIconA() {
        return folderopenIconA;
    }

    public static Icon getHdfIcon() {
        return hdfIcon;
    }

    public static Icon getH4Icon() {
        return h4Icon;
    }

    public static Icon getH5Icon() {
        return h5Icon;
    }

    public static Icon getDatasetIcon() {
        return datasetIcon;
    }

    public static Icon getDatasetIconA() {
        return datasetIconA;
    }

    public static Icon getDatatypeIcon() {
        return datatypeIcon;
    }

    public static Icon getDatatypeIconA() {
        return datatypeIconA;
    }

    public static Icon getLinkIcon() {
        return linkIcon;
    }

    public static Icon getFileopenIcon() {
        return fileopenIcon;
    }

    public static Icon getFilesaveIcon() {
        return filesaveIcon;
    }

    public static Icon getFilenewIcon() {
        return filenewIcon;
    }

    public static Icon getFilecloseIcon() {
        return filecloseIcon;
    }

    public static Icon getPaletteIcon() {
        return paletteIcon;
    }

    public static Icon getBrightIcon() {
        return brightIcon;
    }

    public static Icon getAutocontrastIcon() {
        return autocontrastIcon;
    }

    public static Icon getImageIcon() {
        return imageIcon;
    }

    public static Icon getTableIcon() {
        return tableIcon;
    }

    public static Icon getTextIcon() {
        return textIcon;
    }

    public static Icon getImageIconA() {
        return imageIconA;
    }

    public static Icon getTableIconA() {
        return tableIconA;
    }

    public static Icon getTextIconA() {
        return textIconA;
    }

    public static Icon getZoominIcon() {
        return zoominIcon;
    }

    public static Icon getZoomoutIcon() {
        return zoomoutIcon;
    }

    public static Icon getBlankIcon() {
        return blankIcon;
    }

    public static Icon getHelpIcon() {
        return helpIcon;
    }

    public static Icon getCopyIcon() {
        return copyIcon;
    }

    public static Icon getCutIcon() {
        return cutIcon;
    }

    public static Icon getPasteIcon() {
        return pasteIcon;
    }

    public static Icon getLargeHdfIcon() {
        return largeHdfIcon;
    }

    public static Icon getPreviousIcon() {
        return previousIcon;
    }

    public static Icon getNextIcon() {
        return nextIcon;
    }

    public static Icon getFirstIcon() {
        return firstIcon;
    }

    public static Icon getLastIcon() {
        return lastIcon;
    }

    public static Icon getChartIcon() {
        return chartIcon;
    }

    public static Icon getAnimationIcon() {
        return animationIcon;
    }

    public static void loadIcons(String string) {
        URL uRL = null;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (hdfIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/hdf.gif")) != null) {
            hdfIcon = new ImageIcon(uRL);
        }
        if (h4Icon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/hdf4.gif")) != null) {
            h4Icon = new ImageIcon(uRL);
        }
        if (h5Icon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/hdf5.gif")) != null) {
            h5Icon = new ImageIcon(uRL);
        }
        if (foldercloseIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/folderclose.gif")) != null) {
            foldercloseIcon = new ImageIcon(uRL);
        }
        if (foldercloseIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/foldercloseA.gif")) != null) {
            foldercloseIconA = new ImageIcon(uRL);
        }
        if (folderopenIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/folderopen.gif")) != null) {
            folderopenIcon = new ImageIcon(uRL);
        }
        if (folderopenIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/folderopenA.gif")) != null) {
            folderopenIconA = new ImageIcon(uRL);
        }
        if (datasetIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/dataset.gif")) != null) {
            datasetIcon = new ImageIcon(uRL);
        }
        if (datasetIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/datasetA.gif")) != null) {
            datasetIconA = new ImageIcon(uRL);
        }
        if (datatypeIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/datatype.gif")) != null) {
            datatypeIcon = new ImageIcon(uRL);
        }
        if (datatypeIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/datatypeA.gif")) != null) {
            datatypeIconA = new ImageIcon(uRL);
        }
        if (linkIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/link.gif")) != null) {
            linkIcon = new ImageIcon(uRL);
        }
        if (fileopenIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/fileopen.gif")) != null) {
            fileopenIcon = new ImageIcon(uRL);
        }
        if (filesaveIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/filesave.gif")) != null) {
            filesaveIcon = new ImageIcon(uRL);
        }
        if (filenewIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/filenew.gif")) != null) {
            filenewIcon = new ImageIcon(uRL);
        }
        if (filecloseIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/fileclose.gif")) != null) {
            filecloseIcon = new ImageIcon(uRL);
        }
        if (paletteIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/palette.gif")) != null) {
            paletteIcon = new ImageIcon(uRL);
        }
        if (brightIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/brightness.gif")) != null) {
            brightIcon = new ImageIcon(uRL);
        }
        if (autocontrastIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/autocontrast.gif")) != null) {
            autocontrastIcon = new ImageIcon(uRL);
        }
        if (imageIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/image.gif")) != null) {
            imageIcon = new ImageIcon(uRL);
        }
        if (imageIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/imageA.gif")) != null) {
            imageIconA = new ImageIcon(uRL);
        }
        if (tableIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/table.gif")) != null) {
            tableIcon = new ImageIcon(uRL);
        }
        if (tableIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/tableA.gif")) != null) {
            tableIconA = new ImageIcon(uRL);
        }
        if (textIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/text.gif")) != null) {
            textIcon = new ImageIcon(uRL);
        }
        if (textIconA == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/textA.gif")) != null) {
            textIconA = new ImageIcon(uRL);
        }
        if (zoominIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/zoomin.gif")) != null) {
            zoominIcon = new ImageIcon(uRL);
        }
        if (zoomoutIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/zoomout.gif")) != null) {
            zoomoutIcon = new ImageIcon(uRL);
        }
        if (blankIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/blank.gif")) != null) {
            blankIcon = new ImageIcon(uRL);
        }
        if (helpIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/help.gif")) != null) {
            helpIcon = new ImageIcon(uRL);
        }
        if (copyIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/copy.gif")) != null) {
            copyIcon = new ImageIcon(uRL);
        }
        if (cutIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/cut.gif")) != null) {
            cutIcon = new ImageIcon(uRL);
        }
        if (pasteIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/paste.gif")) != null) {
            pasteIcon = new ImageIcon(uRL);
        }
        if (largeHdfIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/hdf_large.gif")) != null) {
            largeHdfIcon = new ImageIcon(uRL);
        }
        if (previousIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/previous.gif")) != null) {
            previousIcon = new ImageIcon(uRL);
        }
        if (nextIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/next.gif")) != null) {
            nextIcon = new ImageIcon(uRL);
        }
        if (firstIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/first.gif")) != null) {
            firstIcon = new ImageIcon(uRL);
        }
        if (lastIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/last.gif")) != null) {
            lastIcon = new ImageIcon(uRL);
        }
        if (chartIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/chart.gif")) != null) {
            chartIcon = new ImageIcon(uRL);
        }
        if (animationIcon == null && (uRL = classLoader.getResource("ncsa/hdf/view/icons/animation.gif")) != null) {
            animationIcon = new ImageIcon(uRL);
        }
    }

    public void load() throws Exception {
        int n;
        File file;
        Object object;
        String string;
        Object object2;
        if (propertyFile == null) {
            return;
        }
        ViewProperties.loadExtClass();
        try {
            object2 = new FileInputStream(propertyFile);
            this.load((InputStream)object2);
            ((FileInputStream)object2).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = this.keys();
        String string2 = null;
        String string3 = null;
        while (object2.hasMoreElements()) {
            string2 = (String)object2.nextElement();
            if (!string2.startsWith("module.fileformat")) continue;
            string3 = string2.substring(18);
            try {
                string = (String)this.get(string2);
                object = null;
                try {
                    object = Class.forName(string);
                }
                catch (Exception exception) {
                    try {
                        object = extClassLoader.loadClass(string);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (!((file = ((Class)object).newInstance()) instanceof FileFormat)) continue;
                FileFormat.addFileFormat((String)string3, (FileFormat)((FileFormat)file));
            }
            catch (Throwable throwable) {}
        }
        string = (String)this.get("users.guide");
        if (string != null) {
            object = string.toLowerCase();
            usersGuide = ((String)object).startsWith("file:") || ((String)object).startsWith("http:") ? string : ((file = new File(string)).exists() ? "file:" + string : "http://" + string);
        }
        if ((string = (String)this.get("image.contrast")) != null) {
            isAutoContrast = "auto".equalsIgnoreCase(string);
        }
        if ((string = (String)this.get("enum.conversion")) != null) {
            convertEnum = "true".equalsIgnoreCase(string);
        }
        if ((string = (String)this.get("data.delimiter")) != null && string.length() > 0) {
            delimiter = string;
        }
        if ((string = (String)this.get("h4toh5.converter")) != null && string.length() > 0) {
            h4toh5 = string;
        }
        if ((string = (String)this.get("work.dir")) != null && string.length() > 0) {
            workDir = string;
        }
        if ((string = (String)this.get("file.extension")) != null && string.length() > 0) {
            fileExt = string;
            FileFormat.addFileExtension((String)fileExt);
        }
        if ((string = (String)this.get("font.size")) != null && string.length() > 0) {
            try {
                fontSize = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = (String)this.get("font.type")) != null && string.length() > 0) {
            fontType = string.trim();
        }
        if ((string = (String)this.get("max.members")) != null && string.length() > 0) {
            try {
                max_members = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        for (int i = 0; i < 15; ++i) {
            object = this.getProperty("recent.file" + i);
            if (object != null && !mrf.contains(object)) {
                if (!((String)object).startsWith("http://") && !((String)object).startsWith("ftp://") && !new File((String)object).exists()) continue;
                mrf.addElement(object);
                continue;
            }
            this.remove("recent.file" + i);
        }
        string = null;
        String[] stringArray = new String[7];
        for (int i = 0; i < 15; ++i) {
            stringArray[0] = this.getProperty("srbaccount" + i + ".host");
            if (null == stringArray[0] || null == (stringArray[1] = this.getProperty("srbaccount" + i + ".port")) || null == (stringArray[2] = this.getProperty("srbaccount" + i + ".user")) || null == (stringArray[3] = this.getProperty("srbaccount" + i + ".password")) || null == (stringArray[4] = this.getProperty("srbaccount" + i + ".home")) || null == (stringArray[5] = this.getProperty("srbaccount" + i + ".domain")) || null == (stringArray[6] = this.getProperty("srbaccount" + i + ".resource"))) continue;
            srbAccountList.add(stringArray);
            stringArray = new String[7];
        }
        String[] stringArray2 = new String[]{"module.treeview", "module.metadataview", "module.textview", "module.tableview", "module.imageview", "module.paletteview"};
        Vector[] vectorArray = new Vector[]{moduleListTreeView, moduleListMetaDataView, moduleListTextView, moduleListTableView, moduleListImageView, moduleListPaletteView};
        String[] stringArray3 = new String[]{"ncsa.hdf.view.DefaultTreeView", "ncsa.hdf.view.DefaultMetaDataView", "ncsa.hdf.view.DefaultTextView", "ncsa.hdf.view.DefaultTableView", "ncsa.hdf.view.DefaultImageView", "ncsa.hdf.view.DefaultPaletteView"};
        for (n = 0; n < 6; ++n) {
            if (vectorArray[n].contains(stringArray3[n])) continue;
            vectorArray[n].addElement(stringArray3[n]);
        }
        for (n = 0; n < 6; ++n) {
            Vector vector = vectorArray[n];
            string = (String)this.get(stringArray2[n]);
            if (!vector.contains(string)) {
                string = stringArray3[n];
            }
            vector.remove(string);
            vector.add(0, string);
        }
    }

    public void save() {
        FileOutputStream fileOutputStream;
        if (propertyFile == null) {
            return;
        }
        this.clear();
        if (delimiter == null) {
            this.put("data.delimiter", DELIMITER_TAB);
        } else {
            this.put("data.delimiter", delimiter);
        }
        if (usersGuide != null) {
            this.put("users.guide", usersGuide);
        }
        if (workDir != null) {
            this.put("work.dir", workDir);
        }
        if (fileExt != null) {
            this.put("file.extension", fileExt);
        }
        if (h4toh5 != null) {
            this.put("h4toh5.converter", h4toh5);
        }
        this.put("font.size", String.valueOf(fontSize));
        if (fontType != null) {
            this.put("font.type", fontType);
        }
        this.put("max.members", String.valueOf(max_members));
        if (isAutoContrast) {
            this.put("image.contrast", "auto");
        } else {
            this.put("image.contrast", "general");
        }
        this.put("enum.conversion", String.valueOf(convertEnum));
        int n = mrf.size();
        int n2 = Math.min(n, 15);
        for (int i = 0; i < n2; ++i) {
            String string = (String)mrf.elementAt(i);
            if (string == null || string.length() <= 0) continue;
            this.put("recent.file" + i, string);
        }
        String[] stringArray = null;
        n = srbAccountList.size();
        n2 = Math.min(n, 15);
        for (int i = 0; i < n2; ++i) {
            stringArray = (String[])srbAccountList.get(i);
            if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null || stringArray[3] == null || stringArray[4] == null || stringArray[5] == null || stringArray[6] == null) continue;
            this.put("srbaccount" + i + ".host", stringArray[0]);
            this.put("srbaccount" + i + ".port", stringArray[1]);
            this.put("srbaccount" + i + ".user", stringArray[2]);
            this.put("srbaccount" + i + ".password", stringArray[3]);
            this.put("srbaccount" + i + ".home", stringArray[4]);
            this.put("srbaccount" + i + ".domain", stringArray[5]);
            this.put("srbaccount" + i + ".resource", stringArray[6]);
        }
        String string = (String)moduleListTreeView.elementAt(0);
        if (string != null && string.length() > 0) {
            this.put("module.treeview", string);
        }
        if ((string = (String)moduleListMetaDataView.elementAt(0)) != null && string.length() > 0) {
            this.put("module.metadataview", string);
        }
        if ((string = (String)moduleListTextView.elementAt(0)) != null && string.length() > 0) {
            this.put("module.textview", string);
        }
        if ((string = (String)moduleListTableView.elementAt(0)) != null && string.length() > 0) {
            this.put("module.tableview", string);
        }
        if ((string = (String)moduleListImageView.elementAt(0)) != null && string.length() > 0) {
            this.put("module.imageview", string);
        }
        if ((string = (String)moduleListPaletteView.elementAt(0)) != null && string.length() > 0) {
            this.put("module.paletteview", string);
        }
        Enumeration enumeration = FileFormat.getFileFormatKeys();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            fileOutputStream = FileFormat.getFileFormat((String)string2);
            this.put("module.fileformat." + string2, fileOutputStream.getClass().getName());
        }
        try {
            fileOutputStream = new FileOutputStream(propertyFile);
            this.store(fileOutputStream, "User properties modified on ");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPropertyFile() {
        return propertyFile;
    }

    public static String getWorkDir() {
        if (workDir.equals("user.dir")) {
            workDir = System.getProperty("user.dir");
        }
        return workDir;
    }

    public static int getMaxRecentFiles() {
        return 15;
    }

    public static String getUsersGuide() {
        return usersGuide;
    }

    public static String getDataDelimiter() {
        return delimiter;
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static String getFontType() {
        return fontType;
    }

    public static String getFileExtension() {
        return fileExt;
    }

    public static void setFontSize(int n) {
        fontSize = n / 2 * 2;
        if (fontSize < 8) {
            fontSize = 8;
        }
    }

    public static void setFontType(String string) {
        if (string != null) {
            fontType = string.trim();
        }
    }

    public static String getH4toH5() {
        return h4toh5;
    }

    public static Vector getMRF() {
        return mrf;
    }

    public static Vector getSrbAccount() {
        return srbAccountList;
    }

    public static Vector getTreeViewList() {
        return moduleListTreeView;
    }

    public static Vector getMetaDataViewList() {
        return moduleListMetaDataView;
    }

    public static Vector getTextViewList() {
        return moduleListTextView;
    }

    public static Vector getTableViewList() {
        return moduleListTableView;
    }

    public static Vector getImageViewList() {
        return moduleListImageView;
    }

    public static Vector getPaletteViewList() {
        return moduleListPaletteView;
    }

    public static Vector getHelpViewList() {
        return moduleListHelpView;
    }

    public static void setUsersGuide(String string) {
        File file;
        if (string == null || string.length() <= 0) {
            return;
        }
        String string2 = string.toLowerCase();
        usersGuide = string2.startsWith("file:") || string2.startsWith("http:") ? string : ((file = new File(string)).exists() ? "file:" + string : "http://" + string);
    }

    public static void setH4toH5(String string) {
        h4toh5 = string;
    }

    public static void setWorkDir(String string) {
        workDir = string;
    }

    public static void setFileExtension(String string) {
        fileExt = string;
    }

    public static void setDataDelimiter(String string) {
        delimiter = string;
    }

    public static void setMaxMembers(int n) {
        max_members = n;
    }

    public static void setStartMembers(int n) {
        if (n < 0) {
            n = 0;
        }
        start_members = n;
    }

    public static int getMaxMembers() {
        return max_members;
    }

    public static int getStartMembers() {
        return start_members;
    }

    public static boolean isAutoContrast() {
        return isAutoContrast;
    }

    public static void setAutoContrast(boolean bl) {
        isAutoContrast = bl;
    }

    public static boolean isConvertEnum() {
        return convertEnum;
    }

    public static void setConvertEnum(boolean bl) {
        convertEnum = bl;
    }

    static {
        workDir = "user.dir";
        fileExt = "hdf, h4, hdf4, h5, hdf5, he4, he5";
        extClassLoader = null;
        srbAccountList = new Vector(5);
        isAutoContrast = true;
        convertEnum = false;
        max_members = 10000;
        start_members = 0;
        moduleListTreeView = new Vector(5);
        moduleListMetaDataView = new Vector(5);
        moduleListTextView = new Vector(5);
        moduleListTableView = new Vector(5);
        moduleListImageView = new Vector(5);
        moduleListPaletteView = new Vector(5);
        moduleListHelpView = new Vector(5);
    }
}

