/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.log.scanner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class JCoreLogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String headingLine = "<ddmmyyyy> | <hh:mm:ss:ttt> | <severity> | <hostName> | <component> | <logicalDevice> | <resultCode> | <description>\n\n";

    @Override
    public String format(LogRecord logRecord) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.formatMessage(logRecord).equals(headingLine)) {
            stringBuilder.append(headingLine);
        } else {
            object = Calendar.getInstance();
            stringBuilder.append(((Calendar)object).get(5));
            stringBuilder.append("-");
            stringBuilder.append(((Calendar)object).get(2) + 1);
            stringBuilder.append("-");
            stringBuilder.append(((Calendar)object).get(1));
            stringBuilder.append(" | ");
            stringBuilder.append(((Calendar)object).get(11));
            stringBuilder.append(":");
            stringBuilder.append(((Calendar)object).get(12));
            stringBuilder.append(":");
            stringBuilder.append(((Calendar)object).get(13));
            stringBuilder.append(":");
            stringBuilder.append(((Calendar)object).get(14));
            stringBuilder.append(this.formatMessage(logRecord));
            stringBuilder.append(LINE_SEPARATOR);
        }
        if (logRecord.getThrown() != null) {
            try {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(((StringWriter)object).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }
}

