/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.log.scanner;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class JCoreLoggerProperty {
    static final String LOG_TRACE_FILE_NAME = "jpos_trace.properties";
    static final String MSI_KEY_LOGFILE_NAME = "logFileName";
    static final String MSI_KEY_LOGFILE_PATH = "logFilePath";
    static final String MSI_KEY_LOGFILE_SIZE = "logFileSize";
    static final String MSI_KEY_LOGFILE_COUNT = "logFileCount";
    static final String MSI_KEY_LOG_LEVEL = "logLevel";
    static final String MSI_KEY_SHOW_SENSITIVE_INFO = "showSensitiveInfo";
    static final String MSI_KEY_ENABLE_CIM_PROPERTY_FILE = "enableCimPropertyFile";
    FileInputStream fis = null;
    public boolean setProperty = true;
    Properties prop = null;

    public JCoreLoggerProperty() {
        this.OpenProperties();
    }

    private void OpenProperties() {
        InputStream inputStream = null;
        try {
            this.prop = new Properties();
            inputStream = JCoreLoggerProperty.class.getResourceAsStream("/jpos_trace.properties");
            this.prop.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            this.setProperty = false;
            System.err.println("Couldn't locate jpos_trace.properties file. JPOS trace will be disabled. ");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String GetLogFilePath() {
        return this.prop.getProperty(MSI_KEY_LOGFILE_PATH);
    }

    public String GetLogFileName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.prop.getProperty(MSI_KEY_LOGFILE_NAME));
        stringBuilder.append("SCANNER_");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd_hh-mm-ss");
        stringBuilder.append(simpleDateFormat.format(new Date()));
        return stringBuilder.toString();
    }

    public int GetLogFileSize() {
        return Integer.parseInt(this.prop.getProperty(MSI_KEY_LOGFILE_SIZE));
    }

    public int GetLogFileCount() {
        return Integer.parseInt(this.prop.getProperty(MSI_KEY_LOGFILE_COUNT));
    }

    public int GetLogLevel() {
        int n = 0;
        try {
            n = Integer.parseInt(this.prop.getProperty(MSI_KEY_LOG_LEVEL));
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public int GetShowSensitiveInfo() {
        int n = 0;
        try {
            n = Integer.parseInt(this.prop.getProperty(MSI_KEY_SHOW_SENSITIVE_INFO));
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public int GetEnableCimPropertyFile() {
        int n = 0;
        try {
            n = Integer.parseInt(this.prop.getProperty(MSI_KEY_ENABLE_CIM_PROPERTY_FILE));
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }
}

