/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.sun.tools.doclets.formats.html.ClassWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.TagletOutputImpl;
import com.sun.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Modifier;
import java.util.List;

public abstract class AbstractMemberWriter {
    protected boolean printedSummaryHeader = false;
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    public final boolean nodepr;

    public AbstractMemberWriter(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        this.writer = subWriterHolderWriter;
        this.nodepr = this.configuration().nodeprecated;
        this.classdoc = classDoc;
    }

    public AbstractMemberWriter(SubWriterHolderWriter subWriterHolderWriter) {
        this(subWriterHolderWriter, null);
    }

    public abstract void printSummaryLabel(ClassDoc var1);

    public abstract void printInheritedSummaryLabel(ClassDoc var1);

    public abstract void printSummaryAnchor(ClassDoc var1);

    public abstract void printInheritedSummaryAnchor(ClassDoc var1);

    protected abstract void printSummaryType(ProgramElementDoc var1);

    protected void writeSummaryLink(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writeSummaryLink(3, classDoc, programElementDoc);
    }

    protected abstract void writeSummaryLink(int var1, ClassDoc var2, ProgramElementDoc var3);

    protected abstract void writeInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void writeDeprecatedLink(ProgramElementDoc var1);

    protected abstract void printNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void printNavDetailLink(boolean var1);

    protected void print(String string) {
        this.writer.print(string);
        this.writer.displayLength += string.length();
    }

    protected void print(char c) {
        this.writer.print(c);
        ++this.writer.displayLength;
    }

    protected void bold(String string) {
        this.writer.bold(string);
        this.writer.displayLength += string.length();
    }

    protected String modifierString(MemberDoc memberDoc) {
        int n = memberDoc.modifierSpecifier();
        int n2 = 288;
        return Modifier.toString(n & ~n2);
    }

    protected String typeString(MemberDoc memberDoc) {
        String string = "";
        if (memberDoc instanceof MethodDoc) {
            string = ((Object)((MethodDoc)memberDoc).returnType()).toString();
        } else if (memberDoc instanceof FieldDoc) {
            string = ((Object)((FieldDoc)memberDoc).type()).toString();
        }
        return string;
    }

    protected void printModifiers(MemberDoc memberDoc) {
        String string = this.modifierString(memberDoc);
        if ((memberDoc.isField() || memberDoc.isMethod()) && this.writer instanceof ClassWriterImpl && ((ClassWriterImpl)this.writer).getClassDoc().isInterface()) {
            string = Util.replaceText(string, "public", "").trim();
        }
        if (string.length() > 0) {
            this.print(string);
            this.print(' ');
        }
    }

    protected String makeSpace(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected void printStaticAndType(boolean bl, Type type) {
        this.writer.printTypeSummaryHeader();
        if (bl) {
            this.print("static");
        }
        this.writer.space();
        if (type != null) {
            this.writer.printLink(new LinkInfoImpl(3, type));
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifierAndType(ProgramElementDoc programElementDoc, Type type) {
        this.writer.printTypeSummaryHeader();
        this.printModifier(programElementDoc);
        if (type == null) {
            this.writer.space();
            if (programElementDoc.isClass()) {
                this.print("class");
            } else {
                this.print("interface");
            }
        } else if (programElementDoc instanceof ExecutableMemberDoc && ((ExecutableMemberDoc)programElementDoc).typeParameters().length > 0) {
            this.writer.table(0, 0, 0);
            this.writer.trAlignVAlign("right", "");
            this.writer.tdNowrap();
            this.writer.font("-1");
            this.writer.code();
            int n = ((AbstractExecutableMemberWriter)this).writeTypeParameters((ExecutableMemberDoc)programElementDoc);
            if (n > 10) {
                this.writer.br();
            }
            this.writer.printLink(new LinkInfoImpl(17, type));
            this.writer.codeEnd();
            this.writer.fontEnd();
            this.writer.tdEnd();
            this.writer.trEnd();
            this.writer.tableEnd();
        } else {
            this.writer.space();
            this.writer.printLink(new LinkInfoImpl(17, type));
        }
        this.writer.printTypeSummaryFooter();
    }

    private void printModifier(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isProtected()) {
            this.print("protected ");
        } else if (programElementDoc.isPrivate()) {
            this.print("private ");
        } else if (!programElementDoc.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (programElementDoc.isMethod() && ((MethodDoc)programElementDoc).isAbstract()) {
            this.print("abstract ");
        }
        if (programElementDoc.isStatic()) {
            this.print("static");
        }
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment(programElementDoc);
        }
    }

    protected String name(ProgramElementDoc programElementDoc) {
        return programElementDoc.name();
    }

    protected void printHead(MemberDoc memberDoc) {
        this.writer.h3();
        this.writer.print(memberDoc.name());
        this.writer.h3End();
    }

    protected void printFullComment(ProgramElementDoc programElementDoc) {
        if (this.configuration().nocomment) {
            return;
        }
        this.writer.dl();
        this.print(((TagletOutputImpl)new DeprecatedTaglet().getTagletOutput(programElementDoc, this.writer.getTagletWriterInstance(false))).toString());
        this.printCommentAndTags(programElementDoc);
        this.writer.dlEnd();
    }

    protected void printCommentAndTags(ProgramElementDoc programElementDoc) {
        this.printComment(programElementDoc);
        this.writer.printTags(programElementDoc);
    }

    public void printSummaryHeader(ClassDoc classDoc) {
        this.printedSummaryHeader = true;
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void printInheritedSummaryHeader(ClassDoc classDoc) {
        this.writer.printInheritedSummaryHeader(this, classDoc);
    }

    public void printInheritedSummaryFooter(ClassDoc classDoc) {
        this.writer.printInheritedSummaryFooter(this, classDoc);
    }

    public void printSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    protected boolean isInherited(ProgramElementDoc programElementDoc) {
        return !programElementDoc.isPrivate() && (!programElementDoc.isPackagePrivate() || programElementDoc.containingPackage().equals(this.classdoc.containingPackage()));
    }

    protected void printDeprecatedAPI(List list, String string) {
        if (list.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableHeaderStart("#CCCCFF");
            this.writer.boldText(string);
            this.writer.tableHeaderEnd();
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(i);
                this.writer.trBgcolorStyle("white", "TableRowColor");
                this.writer.summaryRow(0);
                this.writeDeprecatedLink(programElementDoc);
                this.writer.br();
                this.writer.printNbsps();
                if (programElementDoc.tags("deprecated").length > 0) {
                    this.writer.printInlineDeprecatedComment(programElementDoc, programElementDoc.tags("deprecated")[0]);
                }
                this.writer.space();
                this.writer.summaryRowEnd();
                this.writer.trEnd();
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void printUseInfo(Object object, String string) {
        if (object == null) {
            return;
        }
        List list = (List)object;
        if (list.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableUseInfoHeaderStart("#CCCCFF");
            this.writer.print(string);
            this.writer.tableHeaderEnd();
            for (ProgramElementDoc programElementDoc : list) {
                ClassDoc classDoc = programElementDoc.containingClass();
                this.writer.printSummaryLinkType(this, programElementDoc);
                if (classDoc != null && !(programElementDoc instanceof ConstructorDoc) && !(programElementDoc instanceof ClassDoc)) {
                    this.writer.bold(classDoc.name() + ".");
                }
                this.writeSummaryLink(programElementDoc instanceof ClassDoc ? 4 : 3, classDoc, programElementDoc);
                this.writer.printSummaryLinkComment(this, programElementDoc);
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void navDetailLink(List list) {
        this.printNavDetailLink(list.size() > 0);
    }

    protected void navSummaryLink(List list, VisibleMemberMap visibleMemberMap) {
        if (list.size() > 0) {
            this.printNavSummaryLink(null, true);
            return;
        }
        for (ClassDoc classDoc = this.classdoc.superclass(); classDoc != null; classDoc = classDoc.superclass()) {
            List list2 = visibleMemberMap.getMembersFor(classDoc);
            if (list2.size() <= 0) continue;
            this.printNavSummaryLink(classDoc, true);
            return;
        }
        this.printNavSummaryLink(null, false);
    }

    protected void serialWarning(SourcePosition sourcePosition, String string, String string2, String string3) {
        if (this.configuration().serialwarn) {
            ConfigurationImpl.getInstance().getDocletSpecificMsg().warning(sourcePosition, string, string2, string3);
        }
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] programElementDocArray) {
        return this.nodepr ? Util.excludeDeprecatedMembers(programElementDocArray) : programElementDocArray;
    }

    public ConfigurationImpl configuration() {
        return this.writer.configuration;
    }

    public void writeMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, Tag[] tagArray, boolean bl, boolean bl2) {
        this.writer.printSummaryLinkType(this, programElementDoc);
        this.writeSummaryLink(classDoc, programElementDoc);
        this.writer.printSummaryLinkComment(this, programElementDoc, tagArray);
    }
}

