/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.PatternReferenceTypeSpec;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.util.ArrayList;

abstract class EventRequestSpec {
    final ReferenceTypeSpec refSpec;
    int suspendPolicy = 2;
    EventRequest resolved = null;
    ClassPrepareRequest prepareRequest = null;

    EventRequestSpec(ReferenceTypeSpec referenceTypeSpec) {
        this.refSpec = referenceTypeSpec;
    }

    abstract EventRequest resolveEventRequest(ReferenceType var1) throws Exception;

    synchronized EventRequest resolve(ClassPrepareEvent classPrepareEvent) throws Exception {
        if (this.resolved == null && this.prepareRequest != null && this.prepareRequest.equals(classPrepareEvent.request())) {
            PatternReferenceTypeSpec patternReferenceTypeSpec;
            this.resolved = this.resolveEventRequest(classPrepareEvent.referenceType());
            this.prepareRequest.disable();
            Env.vm().eventRequestManager().deleteEventRequest(this.prepareRequest);
            this.prepareRequest = null;
            if (this.refSpec instanceof PatternReferenceTypeSpec && !(patternReferenceTypeSpec = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
                this.resolved = null;
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
            }
        }
        return this.resolved;
    }

    synchronized void remove() {
        PatternReferenceTypeSpec patternReferenceTypeSpec;
        if (this.isResolved()) {
            Env.vm().eventRequestManager().deleteEventRequest(this.resolved());
        }
        if (this.refSpec instanceof PatternReferenceTypeSpec && !(patternReferenceTypeSpec = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
            ArrayList<ExceptionRequest> arrayList = new ArrayList<ExceptionRequest>();
            for (ExceptionRequest exceptionRequest : Env.vm().eventRequestManager().exceptionRequests()) {
                if (!patternReferenceTypeSpec.matches(exceptionRequest.exception())) continue;
                arrayList.add(exceptionRequest);
            }
            Env.vm().eventRequestManager().deleteEventRequests(arrayList);
        }
    }

    private EventRequest resolveAgainstPreparedClasses() throws Exception {
        for (ReferenceType referenceType : Env.vm().allClasses()) {
            if (!referenceType.isPrepared() || !this.refSpec.matches(referenceType)) continue;
            this.resolved = this.resolveEventRequest(referenceType);
        }
        return this.resolved;
    }

    synchronized EventRequest resolveEagerly() throws Exception {
        try {
            PatternReferenceTypeSpec patternReferenceTypeSpec;
            if (this.resolved == null) {
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
                this.resolveAgainstPreparedClasses();
                if (this.resolved != null) {
                    this.prepareRequest.disable();
                    Env.vm().eventRequestManager().deleteEventRequest(this.prepareRequest);
                    this.prepareRequest = null;
                }
            }
            if (this.refSpec instanceof PatternReferenceTypeSpec && !(patternReferenceTypeSpec = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
                this.resolved = null;
                if (this.prepareRequest == null) {
                    this.prepareRequest = this.refSpec.createPrepareRequest();
                    this.prepareRequest.enable();
                }
            }
        }
        catch (VMNotConnectedException vMNotConnectedException) {
            // empty catch block
        }
        return this.resolved;
    }

    EventRequest resolved() {
        return this.resolved;
    }

    boolean isResolved() {
        return this.resolved != null;
    }

    protected boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.codePointAt(0);
        if (!Character.isJavaIdentifierStart(n)) {
            return false;
        }
        for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isJavaIdentifierPart(n)) continue;
            return false;
        }
        return true;
    }

    String errorMessageFor(Exception exception) {
        if (exception instanceof IllegalArgumentException) {
            return MessageOutput.format("Invalid command syntax");
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return MessageOutput.format("Internal error; unable to set", this.refSpec.toString());
    }
}

