/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final AugmentVisitor augmentor;
    private final Set<LintCategory> values;
    private final Set<LintCategory> suppressedValues;
    static Map<String, LintCategory> map = new HashMap<String, LintCategory>();

    public static Lint instance(Context context) {
        Lint lint = context.get(lintKey);
        if (lint == null) {
            lint = new Lint(context);
        }
        return lint;
    }

    public Lint augment(Attribute.Compound compound) {
        return this.augmentor.augment(this, compound);
    }

    public Lint augment(List<Attribute.Compound> list) {
        return this.augmentor.augment(this, list);
    }

    protected Lint(Context context) {
        Options options = Options.instance(context);
        Set set = Collections.emptySet();
        for (Map.Entry<String, LintCategory> entry : LintCategory.getMap().entrySet()) {
            if (!options.lint(entry.getKey())) continue;
            if (set.size() == 0) {
                set = new HashSet();
            }
            set.add(entry.getValue());
        }
        this.values = set;
        this.suppressedValues = Collections.emptySet();
        context.put(lintKey, this);
        this.augmentor = new AugmentVisitor(context);
    }

    protected Lint(Lint lint) {
        this.augmentor = lint.augmentor;
        this.values = new HashSet<LintCategory>(lint.values);
        this.suppressedValues = new HashSet<LintCategory>(lint.suppressedValues);
    }

    public String toString() {
        return "Lint:[values" + this.values + " suppressedValues" + this.suppressedValues + "]";
    }

    public boolean isEnabled(LintCategory lintCategory) {
        return this.values.contains((Object)lintCategory);
    }

    public boolean isSuppressed(LintCategory lintCategory) {
        return this.suppressedValues.contains((Object)lintCategory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AugmentVisitor
    implements Attribute.Visitor {
        private final Symtab syms;
        private Lint parent;
        private Lint lint;

        AugmentVisitor(Context context) {
            this.syms = Symtab.instance(context);
        }

        Lint augment(Lint lint, Attribute.Compound compound) {
            this.parent = lint;
            this.lint = null;
            compound.accept(this);
            return this.lint == null ? lint : this.lint;
        }

        Lint augment(Lint lint, List<Attribute.Compound> list) {
            this.parent = lint;
            this.lint = null;
            for (Attribute.Compound compound : list) {
                compound.accept(this);
            }
            return this.lint == null ? lint : this.lint;
        }

        private void suppress(LintCategory lintCategory) {
            if (this.lint == null) {
                this.lint = new Lint(this.parent);
            }
            this.lint.suppressedValues.add(lintCategory);
            this.lint.values.remove((Object)lintCategory);
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            LintCategory lintCategory;
            if (constant.type.tsym == this.syms.stringType.tsym && (lintCategory = LintCategory.get((String)constant.value)) != null) {
                this.suppress(lintCategory);
            }
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            if (compound.type.tsym == this.syms.suppressWarningsType.tsym) {
                List<Pair<Symbol.MethodSymbol, Attribute>> list = compound.values;
                while (list.nonEmpty()) {
                    Pair pair = (Pair)list.head;
                    if (((Symbol.MethodSymbol)pair.fst).name.toString().equals("value")) {
                        ((Attribute)pair.snd).accept(this);
                    }
                    list = list.tail;
                }
            }
        }

        @Override
        public void visitArray(Attribute.Array array) {
            for (Attribute attribute : array.values) {
                attribute.accept(this);
            }
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
        }

        @Override
        public void visitError(Attribute.Error error) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LintCategory {
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        PATH("path"),
        SERIAL("serial"),
        UNCHECKED("unchecked");

        private final String option;

        private LintCategory(String string2) {
            this.option = string2;
            map.put(string2, this);
        }

        static LintCategory get(String string) {
            return map.get(string);
        }

        static Map<String, LintCategory> getMap() {
            return map;
        }
    }
}

