/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.List;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class EditPolicyPermOKButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog listDialog;
    private ToolDialog infoDialog;
    private boolean edit;

    EditPolicyPermOKButtonListener(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, ToolDialog toolDialog2, boolean bl) {
        this.tool = policyTool;
        this.tw = toolWindow;
        this.listDialog = toolDialog;
        this.infoDialog = toolDialog2;
        this.edit = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            PolicyParser.PermissionEntry permissionEntry = this.infoDialog.getPermFromDialog();
            if (permissionEntry.permission.equals("java.io.FilePermission") && File.separatorChar == '\\') {
                permissionEntry.name = this.listDialog.addSingleBackSlash(permissionEntry.name);
            }
            try {
                this.tool.verifyPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.tool.warnings.addElement(PolicyTool.rb.getString("Warning: Class not found: ") + permissionEntry.permission);
                this.tw.displayStatusDialog(this.infoDialog, PolicyTool.rb.getString("Warning: Class not found: ") + permissionEntry.permission);
            }
            List list = (List)this.tw.getComponent(5);
            int n = list.getSelectedIndex();
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            PolicyEntry policyEntry = policyEntryArray[n];
            List list2 = (List)this.listDialog.getComponent(8);
            boolean bl = false;
            bl = this.edit ? this.tool.addPermEntry(policyEntry, permissionEntry, list2.getSelectedIndex()) : this.tool.addPermEntry(policyEntry, permissionEntry, -1);
            if (bl) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                permissionEntry.write(printWriter);
                String string = stringWriter.toString();
                if (this.edit) {
                    list2.replaceItem(string.substring(0, string.indexOf(";") + 1), list2.getSelectedIndex());
                } else {
                    list2.add(string.substring(0, string.indexOf(";") + 1));
                }
            }
            this.infoDialog.dispose();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.tw.displayErrorDialog((Window)this.infoDialog, new Exception(PolicyTool.rb.getString("Invalid value for Actions")));
        }
        catch (Exception exception) {
            this.tw.displayErrorDialog((Window)this.infoDialog, exception);
        }
    }
}

