/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org._3pq.jgrapht.ext.JGraphModelAdapter;
import org._3pq.jgrapht.graph.ListenableDirectedGraph;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;

public class JGraphAdapterDemo
extends JApplet {
    private static final Color DEFAULT_BG_COLOR = Color.decode("#FAFBFF");
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private JGraphModelAdapter m_jgAdapter;

    public void init() {
        ListenableDirectedGraph listenableDirectedGraph = new ListenableDirectedGraph();
        this.m_jgAdapter = new JGraphModelAdapter(listenableDirectedGraph);
        JGraph jGraph = new JGraph((GraphModel)this.m_jgAdapter);
        this.adjustDisplaySettings(jGraph);
        this.getContentPane().add((Component)jGraph);
        this.resize(DEFAULT_SIZE);
        String string = "v1";
        String string2 = "v2";
        String string3 = "v3";
        String string4 = "v4";
        listenableDirectedGraph.addVertex(string);
        listenableDirectedGraph.addVertex(string2);
        listenableDirectedGraph.addVertex(string3);
        listenableDirectedGraph.addVertex(string4);
        listenableDirectedGraph.addEdge(string, string2);
        listenableDirectedGraph.addEdge(string2, string3);
        listenableDirectedGraph.addEdge(string3, string);
        listenableDirectedGraph.addEdge(string4, string3);
        this.positionVertexAt(string, 130, 40);
        this.positionVertexAt(string2, 60, 200);
        this.positionVertexAt(string3, 310, 230);
        this.positionVertexAt(string4, 380, 70);
    }

    public static void main(String[] stringArray) {
        JGraphAdapterDemo jGraphAdapterDemo = new JGraphAdapterDemo();
        jGraphAdapterDemo.init();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(jGraphAdapterDemo);
        jFrame.setTitle("JGraphT Adapter to JGraph Demo");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.show();
    }

    private void adjustDisplaySettings(JGraph jGraph) {
        jGraph.setPreferredSize(DEFAULT_SIZE);
        Color color = DEFAULT_BG_COLOR;
        String string = null;
        try {
            string = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            color = Color.decode(string);
        }
        jGraph.setBackground(color);
    }

    private void positionVertexAt(Object object, int n, int n2) {
        DefaultGraphCell defaultGraphCell = this.m_jgAdapter.getVertexCell(object);
        AttributeMap attributeMap = defaultGraphCell.getAttributes();
        Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, rectangle2D.getWidth(), rectangle2D.getHeight());
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)double_);
        AttributeMap attributeMap2 = new AttributeMap();
        attributeMap2.put((Object)defaultGraphCell, (Object)attributeMap);
        this.m_jgAdapter.edit((Map)attributeMap2);
    }
}

