/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.EdgeFactory;
import org._3pq.jgrapht.Graph;

public abstract class AbstractGraph
implements Graph {
    public boolean addAllEdges(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.addEdge((Edge)iterator.next());
        }
        return bl;
    }

    public boolean addAllVertices(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.addVertex(iterator.next());
        }
        return bl;
    }

    public boolean containsEdge(Object object, Object object2) {
        return this.getEdge(object, object2) != null;
    }

    public boolean removeAllEdges(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.removeEdge((Edge)iterator.next());
        }
        return bl;
    }

    public List removeAllEdges(Object object, Object object2) {
        List list = this.getAllEdges(object, object2);
        this.removeAllEdges(list);
        return list;
    }

    public boolean removeAllVertices(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.removeVertex(iterator.next());
        }
        return bl;
    }

    protected boolean assertVertexExist(Object object) {
        if (this.containsVertex(object)) {
            return true;
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("no such vertex in graph");
    }

    protected boolean removeAllEdges(Edge[] edgeArray) {
        boolean bl = false;
        int n = 0;
        while (n < edgeArray.length) {
            bl |= this.removeEdge(edgeArray[n]);
            ++n;
        }
        return bl;
    }

    protected String toStringFromSets(Collection collection, Collection collection2) {
        return "(" + collection.toString() + ", " + collection2.toString() + ")";
    }

    public abstract Set vertexSet();

    public abstract boolean removeVertex(Object var1);

    public abstract boolean removeEdge(Edge var1);

    public abstract Edge removeEdge(Object var1, Object var2);

    public abstract List edgesOf(Object var1);

    public abstract Set edgeSet();

    public abstract boolean containsVertex(Object var1);

    public abstract boolean containsEdge(Edge var1);

    public abstract boolean addVertex(Object var1);

    public abstract boolean addEdge(Edge var1);

    public abstract Edge addEdge(Object var1, Object var2);

    public abstract EdgeFactory getEdgeFactory();

    public abstract Edge getEdge(Object var1, Object var2);

    public abstract List getAllEdges(Object var1, Object var2);
}

