/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid;

import java.util.Properties;

public class GridConfig
implements Cloneable {
    public static final int DEFAULT_CLIENT_PORT = 10101;
    public static final int DEFAULT_WORKER_PORT = 10102;
    public static final int DEFAULT_ADMIN_PORT = 10103;
    private String serverAddress;
    private int serverClientPort;
    private int serverWorkerPort;
    private int serverAdminPort;
    private boolean useSecureConnection;
    private boolean useCompression;
    private boolean useVFS;
    private String serverPassword;

    public GridConfig(Properties prop) {
        this.serverAddress = prop.getProperty("grid.server.hostname", "localhost");
        this.serverClientPort = Integer.parseInt(prop.getProperty("grid.server.client.port", Integer.toString(10101)));
        this.serverWorkerPort = Integer.parseInt(prop.getProperty("grid.server.worker.port", Integer.toString(10102)));
        this.serverAdminPort = Integer.parseInt(prop.getProperty("grid.server.admin.port", Integer.toString(10103)));
        this.useSecureConnection = Boolean.valueOf(prop.getProperty("grid.server.useencryption", Boolean.toString(false)));
        this.useCompression = Boolean.valueOf(prop.getProperty("grid.server.usecompression", Boolean.toString(false)));
        this.useVFS = Boolean.valueOf(prop.getProperty("grid.server.usevfs", Boolean.toString(true)));
    }

    public GridConfig() {
        this.serverAddress = "localhost";
        this.serverClientPort = 10101;
        this.serverWorkerPort = 10102;
        this.serverAdminPort = 10103;
        this.useSecureConnection = false;
        this.useCompression = false;
        this.useVFS = true;
    }

    public Object clone() {
        try {
            GridConfig cfg = (GridConfig)super.clone();
            cfg.serverAddress = this.serverAddress;
            cfg.serverClientPort = this.serverClientPort;
            cfg.serverWorkerPort = this.serverWorkerPort;
            cfg.serverAdminPort = this.serverAdminPort;
            cfg.useSecureConnection = this.useSecureConnection;
            cfg.useCompression = this.useCompression;
            cfg.serverPassword = this.serverPassword;
            cfg.useVFS = this.useVFS;
            return cfg;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public Properties toProperties() {
        Properties prop = new Properties();
        prop.put("grid.server.hostname", this.serverAddress);
        prop.put("grid.server.client.port", Integer.toString(this.serverClientPort));
        prop.put("grid.server.worker.port", Integer.toString(this.serverWorkerPort));
        prop.put("grid.server.admin.port", Integer.toString(this.serverAdminPort));
        prop.put("grid.server.useencryption", Boolean.toString(this.useSecureConnection));
        prop.put("grid.server.usecompression", Boolean.toString(this.useCompression));
        prop.put("grid.server.usevfs", Boolean.toString(this.useVFS));
        return prop;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String server) {
        this.serverAddress = server;
    }

    public int getServerClientPort() {
        return this.serverClientPort;
    }

    public void setServerClientPort(int port) {
        this.serverClientPort = port;
    }

    public int getServerWorkerPort() {
        return this.serverWorkerPort;
    }

    public void setServerWorkerPort(int port) {
        this.serverWorkerPort = port;
    }

    public int getServerAdminPort() {
        return this.serverAdminPort;
    }

    public void setServerAdminPort(int port) {
        this.serverAdminPort = port;
    }

    public String getServerPassword() {
        return this.serverPassword;
    }

    public void setServerPassword(String pwd) {
        this.serverPassword = pwd;
    }

    public boolean getUseSecureConnection() {
        return this.useSecureConnection;
    }

    public void setUseSecureConnection(boolean use) {
        this.useSecureConnection = use;
    }

    public boolean getUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean use) {
        this.useCompression = use;
    }

    public boolean getUseVFS() {
        return this.useVFS;
    }

    public void setUseVFS(boolean use) {
        this.useVFS = use;
    }
}

