/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.client;

import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNodeGeneric;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.vfs.vfsSession;

public class GridClient
extends GridNodeGeneric {
    private static final String className = GridClient.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private vfsSession session;

    public GridClient() {
        super(new GridNodeClientConfig());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start GridClient()");
        }
        this.session = null;
        super.getNodeConfig().setWorkingDir(System.getProperty("user.dir"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridClient()");
        }
    }

    public void send(GridMessage msg) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start send(" + msg + ")"));
        }
        super.getGridMessageChannel().send(msg);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End send()");
        }
    }

    public GridMessage recv(int timeoutMillis) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start recv()");
        }
        GridMessage msg = super.getGridMessageChannel().recv();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End recv(" + msg + ")"));
        }
        return msg;
    }

    public void start() throws Exception {
        if (log.isDebugEnabled()) {
            logDetail.debug((Object)"Start start()");
        }
        super.start();
        if (this.getNodeConfig().getGridConfig().getUseVFS()) {
            this.session = new vfsSession(super.getNodeConfig().getWorkingDir());
            this.session.start();
            log.warn((Object)("VFS session size: " + this.session.getSize() / 0x100000L + "MB"));
            this.session.syncVFSSession(super.getGridMessageChannel());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End start()");
        }
    }
}

