/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.homedns.dade.jcgrid.GridConfig;
import org.homedns.dade.jcgrid.GridNodeConfig;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;
import org.homedns.dade.jcgrid.worker.GridNodeWorkerConfig;

public class MainCmd {
    public static void setUpLog4J(String name, boolean consoleOutput) throws Exception {
        String log4jCfgFileName = System.getProperty("user.dir") + File.separator + "log4j.cfg";
        File log4jCfgFile = new File(log4jCfgFileName);
        if (log4jCfgFile.exists()) {
            PropertyConfigurator.configureAndWatch((String)log4jCfgFileName, (long)15000L);
        } else {
            BasicConfigurator.configure();
            Logger.getLogger((String)"org.homedns.dade.jcgrid").setLevel(Level.WARN);
            Logger.getLogger((String)"DETAIL.org.homedns.dade.jcgrid").setLevel(Level.WARN);
            Logger.getRootLogger().removeAllAppenders();
            RollingFileAppender app = new RollingFileAppender((Layout)new PatternLayout("%-4r %d [%t] %-5p %x %m%n"), "jcgrid-" + name + ".log", true);
            Logger.getRootLogger().addAppender((Appender)app);
            if (consoleOutput) {
                ConsoleAppender capp = new ConsoleAppender((Layout)new PatternLayout("%-4r %d [%t] %-5p %x %m%n"));
                Logger.getRootLogger().addAppender((Appender)capp);
            }
        }
    }

    public static CommandLine parseCommonOptions(Options options, GridNodeConfig nodeConfig, String[] args) throws Exception {
        options.addOption("s", true, "set server address");
        options.addOption("p", true, "set server client communication port");
        options.addOption("k", true, "set server woker communication port");
        options.addOption("a", true, "set server admin. communication port");
        options.addOption("w", true, "set server password");
        options.addOption("d", true, "set working directory");
        options.addOption("e", false, "enable secure connection");
        options.addOption("z", false, "enable compressed connection");
        if ("WORKER".equals(nodeConfig.getType())) {
            options.addOption("c", true, "set the number of workers to run");
        }
        if ("WORKER".equals(nodeConfig.getType()) || "CLIENT".equals(nodeConfig.getType()) || "ADMIN".equals(nodeConfig.getType())) {
            options.addOption("n", true, "set server session name");
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        GridConfig config = nodeConfig.getGridConfig();
        if (cmd.hasOption("s")) {
            config.setServerAddress(cmd.getOptionValue("s"));
        }
        if (cmd.hasOption("p")) {
            config.setServerClientPort(Integer.parseInt(cmd.getOptionValue("p")));
        }
        if (cmd.hasOption("k")) {
            config.setServerWorkerPort(Integer.parseInt(cmd.getOptionValue("k")));
        }
        if (cmd.hasOption("a")) {
            config.setServerAdminPort(Integer.parseInt(cmd.getOptionValue("a")));
        }
        if (cmd.hasOption("w")) {
            config.setServerPassword(cmd.getOptionValue("w"));
        }
        if (cmd.hasOption("e")) {
            config.setUseSecureConnection(true);
        }
        if (cmd.hasOption("z")) {
            config.setUseCompression(true);
        }
        if (cmd.hasOption("d")) {
            nodeConfig.setWorkingDir(cmd.getOptionValue("d"));
        }
        if (cmd.hasOption("?")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("JCGrid command", options);
            System.exit(0);
        }
        if ("WORKER".equals(nodeConfig.getType())) {
            GridNodeWorkerConfig wCfg = (GridNodeWorkerConfig)nodeConfig;
            if (cmd.hasOption("c")) {
                wCfg.setWorkerCount(Integer.parseInt(cmd.getOptionValue("c")));
            }
        }
        if ("WORKER".equals(nodeConfig.getType()) || "CLIENT".equals(nodeConfig.getType()) || "ADMIN".equals(nodeConfig.getType())) {
            GridNodeGenericConfig gCfg = (GridNodeGenericConfig)nodeConfig;
            if (cmd.hasOption("n")) {
                gCfg.setSessionName(cmd.getOptionValue("n"));
            }
        }
        return cmd;
    }
}

