/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.povray;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.admin.GridNodeAdminConfig;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.cmd.povray.guiPOVRenderingPannel;
import org.homedns.dade.jcgrid.cmd.povray.guiRenderingSetting;
import org.homedns.dade.jcgrid.gui.guiJCGridAbout;
import org.homedns.dade.jcgrid.gui.guiJCGridAdminStatus;
import org.homedns.dade.jcgrid.gui.guiJCGridConfig;

public class guiJCGridClient
extends JFrame {
    private static final String className = guiJCGridClient.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private guiJCGridConfig pGridConfig;
    private guiPOVRenderingPannel pPic;
    private guiRenderingSetting pSet;
    private guiJCGridAdminStatus pServerStatus = null;
    private guiJCGridAbout pAbout = null;
    private GridNodeClientConfig clientConfig;
    private GridNodeAdminConfig adminConfig;
    private JMenuItem mAbout;
    private JMenu mAdmin;
    private JMenuBar mBar;
    private JMenuItem mExit;
    private JMenu mFile;
    private JMenuItem mLoadSettings;
    private JMenuItem mSaveAsSettings;
    private JMenuItem mSaveImageAs;
    private JSeparator mSepa1;
    private JSeparator mSepa2;
    private JSeparator mSepa3;
    private JMenuItem mStatus;

    public guiJCGridClient() {
        this.initComponents();
        this.clientConfig = new GridNodeClientConfig();
        this.adminConfig = new GridNodeAdminConfig();
        this.adminConfig.autoSessioName();
        this.adminConfig.setGridConfig(this.clientConfig.getGridConfig());
        this.pGridConfig = new guiJCGridConfig(this.clientConfig.getGridConfig(), this, false);
        this.pGridConfig.setVisible(true);
        this.pPic = new guiPOVRenderingPannel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pPic, gridBagConstraints);
        this.pSet = new guiRenderingSetting(this.clientConfig, this, false, this.pPic);
        this.pSet.setVisible(true);
    }

    private void initComponents() {
        this.mBar = new JMenuBar();
        this.mFile = new JMenu();
        this.mLoadSettings = new JMenuItem();
        this.mSaveAsSettings = new JMenuItem();
        this.mSepa1 = new JSeparator();
        this.mSaveImageAs = new JMenuItem();
        this.mSepa2 = new JSeparator();
        this.mAbout = new JMenuItem();
        this.mSepa3 = new JSeparator();
        this.mExit = new JMenuItem();
        this.mAdmin = new JMenu();
        this.mStatus = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("JCGrid POVRay Client");
        this.setDefaultCloseOperation(3);
        this.setName("fMain");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                guiJCGridClient.this.exitForm(evt);
            }
        });
        this.mFile.setText("File");
        this.mLoadSettings.setText("Load settings");
        this.mLoadSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mLoadSettingsActionPerformed(evt);
            }
        });
        this.mFile.add(this.mLoadSettings);
        this.mSaveAsSettings.setText("Save settings as...");
        this.mSaveAsSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mSaveAsSettingsActionPerformed(evt);
            }
        });
        this.mFile.add(this.mSaveAsSettings);
        this.mFile.add(this.mSepa1);
        this.mSaveImageAs.setText("Save image as...");
        this.mSaveImageAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mSaveImageAsActionPerformed(evt);
            }
        });
        this.mFile.add(this.mSaveImageAs);
        this.mFile.add(this.mSepa2);
        this.mAbout.setText("About");
        this.mAbout.setMnemonic('a');
        this.mAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mAboutActionPerformed(evt);
            }
        });
        this.mFile.add(this.mAbout);
        this.mFile.add(this.mSepa3);
        this.mExit.setText("Exit");
        this.mExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mExitActionPerformed(evt);
            }
        });
        this.mFile.add(this.mExit);
        this.mBar.add(this.mFile);
        this.mAdmin.setText("Admin.");
        this.mStatus.setText("Server status");
        this.mStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridClient.this.mStatusActionPerformed(evt);
            }
        });
        this.mAdmin.add(this.mStatus);
        this.mBar.add(this.mAdmin);
        this.setJMenuBar(this.mBar);
        this.setBounds(0, 0, 400, 300);
    }

    private void mAboutActionPerformed(ActionEvent evt) {
        if (this.pAbout == null || !this.pAbout.isVisible()) {
            this.pAbout = new guiJCGridAbout((Frame)this, false);
            this.pAbout.setVisible(true);
        }
    }

    private void mStatusActionPerformed(ActionEvent evt) {
        if (this.pServerStatus != null && this.pServerStatus.isVisible()) {
            this.pServerStatus.refreshInfo(this.adminConfig);
        } else {
            try {
                this.pServerStatus = new guiJCGridAdminStatus(this.adminConfig, this, false);
                this.pServerStatus.setVisible(true);
            }
            catch (Exception ex) {
                log.warn((Object)"Error while opening the Admin. Status dialog", (Throwable)ex);
                JOptionPane.showMessageDialog(this, "Error while opening the Admin. Status dialog", "Admin error", 0);
            }
        }
    }

    private void mSaveImageAsActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int res = chooser.showSaveDialog(this);
        if (res == 0) {
            this.pPic.saveImage(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void mLoadSettingsActionPerformed(ActionEvent evt) {
        GridNodeClientConfig cfg;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int res = chooser.showOpenDialog(this);
        if (res == 0 && (cfg = this.pSet.loadSettings(chooser.getSelectedFile().getAbsolutePath())) != null) {
            this.clientConfig = cfg;
            this.adminConfig.setGridConfig(this.clientConfig.getGridConfig());
            this.pGridConfig.refreshConfig(this.clientConfig.getGridConfig());
        }
    }

    private void mSaveAsSettingsActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int res = chooser.showSaveDialog(this);
        if (res == 0) {
            this.pSet.saveSettings(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void mExitActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            MainCmd.setUpLog4J("gui-client", false);
            new guiJCGridClient().setVisible(true);
        }
        catch (Exception ex) {
            log.warn((Object)"Error", (Throwable)ex);
            System.exit(0);
        }
    }
}

