/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class guiRenderingPannel
extends JPanel {
    private static final String className = guiRenderingPannel.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private BufferedImage bImage;
    private Graphics2D graph;
    private boolean enableCursor;
    private int cursorX;
    private int cursorY;

    public guiRenderingPannel() {
        this.initComponents();
        this.enableCursor = false;
        this.cursorX = 0;
        this.cursorY = 0;
    }

    public synchronized void setCursorEnable(boolean v) {
        this.enableCursor = v;
    }

    public double getCursorX() {
        return (double)this.cursorX / (double)this.getWidth();
    }

    public double getCursorY() {
        return 1.0 - (double)this.cursorY / (double)this.getHeight();
    }

    public synchronized void initImage() {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (w <= 0 || h <= 0) {
            this.bImage = null;
            this.graph = null;
            return;
        }
        this.bImage = new BufferedImage(w, h, 5);
        this.graph = this.bImage.createGraphics();
        this.clearImage();
    }

    public Graphics2D getGraphics2D() {
        return this.graph;
    }

    public synchronized void saveImage(String imgName) {
        int idx = imgName.lastIndexOf(46);
        if (idx == -1) {
            JOptionPane.showMessageDialog(this, "Missing image file extension", "IO error", 0);
        } else {
            String outputFormat = imgName.substring(idx + 1);
            String[] formats = ImageIO.getWriterFormatNames();
            boolean found = false;
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equals(outputFormat)) continue;
                found = true;
                break;
            }
            if (!found) {
                JOptionPane.showMessageDialog(this, "The image format " + outputFormat + " is not supported", "IO error", 0);
            } else {
                File f = new File(imgName);
                try {
                    ImageIO.write((RenderedImage)this.bImage, outputFormat, f);
                }
                catch (Exception ex) {
                    log.warn((Object)"Error saving the image", (Throwable)ex);
                    JOptionPane.showMessageDialog(this, "Error saving the image", "IO error", 0);
                }
            }
        }
    }

    public synchronized void resizeImage(int width, int height) {
        if (width == this.bImage.getWidth() && height == this.bImage.getHeight()) {
            return;
        }
        this.bImage = new BufferedImage(width, height, 5);
        this.graph = this.bImage.createGraphics();
        this.clearImage();
    }

    public synchronized void clearImage() {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (w <= 0 || h <= 0) {
            this.bImage = null;
            this.graph = null;
            return;
        }
        for (int y = 0; y < h; y += 10) {
            for (int x = 0; x < w; x += 10) {
                if ((x / 10 + y / 10) % 2 == 0) {
                    this.graph.setColor(Color.BLACK);
                } else {
                    this.graph.setColor(Color.WHITE);
                }
                this.graph.fillRect(x, y, 10, 10);
            }
        }
        this.repaint();
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bImage == null) {
            this.initImage();
        }
        if (this.bImage != null) {
            g.drawImage(this.bImage, 0, 0, Color.BLACK, null);
        }
        if (this.enableCursor) {
            g.setColor(Color.YELLOW);
            g.setXORMode(Color.BLUE);
            g.drawLine(this.cursorX - 5, this.cursorY, this.cursorX + 5, this.cursorY);
            g.drawLine(this.cursorX, this.cursorY - 5, this.cursorX, this.cursorY + 5);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                guiRenderingPannel.this.formMouseClicked(evt);
            }
        });
    }

    private void formMouseClicked(MouseEvent evt) {
        this.cursorX = evt.getX();
        this.cursorY = evt.getY();
        this.repaint();
    }
}

