/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import java.io.IOException;
import java.net.Socket;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionBegin;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionEnd;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.homedns.dade.jcgrid.server.GridServer;
import org.homedns.dade.jcgrid.server.HandlerThread;
import org.homedns.dade.jcgrid.util.GridMessageChannel;
import org.homedns.dade.jcgrid.vfs.vfsSession;

public class ClientHandlerThread
extends HandlerThread {
    public ClientHandlerThread(GridServer server, Socket socket) throws IOException {
        super("CLIENT", server, socket);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start ClientHandlerThread(" + server + "," + socket + ")"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End ClientHandlerThread()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWorkResult(WorkResult wr) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start pushWorkResult(" + wr + ")"));
        }
        GridMessageChannel gridMessageChannel = this.handlerChannel;
        synchronized (gridMessageChannel) {
            this.handlerChannel.send(new GridMessageWorkResult(wr));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End pushWorkResult()");
        }
    }

    protected void handleMsg(GridMessage msg) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start handleMsg()");
        }
        if (msg instanceof GridMessageWorkRequest) {
            WorkRequest wr = ((GridMessageWorkRequest)msg).getWorkRequest();
            wr.setSessionName(this.sessionName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Received work request: " + wr));
            }
            this.gridServer.pushWorkRequest(wr);
        } else if (msg instanceof GridMessageVFSSessionBegin) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Received VFS session begin");
            }
            if (this.gridServer.getNodeConfig().getGridConfig().getUseVFS()) {
                vfsSession clientSession = ((GridMessageVFSSessionBegin)msg).getVFSSession();
                this.gridServer.getVFSSessionPool().syncVFSSession(this.sessionName, this.handlerChannel, clientSession);
                this.handlerChannel.send(new GridMessageVFSSessionEnd());
            } else {
                log.warn((Object)("Received VFS session begin even if VFS is disabled (session name: " + this.getSessionName() + ")"));
            }
        } else {
            log.warn((Object)("Unknown message in ClientHandlerThread.handleMsg(): " + msg));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End handleMsg()");
        }
    }

    protected void handleDisconnection() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start handleDisconnection()");
        }
        this.gridServer.removePendingWorkRequests(this.sessionName);
        if (this.gridServer.getNodeConfig().getGridConfig().getUseVFS()) {
            this.gridServer.getVFSSessionPool().unlockVFSSession(this.sessionName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End handleDisconnection()");
        }
    }
}

