/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import java.util.Properties;
import org.homedns.dade.jcgrid.GridNodeConfig;

public class GridNodeServerConfig
extends GridNodeConfig
implements Cloneable {
    public static final int NETWORK_TIMEOUT = 30000;
    private int maxConnections;
    private long maxCacheSize;

    public GridNodeServerConfig(Properties prop) {
        super(prop);
        this.maxConnections = Integer.parseInt(prop.getProperty("grid.server.maxconnections", "32"));
        this.maxCacheSize = Long.parseLong(prop.getProperty("grid.server.cache.size", Long.toString(0x4000000L)));
    }

    public GridNodeServerConfig() {
        super("SERVER");
        this.maxConnections = 32;
        this.maxCacheSize = 0x4000000L;
    }

    public Object clone() {
        GridNodeServerConfig cfg = (GridNodeServerConfig)super.clone();
        cfg.maxConnections = this.maxConnections;
        cfg.maxCacheSize = this.maxCacheSize;
        return cfg;
    }

    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.put("grid.server.maxconnections", Integer.toString(this.maxConnections));
        prop.put("grid.server.cache.size", Long.toString(this.maxCacheSize));
        return prop;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int serverMaxConnections) {
        this.maxConnections = serverMaxConnections;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(long serverMaxCacheSize) {
        this.maxCacheSize = serverMaxCacheSize;
    }
}

