/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessageBeginSession;
import org.homedns.dade.jcgrid.message.GridMessageEndSession;
import org.homedns.dade.jcgrid.message.GridMessagePing;
import org.homedns.dade.jcgrid.message.GridMessagePingAck;
import org.homedns.dade.jcgrid.server.GridServer;
import org.homedns.dade.jcgrid.server.HandlerThreads;
import org.homedns.dade.jcgrid.util.GridMessageChannel;
import org.homedns.dade.jcgrid.util.GridMessageFlatChannel;
import org.homedns.dade.jcgrid.util.GridMessageGZIPChannel;

public abstract class HandlerThread
extends Thread {
    protected static final String className = HandlerThread.class.getName();
    protected static Logger log = Logger.getLogger((String)className);
    protected static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    protected String handlerType;
    protected GridServer gridServer;
    protected Socket handlerSocket;
    protected GridMessageChannel handlerChannel;
    protected String sessionName;

    public HandlerThread(String type, GridServer server, Socket socket) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start HandlerThread(" + type + "," + server + "," + socket + ")"));
        }
        this.handlerType = type;
        this.gridServer = server;
        this.handlerSocket = socket;
        this.handlerChannel = this.gridServer.getNodeConfig().getGridConfig().getUseCompression() ? new GridMessageGZIPChannel(socket) : new GridMessageFlatChannel(socket, true);
        this.sessionName = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End HandlerThread()");
        }
    }

    public String getSessionName() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getSessionName()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getSessionName(" + this.sessionName + ")"));
        }
        return this.sessionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start run()");
        }
        NDC.push((String)("[" + this.handlerType + "]"));
        try {
            HandlerThreads hts;
            GridMessageBeginSession gmb = (GridMessageBeginSession)this.handlerChannel.recv();
            this.sessionName = gmb.getSessionName();
            NDC.pop();
            NDC.push((String)("[" + this.handlerType + "-" + this.sessionName + "]"));
            String pwd = this.gridServer.getNodeConfig().getGridConfig().getServerPassword();
            if (pwd != null && !pwd.equals(gmb.getServerPassword())) {
                throw new Exception("Login failed for " + this.sessionName);
            }
            log.warn((Object)("New session: " + this.sessionName + " [" + this.handlerSocket.getLocalAddress().getHostAddress() + ":" + this.handlerSocket.getLocalPort() + "]"));
            if (!this.sessionName.matches("[a-zA-Z0-9_]+")) {
                throw new Exception("Invalid session name: " + this.sessionName);
            }
            if (this.handlerType.equals("CLIENT")) {
                hts = this.gridServer.getClientHandlers();
            } else if (this.handlerType.equals("WORKER")) {
                hts = this.gridServer.getWorkerHandlers();
            } else if (this.handlerType.equals("ADMIN")) {
                hts = this.gridServer.getAdminHandlers();
            } else {
                throw new Exception("Unknown handler type: " + this.handlerType);
            }
            if (hts.doesHandlerSessionExists(this.sessionName, this)) {
                throw new Exception("Session name already in use: " + this.sessionName);
            }
            hts.addConnectedHandler(this);
            try {
                this.handleConnection();
            }
            finally {
                log.warn((Object)("End session: " + this.sessionName));
                hts.removeConnectedHandler(this);
            }
        }
        catch (SocketException sex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Socket Exception", (Throwable)sex);
            }
        }
        catch (EOFException eofex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Socket EOF");
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error in HandlerThread.run()", (Throwable)ex);
        }
        finally {
            try {
                this.handleDisconnection();
            }
            catch (Exception ex) {
                log.warn((Object)("Failed disconnection of session " + this.getSessionName()), (Throwable)ex);
            }
            try {
                this.handlerChannel.close();
            }
            catch (Exception ex) {}
        }
        NDC.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"End run()");
        }
    }

    protected void handleConnection() throws Exception {
        while (true) {
            GridMessage msg = this.handlerChannel.recv();
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Received grid message: " + msg));
            }
            if (msg instanceof GridMessagePing) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Received ping request");
                }
                this.handlerChannel.send(new GridMessagePingAck());
                continue;
            }
            if (msg instanceof GridMessageEndSession) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"  Received end session request");
                break;
            }
            this.handleMsg(msg);
        }
    }

    protected void handleMsg(GridMessage msg) throws Exception {
        log.warn((Object)("Unknown message in HandlerThread.handleMsg(): " + msg));
    }

    protected void handleDisconnection() throws Exception {
    }
}

