/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.WorkerStats;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessagePing;
import org.homedns.dade.jcgrid.message.GridMessagePingAck;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.homedns.dade.jcgrid.server.GridServer;
import org.homedns.dade.jcgrid.server.HandlerThread;
import org.homedns.dade.jcgrid.vfs.vfsSession;

public class WorkerHandlerThread
extends HandlerThread {
    private WorkerStats workerStats;

    public WorkerHandlerThread(GridServer server, Socket socket) throws IOException {
        super("WORKER", server, socket);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start WorkerHandlerThread(" + server + "," + socket + ")"));
        }
        this.workerStats = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End WorkerHandlerThread()");
        }
    }

    public WorkerStats getStats() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getStats()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getStats(" + this.workerStats + ")"));
        }
        return this.workerStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleConnection() throws Exception {
        block14: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start handleConnection()");
            }
            this.workerStats = new WorkerStats(this.getSessionName());
            try {
                while (true) {
                    WorkRequest wr;
                    if ((wr = this.gridServer.popWorkRequest(60000L)) == null) {
                        GridMessage msg;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"  Sending Ping...");
                        }
                        this.handlerChannel.send(new GridMessagePing());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"  Waiting PingAck...");
                        }
                        if ((msg = this.handlerChannel.recv(30000)) != null && msg instanceof GridMessagePingAck) continue;
                        break;
                    }
                    WorkResult wres = null;
                    try {
                        String sessionName = wr.getSessionName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("  Received work request: " + wr));
                        }
                        this.workerStats.workBegin(sessionName);
                        this.handlerChannel.send(new GridMessageWorkRequest(wr));
                        if (this.gridServer.getNodeConfig().getGridConfig().getUseVFS()) {
                            vfsSession session = this.gridServer.getVFSSessionPool().getVFSSession(sessionName);
                            session.syncVFSSession(this.handlerChannel);
                        }
                        GridMessageWorkResult gmwr = (GridMessageWorkResult)this.handlerChannel.recv();
                        wres = gmwr.getWorkResult();
                        wres.setSessionName(sessionName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("  Received work result: " + wres));
                        }
                        this.workerStats.workEnd(wres);
                        if (wres == null) {
                            this.gridServer.pushWorkRequest(wr);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (wres == null) {
                            this.gridServer.pushWorkRequest(wr);
                            throw throwable;
                        }
                        this.gridServer.pushWorkResult(wres);
                        throw throwable;
                    }
                    this.gridServer.pushWorkResult(wres);
                }
            }
            catch (EOFException eofex) {
                if (!log.isDebugEnabled()) break block14;
                log.debug((Object)"  Socket EOF");
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"End handleConnection()");
    }
}

