/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.vfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionFileRequest;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionFileResult;
import org.homedns.dade.jcgrid.util.GridMessageChannel;
import org.homedns.dade.jcgrid.vfs.vfsSession;

public class vfsSessionPool {
    private static final String className = vfsSessionPool.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private String path;
    private Hashtable sessionList;
    private long size;
    private long maxSize;

    public vfsSessionPool(String dir, long s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start vfsSessionPool(" + dir + "," + s + ")"));
        }
        this.path = dir;
        File pathDir = new File(this.path);
        if (!pathDir.exists()) {
            pathDir.mkdirs();
        }
        this.sessionList = null;
        this.maxSize = s;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End vfsSessionPool()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean garbageCollect() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start garbageCollect()");
        }
        boolean res = false;
        Hashtable hashtable = this.sessionList;
        synchronized (hashtable) {
            Iterator i = this.sessionList.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                vfsSession s = (vfsSession)this.sessionList.get(name);
                if (s.getInUse()) continue;
                log.warn((Object)("VFS removing unused session: " + name));
                this.size -= s.getSize();
                s.delete();
                this.sessionList.remove(name);
                String dir = this.path + File.separator + name;
                File f = new File(dir);
                f.delete();
                res = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End garbageCollect(" + res + ")"));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncVFSSession(String name, GridMessageChannel clientChannel, vfsSession clientSession) throws Exception {
        vfsSession cacheSession;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start syncVFSSession(" + name + "," + clientChannel + "," + clientSession + ")"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Cache size: " + this.size / 0x100000L + "/" + this.maxSize / 0x100000L + "MB"));
        }
        if (this.maxSize < clientSession.getSize()) {
            throw new Exception("Cache too small: " + this.maxSize + "<" + clientSession.getSize());
        }
        if (this.maxSize < this.size + clientSession.getSize()) {
            while (this.garbageCollect()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Cache size: " + this.size));
                }
                if (this.maxSize <= this.size + clientSession.getSize()) continue;
            }
            if (this.maxSize < this.size + clientSession.getSize()) {
                throw new Exception("Not enough cache free space: " + this.maxSize + "<" + this.size + "+" + clientSession.getSize());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Cache size: " + this.size / 0x100000L + "/" + this.maxSize / 0x100000L + "MB"));
        }
        if ((cacheSession = this.lockVFSSession(name)) == null) {
            cacheSession = this.newVFSSession(name);
        }
        Vector toDelete = cacheSession.notIncludedNodes(clientSession);
        Iterator i = toDelete.iterator();
        while (i.hasNext()) {
            String nodeName = (String)i.next();
            String fileName = this.path + File.separator + name + nodeName;
            log.warn((Object)("VFS deleting: " + fileName));
            Hashtable hashtable = this.sessionList;
            synchronized (hashtable) {
                this.size -= cacheSession.getNode(nodeName).getSize();
            }
            cacheSession.removeNode(nodeName);
        }
        cacheSession.deleteEmptyDirectories();
        Vector toUpdate = clientSession.notIncludedNodes(cacheSession);
        Iterator i2 = toUpdate.iterator();
        while (i2.hasNext()) {
            String nodeName = (String)i2.next();
            String fileName = this.path + File.separator + name + nodeName;
            log.warn((Object)("VFS updating: " + fileName));
            clientChannel.send(new GridMessageVFSSessionFileRequest(nodeName));
            GridMessageVFSSessionFileResult gmf = (GridMessageVFSSessionFileResult)clientChannel.recv();
            File f = new File(fileName);
            String fparent = f.getParent();
            if (fparent != null) {
                f = new File(fparent);
                f.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            fos.write(gmf.getData());
            fos.close();
            cacheSession.addNode(nodeName);
            Hashtable hashtable = this.sessionList;
            synchronized (hashtable) {
                this.size += cacheSession.getNode(nodeName).getSize();
            }
        }
        log.warn((Object)("VFS session cache size: " + this.size / 0x100000L + "/" + this.maxSize / 0x100000L + "MB"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"End syncVFSSession()");
        }
    }

    public void start() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start start()");
        }
        this.sessionList = new Hashtable();
        log.warn((Object)("VFS session pool on path: " + this.path));
        File f = new File(this.path);
        String[] l = f.list();
        for (int i = 0; i < l.length; ++i) {
            String p = f.getAbsolutePath() + File.separator + l[i];
            log.warn((Object)("VFS session pool scanning: " + p));
            File s = new File(p);
            if (s.isDirectory()) {
                vfsSession vfss = new vfsSession(p);
                vfss.start();
                String name = l[i];
                this.sessionList.put(name, vfss);
                this.size += vfss.getSize();
                continue;
            }
            log.warn((Object)("    VFS " + l[i] + " is not a directory"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public vfsSession newVFSSession(String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start newVFSSesssion(" + name + ")"));
        }
        String dir = this.path + File.separator + name;
        File f = new File(dir);
        f.mkdir();
        vfsSession s = new vfsSession(dir);
        s.start();
        s.setInUse(true);
        Hashtable hashtable = this.sessionList;
        synchronized (hashtable) {
            this.sessionList.put(name, s);
            this.size += s.getSize();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End newVFSSesssion(" + s + ")"));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public vfsSession lockVFSSession(String name) {
        vfsSession s;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start lockVFSSession(" + name + ")"));
        }
        Hashtable hashtable = this.sessionList;
        synchronized (hashtable) {
            s = (vfsSession)this.sessionList.get(name);
            if (s != null) {
                s.setInUse(true);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End lockVFSSession(" + s + ")"));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockVFSSession(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start unlockVFSSession(" + name + ")"));
        }
        Hashtable hashtable = this.sessionList;
        synchronized (hashtable) {
            vfsSession s = (vfsSession)this.sessionList.get(name);
            if (s != null) {
                s.setInUse(false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End unlockVFSSession()");
        }
    }

    public vfsSession getVFSSession(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start getVFSSession(" + name + ")"));
        }
        vfsSession s = (vfsSession)this.sessionList.get(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End getVFSSession(" + s + ")"));
        }
        return s;
    }

    public String getPath() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getPath()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getPath(" + this.path + ")"));
        }
        return this.path;
    }

    public long getSize() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getSize()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getSize(" + this.size + ")"));
        }
        return this.size;
    }

    public long getMaxSize() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getMaxSize()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getMaxSize(" + this.maxSize + ")"));
        }
        return this.maxSize;
    }

    public void setMaxSize(long s) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start setMaxSize()");
        }
        this.maxSize = s;
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setMaxSize()");
        }
    }
}

