/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.povray;

import java.util.Arrays;
import org.homedns.dade.jcgrid.client.GridClient;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingClientFeedback;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingFrame;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkResult;

public class POVRenderingClient
extends Thread {
    private GridNodeClientConfig clientCfg;
    private POVRenderingClientFeedback clientFeedback;
    private POVWorkRequest povWReq;
    private int fragSize;
    private boolean hasAnimation;
    private int startFrame;
    private int endFrame;
    private POVRenderingFrame[] frames;

    public POVRenderingClient(GridNodeClientConfig cfg, POVRenderingClientFeedback feedback, POVWorkRequest req, int frag) {
        this.clientCfg = cfg;
        this.clientFeedback = feedback;
        this.povWReq = req;
        this.fragSize = frag;
        this.hasAnimation = false;
        this.frames = new POVRenderingFrame[1];
        this.frames[0] = null;
    }

    public POVRenderingClient(GridNodeClientConfig cfg, POVRenderingClientFeedback feedback, POVWorkRequest req, int frag, int start, int end) {
        this(cfg, feedback, req, frag);
        this.hasAnimation = true;
        this.startFrame = start;
        this.endFrame = end;
        this.frames = new POVRenderingFrame[this.endFrame - this.startFrame + 1];
        Arrays.fill(this.frames, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            GridClient gc = new GridClient();
            gc.setNodeConfig(this.clientCfg);
            gc.start();
            long t1 = System.currentTimeMillis();
            try {
                int i;
                int xStep = this.fragSize;
                int yStep = (int)((double)(this.fragSize * this.povWReq.getHeight()) / (double)this.povWReq.getWidth());
                POVWorkRequest[] workList = this.hasAnimation ? this.povWReq.split(this.startFrame, this.endFrame, xStep, yStep) : this.povWReq.split(xStep, yStep);
                int fragCount = this.povWReq.fragmentPerFrame(xStep, yStep);
                this.clientFeedback.setProgressMaximum(0);
                this.clientFeedback.setProgressMaximum(2 * workList.length - 1);
                this.clientFeedback.renderingBegin();
                for (i = 0; i < workList.length; ++i) {
                    this.clientFeedback.setProgressValue(i);
                    this.clientFeedback.sendingFrgamentRequest(workList[i]);
                    gc.send(new GridMessageWorkRequest(workList[i]));
                    if (this.isInterrupted()) break;
                }
                for (i = 0; i < workList.length; ++i) {
                    this.clientFeedback.setProgressValue(i + workList.length);
                    GridMessageWorkResult gmwr = (GridMessageWorkResult)gc.recv(0);
                    POVWorkResult povWRes = (POVWorkResult)gmwr.getWorkResult();
                    int idx = povWRes.getRID() - 1;
                    int frameIdx = workList[idx].getFrame() - this.startFrame;
                    if (this.frames[frameIdx] == null) {
                        this.frames[frameIdx] = new POVRenderingFrame(workList[idx].getWidth(), workList[idx].getHeight(), fragCount);
                    }
                    this.frames[frameIdx].addFragmentResult(workList[idx], povWRes);
                    this.clientFeedback.receivedFragmentResult(workList[idx], povWRes, workList[idx].getFrame(), this.frames[frameIdx]);
                    if (this.frames[frameIdx].isComplete()) {
                        this.clientFeedback.completeFrame(workList[idx].getFrame(), this.frames[frameIdx]);
                        this.frames[frameIdx] = null;
                    }
                    if (!this.isInterrupted()) continue;
                    break;
                }
            }
            finally {
                long t2 = System.currentTimeMillis();
                this.clientFeedback.setRenderingTime(this.povWReq, t2 - t1);
                try {
                    gc.stop();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception ex) {
            this.clientFeedback.error("Error while doing the rendering", ex);
        }
        this.clientFeedback.renderingEnd();
    }
}

