/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.povray;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkResult;

public class POVRenderingFrame {
    private BufferedImage renderingFrameBuffer;
    private Graphics2D renderingFrameBufferG2D;
    private int fragmentTotCount;
    private int fragmentCount;

    public POVRenderingFrame(int width, int height, int count) {
        this.renderingFrameBuffer = new BufferedImage(width, height, 5);
        this.renderingFrameBufferG2D = this.renderingFrameBuffer.createGraphics();
        this.fragmentTotCount = count;
        this.fragmentCount = 0;
        for (int y = 0; y < this.renderingFrameBuffer.getHeight(); y += 10) {
            for (int x = 0; x < this.renderingFrameBuffer.getWidth(); x += 10) {
                if ((x / 10 + y / 10) % 2 == 0) {
                    this.renderingFrameBufferG2D.setColor(Color.BLACK);
                } else {
                    this.renderingFrameBufferG2D.setColor(Color.WHITE);
                }
                this.renderingFrameBufferG2D.fillRect(x, y, 10, 10);
            }
        }
    }

    public BufferedImage getBufferedImage() {
        return this.renderingFrameBuffer;
    }

    public Graphics2D getGraphics2D() {
        return this.renderingFrameBufferG2D;
    }

    public void addFragmentResult(POVWorkRequest req, POVWorkResult res) {
        byte[] ppmData = res.getData();
        int ppmIdx = 0;
        int j = 0;
        while (j < 3) {
            if (ppmData[ppmIdx] == 10) {
                ++j;
            }
            ++ppmIdx;
        }
        for (int y = req.getStartRow(); y <= req.getEndRow(); ++y) {
            for (int x = 0; x < req.getWidth(); ++x) {
                int r = ppmData[ppmIdx++] & 0xFF;
                int g = ppmData[ppmIdx++] & 0xFF;
                int b = ppmData[ppmIdx++] & 0xFF;
                if (x < req.getStartCol() || x > req.getEndCol()) continue;
                this.renderingFrameBufferG2D.setColor(new Color(r, g, b));
                this.renderingFrameBufferG2D.fillRect(x, y, 1, 1);
            }
        }
        ++this.fragmentCount;
    }

    public boolean isComplete() {
        return this.fragmentCount >= this.fragmentTotCount;
    }
}

