/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.povray;

import java.io.File;
import java.io.FileInputStream;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.util.ByteVector;
import org.homedns.dade.jcgrid.util.ConsoleCmd;
import org.homedns.dade.jcgrid.worker.Worker;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkResult;

public class POVWorker
implements Worker {
    private static final String className = POVWorker.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    public static final String TEMP_IMG_FILE = "jcgrid-worker-tmp-img-file.ppm";
    private boolean usePVEngineEXE;

    public POVWorker(boolean useEXE) {
        this.usePVEngineEXE = useEXE;
    }

    public WorkResult doWork(WorkRequest work, String workDir) throws Exception {
        String[] cmdNoAnim;
        String[] cmd;
        String[] cmdAnim;
        POVWorkRequest povwr = (POVWorkRequest)work;
        String tmpFileName = workDir + File.separator + TEMP_IMG_FILE;
        if (this.usePVEngineEXE) {
            if (povwr.isAnimationEnabled()) {
                cmdAnim = new String[]{"pvengine.exe", "/exit", "/render", "-V", "-D", "+W" + povwr.getWidth(), "+H" + povwr.getHeight(), "+SC" + (povwr.getStartCol() + 1), "+EC" + (povwr.getEndCol() + 1), "+SR" + (povwr.getStartRow() + 1), "+ER" + (povwr.getEndRow() + 1), "+FP", "+O" + tmpFileName, "+SF" + povwr.getFrame(), "+EF" + povwr.getFrame(), povwr.getINIFileName()};
                cmd = cmdAnim;
            } else {
                cmd = cmdNoAnim = new String[]{"C:\\programmi\\povray-3.6\\bin\\pvengine.exe", "/exit", "/render", "-V", "-D", "+W" + povwr.getWidth(), "+H" + povwr.getHeight(), "+SC" + (povwr.getStartCol() + 1), "+EC" + (povwr.getEndCol() + 1), "+SR" + (povwr.getStartRow() + 1), "+ER" + (povwr.getEndRow() + 1), "+FP", "+O" + tmpFileName, povwr.getINIFileName()};
            }
        } else if (povwr.isAnimationEnabled()) {
            cmdAnim = new String[]{"povray", "-V", "-D", "+W" + povwr.getWidth(), "+H" + povwr.getHeight(), "+SC" + (povwr.getStartCol() + 1), "+EC" + (povwr.getEndCol() + 1), "+SR" + (povwr.getStartRow() + 1), "+ER" + (povwr.getEndRow() + 1), "+FP", "+O" + tmpFileName, "+SF" + povwr.getFrame(), "+EF" + povwr.getFrame(), povwr.getINIFileName()};
            cmd = cmdAnim;
        } else {
            cmd = cmdNoAnim = new String[]{"povray", "-V", "-D", "+W" + povwr.getWidth(), "+H" + povwr.getHeight(), "+SC" + (povwr.getStartCol() + 1), "+EC" + (povwr.getEndCol() + 1), "+SR" + (povwr.getStartRow() + 1), "+ER" + (povwr.getEndRow() + 1), "+FP", "+O" + tmpFileName, povwr.getINIFileName()};
        }
        ConsoleCmd cc = new ConsoleCmd(cmd, null, workDir);
        if (cc.run() != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Failed POVRay command execution:\n");
            sb.append("[WorkDir: \n");
            sb.append("<");
            sb.append(workDir);
            sb.append(">");
            sb.append("\n]\n[Cmd:\n");
            for (int i = 0; i < cmd.length; ++i) {
                sb.append("<");
                sb.append(cmd[i]);
                sb.append(">\n");
            }
            sb.append("]\n[stderr:\n");
            sb.append(new String(cc.getStdErr()));
            sb.append("\n]\n[stdout:\n");
            sb.append(new String(cc.getStdOut()));
            sb.append("\n]");
            log.warn((Object)sb.toString());
            throw new Exception("Failed POVRay command execution");
        }
        if (cc.getStdErr().length > 0) {
            log.warn((Object)("Stderr execution in POVWorker.doWork(): " + new String(cc.getStdErr())));
        }
        File tmpFile = new File(tmpFileName);
        FileInputStream fis = new FileInputStream(tmpFile);
        byte[] data = ByteVector.readAll(fis);
        fis.close();
        tmpFile.delete();
        POVWorkResult res = new POVWorkResult(povwr.getSessionName(), povwr.getRID(), data, (povwr.getEndCol() - povwr.getStartCol() + 1) * (povwr.getEndRow() - povwr.getStartRow() + 1));
        return res;
    }
}

