/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.serviceonscanner;

import com.zebra.jpos.jniscanner.ArgStruct;
import com.zebra.jpos.jniscanner.GetScannerArgStruct;
import com.zebra.jpos.jniscanner.JCoreScanner;
import com.zebra.jpos.jniscanner.JniXmlElement;
import com.zebra.jpos.serviceonscanner.directio.DirectIOData;
import com.zebra.jpos.serviceonscanner.directio.DirectIODeviceData;
import com.zebra.log.scanner.JCoreLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jpos.JposException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SvcDirectIO {
    public static void directIO(int n, int[] nArray, StringBuffer stringBuffer) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (nArray == null || nArray.length == 0) {
            JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, stringBuffer});
        } else {
            JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, nArray[0], stringBuffer});
        }
        ArgStruct argStruct = new ArgStruct();
        argStruct.status = 0L;
        if (n == 1) {
            GetScannerArgStruct getScannerArgStruct = new GetScannerArgStruct();
            try {
                JCoreScanner.jcoreScanner.GetScanners(getScannerArgStruct);
                stringBuffer.append(getScannerArgStruct.outXml);
                nArray[0] = (int)getScannerArgStruct.status;
            }
            catch (Exception exception) {
                JposException jposException = new JposException(106, "Direct IO error : " + exception.getMessage());
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
            if (getScannerArgStruct.scannerCount <= 0) {
                JposException jposException = new JposException(107, "No devices detected");
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
            if (getScannerArgStruct.status != 0L) {
                JposException jposException = new JposException(106, "Direct IO GetScanners failed. Error code : " + argStruct.status);
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
        } else if (n == 5000 || n == 5001 || n == 5002 || n == 5004 || n == 5005 || n == 5500 || n == 5501 || n == 5502 || n == 5503 || n == 5504 || n == 5505 || n == 5506 || n == 5200 || n == 5020 || n == 5017 || n == 5016) {
            argStruct.opcode = n;
            argStruct.inXml = stringBuffer.toString();
            try {
                JCoreScanner.jcoreScanner.ExecCommand(argStruct);
                stringBuffer.setLength(0);
                stringBuffer.append(argStruct.outXml);
                nArray[0] = (int)argStruct.status;
            }
            catch (Exception exception) {
                JposException jposException = new JposException(106, "Direct IO error : " + exception.getMessage());
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
            if (argStruct.status != 0L) {
                JposException jposException = new JposException(106, "Direct IO Command failed. Error code : " + argStruct.status);
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
        } else {
            JposException jposException = new JposException(106, "OpCode not supported over Direct IO");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    public static void directIO(int n, int[] nArray, Object object) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (nArray == null || nArray.length == 0) {
            JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, object});
        } else {
            JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, nArray[0], object});
        }
        if (object instanceof StringBuffer) {
            SvcDirectIO.directIO(n, nArray, (StringBuffer)object);
        } else {
            ArgStruct argStruct = new ArgStruct();
            argStruct.status = 0L;
            if (n == 1) {
                DirectIODeviceData directIODeviceData;
                GetScannerArgStruct getScannerArgStruct = new GetScannerArgStruct();
                if (!(object instanceof DirectIODeviceData)) {
                    JposException jposException = new JposException(106, "Incorrect parameter type, required DirectIODeviceData object");
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                    throw jposException;
                }
                try {
                    directIODeviceData = (DirectIODeviceData)object;
                    JCoreScanner.jcoreScanner.GetScanners(getScannerArgStruct);
                    directIODeviceData.outXml = getScannerArgStruct.outXml;
                    directIODeviceData.status = getScannerArgStruct.status;
                    directIODeviceData.scannerCount = getScannerArgStruct.scannerCount;
                    directIODeviceData.scannerIDs = new int[getScannerArgStruct.scannerCount];
                    for (int i = 0; i < getScannerArgStruct.scannerCount; ++i) {
                        directIODeviceData.scannerIDs[i] = getScannerArgStruct.scannerIDs[i];
                    }
                }
                catch (Exception exception) {
                    JposException jposException = new JposException(106, "Direct IO error : " + exception.getMessage());
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                    throw jposException;
                }
                if (getScannerArgStruct.scannerCount <= 0) {
                    directIODeviceData = new JposException(107, "No devices detected");
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{directIODeviceData.getMessage()});
                    throw directIODeviceData;
                }
                if (getScannerArgStruct.status != 0L) {
                    directIODeviceData = new JposException(106, "Direct IO GetScanners failed. Error code : " + argStruct.status);
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{directIODeviceData.getMessage()});
                    throw directIODeviceData;
                }
            } else if (n == 5000 || n == 5001 || n == 5002 || n == 5004 || n == 5005 || n == 5500 || n == 5501 || n == 5502 || n == 5503 || n == 5504 || n == 5505 || n == 5506 || n == 5200 || n == 5020 || n == 5017 || n == 5016) {
                DirectIOData directIOData;
                if (!(object instanceof DirectIOData)) {
                    JposException jposException = new JposException(106, "Incorrect parameter type, required DirectIOData object");
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                    throw jposException;
                }
                try {
                    directIOData = (DirectIOData)object;
                    int n2 = nArray[0];
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(JniXmlElement.ELEMENT_INARGS);
                    stringBuffer.append(JniXmlElement.ELEMENT_SCANNER_ID + n2 + JniXmlElement.ELEMENT_SCANNER_ID_E);
                    if (n != 5000) {
                        stringBuffer.append(JniXmlElement.ELEMENT_CMDARGS);
                        stringBuffer.append(JniXmlElement.ELEMENT_ARGXML);
                        stringBuffer.append(directIOData.inXML);
                        stringBuffer.append(JniXmlElement.ELEMENT_ARGXML_E);
                        stringBuffer.append(JniXmlElement.ELEMENT_CMDARGS_E);
                    }
                    stringBuffer.append(JniXmlElement.ELEMENT_INARGS_E);
                    argStruct.inXml = stringBuffer.toString();
                    argStruct.opcode = n;
                    JCoreScanner.jcoreScanner.ExecCommand(argStruct);
                    if (n == 5000 || n == 5001 || n == 5002) {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(argStruct.outXml.getBytes("UTF-8"));
                        if (!argStruct.outXml.equals("") && argStruct.outXml != null) {
                            Document document = documentBuilder.parse(byteArrayInputStream);
                            NodeList nodeList = document.getElementsByTagName("outArgs");
                            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("arg-xml");
                            NodeList nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName("response");
                            Node node = ((Element)nodeList3.item(0)).getElementsByTagName("attrib_list").item(0);
                            StringBuffer stringBuffer2 = new StringBuffer();
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            Transformer transformer = transformerFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("indent", "yes");
                            StringWriter stringWriter = new StringWriter();
                            StreamResult streamResult = new StreamResult(stringWriter);
                            DOMSource dOMSource = new DOMSource(node);
                            transformer.transform(dOMSource, streamResult);
                            stringBuffer2.append(stringWriter.toString());
                            directIOData.outXml = stringBuffer2.toString();
                            stringWriter.close();
                        } else {
                            directIOData.outXml = argStruct.outXml;
                        }
                        ((InputStream)byteArrayInputStream).close();
                    } else {
                        directIOData.outXml = argStruct.outXml;
                    }
                    directIOData.status = argStruct.status;
                }
                catch (Exception exception) {
                    JposException jposException = new JposException(106, "Direct IO error : " + exception.getMessage());
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                    throw jposException;
                }
                if (argStruct.status != 0L) {
                    directIOData = new JposException(106, "Direct IO command failed. Error code : " + argStruct.status);
                    JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{directIOData.getMessage()});
                    throw directIOData;
                }
            } else {
                JposException jposException = new JposException(106, "OpCode not supported over Direct IO");
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException.getMessage()});
                throw jposException;
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }
}

