/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image;

import java.io.IOException;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import se.prediktera.image.count.CountAnalysisClusterInfo;
import se.prediktera.image.count.CountAnalysisInfo;
import se.prediktera.image.count.CountAnalysisScriptInfo;
import se.prediktera.image.count.CountAnalysisTableInfo;
import se.prediktera.image.count.CountDataSetGroup;
import se.prediktera.image.count.algorithm.IdentifiedObjectDataClass;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.image.count.grid.GridAnalysisInfo;
import se.prediktera.image.count.shrink.ShrinkAnalysisInfo;
import se.prediktera.image.count.statistics.CountStatisticsInfo;
import se.prediktera.image.dataimport.ImageImportInfo;
import se.prediktera.image.dataimport.calibration.CalibrationAlgorithm;
import se.prediktera.image.dataimport.calibration.CalibrationAnalysisInfo;
import se.prediktera.image.dataimport.calibration.CalibrationPanelInfo;
import se.prediktera.image.dataimport.calibration.CubeClass;
import se.prediktera.image.dataimport.hips.HIPSImageImportInfo;
import se.prediktera.image.dataimport.raman.RamanImportInfo;
import se.prediktera.image.dataimport.spf.SpfDataSource;
import se.prediktera.image.dataimport.spf.SpfImageImportInfo;
import se.prediktera.image.plot.FloatWindowRgbImage;
import se.prediktera.image.plot.PlotZoneSpectral;
import se.prediktera.image.plot.RgbImageAccessorPanel;
import se.prediktera.image.plot.RgbImageLayer;
import se.prediktera.image.plot.RgbImagePlot;
import se.prediktera.image.plot.info.Contour2DPredictionInfo;
import se.prediktera.image.plot.info.DensityScoreInfo;
import se.prediktera.image.plot.info.ImageDataSetPlotInfo;
import se.prediktera.image.plot.info.ImageModelPlotInfo;
import se.prediktera.image.plot.info.RGBImagePlotInfo;
import se.prediktera.image.plot.info.ScoreContourPlotInfo;
import se.prediktera.image.plot.info.ScoreRGBImagePlotInfo;
import se.prediktera.image.plot.info.SingleYPredConcentrationPlotInfo;
import se.prediktera.image.plot.info.SingleYPredContourPlotInfo;
import se.prediktera.image.plot.info.SpectralDescInfo;
import se.prediktera.image.plot.info.YPredConcentrationPlotInfo;
import se.prediktera.image.plot.info.YPredContourPlotInfo;
import se.prediktera.image.process.ImageProcessInfo;
import se.prediktera.image.process.ImageProcessMatrix;
import se.prediktera.image.sam.SAMAnalysisInfo;
import se.prediktera.image.sam.SamPanelInfo;
import se.prediktera.image.template.ImageImportSNVScriptInfo;
import se.prediktera.image.template.ImageImportScriptInfo;
import se.prediktera.image.template.ImageModelScriptInfo;
import se.prediktera.image.template.ImagePredictionScriptInfo;
import se.prediktera.map.common.AbstractPanelInfo;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.image.hdr.HdrDataSource;
import se.prediktera.map.dataimport.image.hdr.HdrExportInfo;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.dataimport.image.hdr.HySpexImageImportInfo;
import se.prediktera.map.dataimport.image.pam.PamImportInfo;
import se.prediktera.map.dataimport.image.sac.SacDataSource;
import se.prediktera.map.dataimport.image.sac.SacImageImportInfo;
import se.prediktera.map.dataimport.image.sac.SacXMLImageImportInfo;
import se.prediktera.map.dataimport.image.sc.ScImportInfo;
import se.prediktera.map.dataimport.image.sif.SifImportInfo;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.extclass.ExtLibException;
import se.prediktera.map.main.extclass.InitInterface;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;
import se.prediktera.map.plot.layout.AbstractDescInfo;
import se.prediktera.map.plot.plotgenerator.AbstractPlotInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class InitClass
implements InitInterface {
    public static final byte SPFDATASOURCE = 0;
    public static final byte RGBIMAGEPLOT = 1;
    public static final byte RGBIMAGEPLOTWINDOW = 2;
    public static final byte RGBIMAGEPLOTLAYER = 3;
    public static final byte RGBIMAGEPLOTACCESSORPANEL = 4;
    public static final byte HDRDATASOURCE = 5;
    public static final byte PLOTZONESPECTRAL = 6;
    public static final byte HIPSDATASOURCE = 7;
    public static final byte SACDATASOURCE = 8;
    public static final byte OBJECTCOUNTER = 9;
    public static final byte SUBOJECT = 10;
    public static final byte UNITCONVERSIONALGORITHM = 11;
    public static final byte CUBECLASS = 12;
    public static final byte IMAGEPROCESSMATRIX = 13;
    public static final byte COUNTDATASETGROUP = 14;
    public static final byte PAMDATASOURCE = 15;
    private static final Integer Version = 41;
    private static final int majorVersionStart = 28;
    private static final String VersionString = "1.2";

    public static String GetVersionString() {
        return "1.2." + (Version - 28);
    }

    @Override
    public DataTreeExtLibInterface createExtLibNodeFromStream(Byte by, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException, ExtLibException {
        return switch (by) {
            case 0 -> new SpfDataSource(randomInputStream, mapProperty);
            case 1 -> new RgbImagePlot(randomInputStream, mapProperty);
            case 2 -> new FloatWindowRgbImage(randomInputStream, mapProperty);
            case 3 -> new RgbImageLayer(randomInputStream, mapProperty);
            case 4 -> new RgbImageAccessorPanel(randomInputStream, mapProperty);
            case 5 -> new HdrDataSource(randomInputStream, mapProperty);
            case 8 -> new SacDataSource(randomInputStream, mapProperty);
            case 6 -> new PlotZoneSpectral(randomInputStream, mapProperty);
            case 9 -> new IdentifiedObjectListWithSummary(randomInputStream, mapProperty);
            case 10 -> new IdentifiedObjectDataClass(randomInputStream, mapProperty);
            case 11 -> new CalibrationAlgorithm(randomInputStream, mapProperty);
            case 12 -> new CubeClass(randomInputStream, mapProperty);
            case 13 -> new ImageProcessMatrix(randomInputStream, mapProperty);
            case 14 -> new CountDataSetGroup(randomInputStream, mapProperty);
            default -> null;
        };
    }

    public AbstractAnalysisInfo[] getAnalysisInfo() {
        return new AbstractAnalysisInfo[]{new SAMAnalysisInfo(), new CalibrationAnalysisInfo(), new CountAnalysisInfo(), new CountAnalysisClusterInfo(), new ShrinkAnalysisInfo(), new GridAnalysisInfo(), new ImageProcessInfo()};
    }

    public AbstractDescInfo[] getDescInfo() {
        return new AbstractDescInfo[]{new SpectralDescInfo()};
    }

    public AbstractExportInfo[] getExportInfo() {
        return new AbstractExportInfo[]{new HdrExportInfo()};
    }

    public HelpSet getHelpSet() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)"help/Image");
        try {
            return new HelpSet(null, uRL);
        }
        catch (HelpSetException helpSetException) {
            System.out.println("Image cannot create help system with: " + String.valueOf(uRL));
            return null;
        }
    }

    @Override
    public AbstractInfo[] getInfo(Byte by) {
        return switch (by) {
            case 1 -> this.getPlotInfo();
            case 0 -> this.getTableInfo();
            case 2 -> this.getModelInfo();
            case 3 -> this.getImportInfo();
            case 6 -> this.getExportInfo();
            case 11 -> this.getStatisticsInfo();
            case 14 -> this.getScriptInfo();
            case 15 -> this.getPanelInfo();
            case 10 -> this.getDescInfo();
            case 16 -> this.getAnalysisInfo();
            default -> null;
        };
    }

    public AbstractModelInfo[] getModelInfo() {
        return new AbstractModelInfo[0];
    }

    @Override
    public String getName() {
        return "Image";
    }

    public AbstractPanelInfo[] getPanelInfo() {
        return new AbstractPanelInfo[]{new SamPanelInfo(), new CalibrationPanelInfo()};
    }

    public AbstractPlotInfo[] getPlotInfo() {
        return new AbstractPlotInfo[]{new ImageModelPlotInfo(), new ImageDataSetPlotInfo(), new RGBImagePlotInfo(), new DensityScoreInfo(), new ScoreRGBImagePlotInfo(), new ScoreContourPlotInfo(), new Contour2DPredictionInfo(), new YPredContourPlotInfo(), new YPredConcentrationPlotInfo(), new SingleYPredContourPlotInfo(), new SingleYPredConcentrationPlotInfo()};
    }

    public AbstractScriptInfo[] getScriptInfo() {
        return new AbstractScriptInfo[]{new ImageImportScriptInfo(), new ImageImportSNVScriptInfo(), new ImageModelScriptInfo(), new ImagePredictionScriptInfo(), new CountAnalysisScriptInfo()};
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    public AbstractStatisticsInfo[] getStatisticsInfo() {
        return new AbstractStatisticsInfo[]{new CountStatisticsInfo()};
    }

    public AbstractTableInfo[] getTableInfo() {
        return new AbstractTableInfo[]{new CountAnalysisTableInfo()};
    }

    @Override
    public Integer getVersion() {
        return Version;
    }

    @Override
    public String getVersionString() {
        return InitClass.GetVersionString();
    }

    @Override
    public void Init() {
    }

    private AbstractImportInfo[] getImportInfo() {
        if (RegisterKeyManager.isPredikteraLicense()) {
            return new AbstractImportInfo[]{new ImageImportInfo(), new SpfImageImportInfo(), new HdrImageImportInfo(), new HIPSImageImportInfo(), new SacImageImportInfo(), new RamanImportInfo(), new SacXMLImageImportInfo(), new HySpexImageImportInfo(), new PamImportInfo(), new ScImportInfo(), new SifImportInfo()};
        }
        return new AbstractImportInfo[]{new ImageImportInfo(), new SpfImageImportInfo(), new HdrImageImportInfo(), new HIPSImageImportInfo(), new SacImageImportInfo(), new SacXMLImageImportInfo(), new RamanImportInfo(), new HySpexImageImportInfo(), new PamImportInfo(), new ScImportInfo(), new SifImportInfo()};
    }
}

