/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.util.Properties;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import se.prediktera.image.count.CountDataSetGroup;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.image.count.algorithm.ObjectIdentificationAlgorithm;
import se.prediktera.image.count.plot.CountAnalysisContourPlot;
import se.prediktera.image.count.plot.CountAnalysisHistogramPlot;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.register.RegisterKeyManager;

public class CountAnalysisPanel
extends WizardPageClass {
    private JDialog dialog = null;
    private Project_GUI project_GUI;
    private DataTreeInterface dti;
    private CountAnalysisContourPlot contourPlot;
    private CountAnalysisHistogramPlot histogramPlot;
    private double[] minmax;
    private JPanel advancePanel;
    private JLabel areaUnitLabel;
    private JTextFieldButtonUppDown areaUnitRatioTextField;
    private JCheckBox blobCheckBox;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JComboBoxCell classComboBox;
    private JLabel classLabel;
    private JPanel classPanel;
    private JButton createButton;
    private JTabbedPane createTabbedPane;
    private JPanel graphPanel;
    private JPanel histogramPanel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextFieldButtonUppDown maxThresTextField;
    private JLabel maxThresholdLabel;
    private JLabel minAreaLabel;
    private JTextFieldButtonUppDown minAreaTextField;
    private JTextFieldButtonUppDown minThresTextField;
    private JLabel minThresholdLabel;
    private JPanel normalPanel;
    private JPanel optionPanel;
    private JPanel propertiesPanel;
    private JTextPane propertiesTextPane;
    private JPanel rightPanel;
    private JComboBoxCell scriptComboBox;
    private JPanel settingsPanel;
    private JComboBoxCell subClassComboBox;
    private JLabel subClassLabel;
    private JTabbedPane tabbedPane;
    private JLabel templateLabel;
    private JPanel templatePanel;
    private JPanel thresholdPanel;
    private JComboBox unitComboBox;

    public static void showDialog(Project_GUI project_GUI, DataTreeInterface dataTreeInterface) {
        JDialog jDialog = new JDialog(IniManager.getMainFrame());
        CountAnalysisPanel countAnalysisPanel = new CountAnalysisPanel(jDialog, project_GUI, dataTreeInterface);
        jDialog.setTitle("Object Identification");
        jDialog.getContentPane().add((Component)countAnalysisPanel, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public CountAnalysisPanel(JDialog jDialog, Project_GUI project_GUI, DataTreeInterface dataTreeInterface) {
        this.dialog = jDialog;
        this.project_GUI = project_GUI;
        this.dti = dataTreeInterface;
        this.initComponents();
        AbstractDataMatrix abstractDataMatrix = this.getMatrix();
        this.blobCheckBox.setSelected(false);
        if (abstractDataMatrix != null) {
            Case case_ = (Case)DataTreeManager.getAncestorNull(abstractDataMatrix, Case.class);
            if (case_ != null) {
                this.areaUnitRatioTextField.setNumber(case_.getCellArea());
                this.unitComboBox.setSelectedItem(case_.getCellUnit());
            }
            this.minmax = abstractDataMatrix.calculateMinMax();
            this.minAreaTextField.setMinMax(0.0, Double.MAX_VALUE);
            this.minAreaTextField.setNumber(0.0);
            this.minThresTextField.setMinMax(0.0, 100.0);
            this.minThresTextField.setStepSize(1.0);
            this.minThresTextField.setNumber(0.0);
            this.maxThresTextField.setMinMax(0.0, 100.0);
            this.maxThresTextField.setStepSize(1.0);
            this.maxThresTextField.setNumber(100.0);
            this.contourPlot = new CountAnalysisContourPlot(abstractDataMatrix);
            this.histogramPlot = new CountAnalysisHistogramPlot(this, abstractDataMatrix, this.minmax[0], this.minmax[1]);
        }
        this.beginWizard();
        if (this.classComboBox.getItemCount() == 0) {
            this.createTabbedPane.setSelectedIndex(0);
            this.createTabbedPane.setEnabledAt(1, false);
        }
        this.contourPlot.setPreferredSize(new Dimension(300, 300));
        this.graphPanel.add((Component)this.contourPlot, "Center");
        this.histogramPanel.add((Component)this.histogramPlot, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CountAnalysisPanel.this.radioButtonChanged();
            }
        });
        this.minThresTextField.setNumberChangedInterface((n, d) -> {
            this.radioButtonChanged();
            this.histogramPlot.setThreshold(d, this.maxThresTextField.getNumber());
        });
        this.maxThresTextField.setNumberChangedInterface((n, d) -> {
            this.radioButtonChanged();
            this.histogramPlot.setThreshold(this.minThresTextField.getNumber(), d);
        });
        if (!RegisterKeyManager.isPredikteraLicense()) {
            for (int i = 0; i < this.propertiesPanel.getComponentCount(); ++i) {
                this.propertiesPanel.getComponent(i).setVisible(false);
            }
            this.propertiesPanel.setBorder(BorderFactory.createEmptyBorder());
        }
        this.radioButtonChanged();
        CSH.setHelpIDString((Component)this, (String)"objectidentification");
    }

    public void beginWizard() {
        this.setClasses(this.getMatrix(), 0);
        ScriptManager.addScriptInfoComboBox(this.scriptComboBox, "object", null);
    }

    @Override
    public boolean canNext() {
        return super.canNext();
    }

    public void setThreshold(double d, double d2) {
        this.minThresTextField.setNumber(d);
        this.maxThresTextField.setNumber(d2);
        this.radioButtonChanged();
    }

    @Override
    protected void cleanUpChild() {
        this.dialog = null;
        this.project_GUI = null;
        this.dti = null;
    }

    private void blobCheckBoxItemStateChanged(ItemEvent itemEvent) {
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dialog.dispose();
    }

    private void classComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.subClassComboBox.removeAllItems();
            Object object = this.classComboBox.getSelectedItem();
            if (object instanceof InnerColumnClass) {
                InnerColumnClass innerColumnClass = (InnerColumnClass)object;
                this.subClassComboBox.addItem("All");
                ClassTypes classTypes = innerColumnClass.getObject();
                for (int i = 0; i < classTypes.size(); ++i) {
                    if (classTypes.getTypeDescription(i).equals("-")) continue;
                    this.subClassComboBox.addItem(classTypes.getTypeDescription(i));
                }
                this.subClassComboBox.setEnabled(this.subClassComboBox.getItemCount() > 1);
            }
            this.classComboBox.setEnabled(this.classComboBox.getItemCount() > 1);
        }
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

            @Override
            public Object doWork() {
                try {
                    Object object;
                    Object object2;
                    String[] stringArray;
                    Object object4;
                    ObjectIdentificationAlgorithm objectIdentificationAlgorithm = new ObjectIdentificationAlgorithm();
                    AbstractDataMatrix abstractDataMatrix = CountAnalysisPanel.this.getMatrix();
                    Object[] objectArray = new Object[]{abstractDataMatrix};
                    Properties properties = new Properties();
                    properties.put("grid", "3x3");
                    if (CountAnalysisPanel.this.blobCheckBox.isSelected()) {
                        properties.put("blob", "true");
                    }
                    if (CountAnalysisPanel.this.minAreaTextField.getNumber() > 0.0) {
                        properties.put("minarea", String.valueOf((int)CountAnalysisPanel.this.minAreaTextField.getNumber()));
                    }
                    properties.put("pixelarea", String.valueOf(CountAnalysisPanel.this.areaUnitRatioTextField.getNumber()));
                    properties.put("pixelunit", CountAnalysisPanel.this.unitComboBox.getSelectedItem().toString());
                    if (CountAnalysisPanel.this.createTabbedPane.getSelectedIndex() == 1) {
                        object4 = (InnerColumnClass)CountAnalysisPanel.this.classComboBox.getSelectedItem();
                        if (object4 instanceof InnerColumnPredClass) {
                            properties.put("predcategory", ((AbstractInnerColumn)object4).toString());
                        } else {
                            properties.put("category", ((AbstractInnerColumn)object4).toString());
                        }
                        if (CountAnalysisPanel.this.subClassComboBox.getSelectedIndex() > 0) {
                            properties.put("type", CountAnalysisPanel.this.subClassComboBox.getSelectedItem());
                        }
                    } else {
                        double d = CountAnalysisPanel.this.minThresTextField.getNumber();
                        d = d / 100.0 * (CountAnalysisPanel.this.minmax[1] - CountAnalysisPanel.this.minmax[0]) + CountAnalysisPanel.this.minmax[0];
                        properties.put("minthreshold", String.valueOf(d));
                        double d2 = CountAnalysisPanel.this.maxThresTextField.getNumber();
                        d2 = d2 / 100.0 * (CountAnalysisPanel.this.minmax[1] - CountAnalysisPanel.this.minmax[0]) + CountAnalysisPanel.this.minmax[0];
                        properties.put("maxthreshold", String.valueOf(d2));
                    }
                    object4 = CountAnalysisPanel.this.propertiesTextPane.getText();
                    for (String string : stringArray = ScriptHelper.breakIntoTokens((String)object4, "\r")) {
                        int n = string.indexOf("=");
                        object2 = string.substring(0, n);
                        object = string.substring(n + 1);
                        properties.put(((String)object2).trim(), ((String)object).trim());
                    }
                    Object object3 = objectIdentificationAlgorithm.performAnalysis(this, objectArray, properties);
                    DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(abstractDataMatrix, DataSet.class);
                    CountDataSetGroup countDataSetGroup = new CountDataSetGroup(dataSet, (IdentifiedObjectListWithSummary)object3, properties);
                    Case case_ = abstractDataMatrix.getCase();
                    case_.getDsContainer().addTreeNode(countDataSetGroup);
                    Object object5 = CountAnalysisPanel.this.scriptComboBox.getSelectedItem();
                    if (object5 instanceof AbstractScriptInfo) {
                        object2 = (AbstractScriptInfo)object5;
                        object = new ScriptManager(CountAnalysisPanel.this.project_GUI);
                        ((ScriptManager)object).addVariable(countDataSetGroup, "dataset");
                        ((ScriptManager)object).evaluteScript(this, ((AbstractScriptInfo)object2).getScript(), false, true);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
                return null;
            }
        };
        progressManagerImpl.invokeLater();
        this.dialog.dispose();
    }

    private AbstractDataMatrix getMatrix() {
        if (this.dti instanceof AbstractDataMatrix) {
            return (AbstractDataMatrix)this.dti;
        }
        return ((AbstractAxisPlot)this.dti).getPlotInit().getMatrix(0);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.normalPanel = new JPanel();
        this.optionPanel = new JPanel();
        this.settingsPanel = new JPanel();
        this.minAreaLabel = new JLabel();
        this.minAreaTextField = new JTextFieldButtonUppDown();
        this.blobCheckBox = new JCheckBox();
        this.areaUnitLabel = new JLabel();
        this.areaUnitRatioTextField = new JTextFieldButtonUppDown();
        this.unitComboBox = new JComboBox();
        this.rightPanel = new JPanel();
        this.graphPanel = new JPanel();
        this.createTabbedPane = new JTabbedPane();
        this.thresholdPanel = new JPanel();
        this.minThresholdLabel = new JLabel();
        this.minThresTextField = new JTextFieldButtonUppDown();
        this.histogramPanel = new JPanel();
        this.maxThresholdLabel = new JLabel();
        this.maxThresTextField = new JTextFieldButtonUppDown();
        this.classPanel = new JPanel();
        this.classLabel = new JLabel();
        this.classComboBox = new JComboBoxCell();
        this.subClassComboBox = new JComboBoxCell();
        this.subClassLabel = new JLabel();
        this.advancePanel = new JPanel();
        this.propertiesPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.propertiesTextPane = new JTextPane();
        this.jLabel1 = new JLabel();
        this.buttonPanel = new JPanel();
        this.createButton = new JButton();
        this.cancelButton = new JButton();
        this.templatePanel = new JPanel();
        this.templateLabel = new JLabel();
        this.scriptComboBox = new JComboBoxCell();
        this.setLayout(new GridBagLayout());
        this.normalPanel.setLayout(new GridBagLayout());
        this.optionPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.settingsPanel.setLayout(new GridBagLayout());
        this.minAreaLabel.setText("Min area (pixels):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.settingsPanel.add((Component)this.minAreaLabel, gridBagConstraints);
        this.minAreaTextField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.settingsPanel.add((Component)this.minAreaTextField, gridBagConstraints);
        this.blobCheckBox.setSelected(true);
        this.blobCheckBox.setText("Separate adjacent objects");
        this.blobCheckBox.addItemListener(itemEvent -> this.blobCheckBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.settingsPanel.add((Component)this.blobCheckBox, gridBagConstraints);
        this.areaUnitLabel.setText("Area/Unit ratio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.settingsPanel.add((Component)this.areaUnitLabel, gridBagConstraints);
        this.areaUnitRatioTextField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.settingsPanel.add((Component)this.areaUnitRatioTextField, gridBagConstraints);
        this.unitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"px", "nm", "\u00b5m", "mm", "cm", "dm", "m", "km"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.settingsPanel.add((Component)this.unitComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.optionPanel.add((Component)this.settingsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.normalPanel.add((Component)this.optionPanel, gridBagConstraints);
        this.rightPanel.setLayout(new GridBagLayout());
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.graphPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rightPanel.add((Component)this.graphPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.normalPanel.add((Component)this.rightPanel, gridBagConstraints);
        this.createTabbedPane.setTabPlacement(2);
        this.thresholdPanel.setBorder(BorderFactory.createTitledBorder("Create from threshold"));
        this.thresholdPanel.setLayout(new GridBagLayout());
        this.minThresholdLabel.setText("Min threshold (0-100%):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.thresholdPanel.add((Component)this.minThresholdLabel, gridBagConstraints);
        this.minThresTextField.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.thresholdPanel.add((Component)this.minThresTextField, gridBagConstraints);
        this.histogramPanel.setBorder(BorderFactory.createTitledBorder("Histogram"));
        this.histogramPanel.setMinimumSize(new Dimension(250, 150));
        this.histogramPanel.setPreferredSize(new Dimension(250, 150));
        this.histogramPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.thresholdPanel.add((Component)this.histogramPanel, gridBagConstraints);
        this.maxThresholdLabel.setText("Max threshold (0-100%):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.thresholdPanel.add((Component)this.maxThresholdLabel, gridBagConstraints);
        this.maxThresTextField.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.thresholdPanel.add((Component)this.maxThresTextField, gridBagConstraints);
        this.createTabbedPane.addTab("Threshold", this.thresholdPanel);
        this.classPanel.setBorder(BorderFactory.createTitledBorder("Create from class"));
        this.classPanel.setLayout(new GridBagLayout());
        this.classLabel.setText("Class:");
        this.classLabel.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.classPanel.add((Component)this.classLabel, gridBagConstraints);
        this.classComboBox.setMinimumSize(new Dimension(120, 18));
        this.classComboBox.setPreferredSize(new Dimension(120, 20));
        this.classComboBox.addItemListener(itemEvent -> this.classComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.classPanel.add((Component)this.classComboBox, gridBagConstraints);
        this.subClassComboBox.setMinimumSize(new Dimension(120, 18));
        this.subClassComboBox.setPreferredSize(new Dimension(120, 20));
        this.subClassComboBox.addItemListener(itemEvent -> this.subClassComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.classPanel.add((Component)this.subClassComboBox, gridBagConstraints);
        this.subClassLabel.setText("Sub class:");
        this.subClassLabel.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.classPanel.add((Component)this.subClassLabel, gridBagConstraints);
        this.createTabbedPane.addTab("Class", this.classPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.normalPanel.add((Component)this.createTabbedPane, gridBagConstraints);
        this.tabbedPane.addTab("General", this.normalPanel);
        this.advancePanel.setLayout(new GridBagLayout());
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder("Other properties"));
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.propertiesTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.propertiesPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText("Add properties (Key=Value)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.propertiesPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.advancePanel.add((Component)this.propertiesPanel, gridBagConstraints);
        this.tabbedPane.addTab("Advanced", this.advancePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.createButton.setText("OK");
        this.createButton.setMinimumSize(new Dimension(81, 26));
        this.createButton.setPreferredSize(new Dimension(81, 26));
        this.createButton.addActionListener(actionEvent -> this.createButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.buttonPanel.add((Component)this.createButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(81, 26));
        this.cancelButton.setPreferredSize(new Dimension(81, 26));
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.templatePanel.setBorder(BorderFactory.createTitledBorder("Template"));
        this.templatePanel.setLayout(new GridBagLayout());
        this.templateLabel.setText("Select template:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.templatePanel.add((Component)this.templateLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.templatePanel.add((Component)this.scriptComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.templatePanel, gridBagConstraints);
    }

    private void radioButtonChanged() {
        double d = this.minThresTextField.getNumber();
        d = d / 100.0 * (this.minmax[1] - this.minmax[0]) + this.minmax[0];
        double d2 = this.maxThresTextField.getNumber();
        d2 = d2 / 100.0 * (this.minmax[1] - this.minmax[0]) + this.minmax[0];
        this.contourPlot.setValues(this.createTabbedPane.getSelectedIndex() == 0, d, d2, (InnerColumnClass)this.classComboBox.getSelectedItem(), (String)this.subClassComboBox.getSelectedItem());
    }

    private void setClasses(AbstractDataMatrix abstractDataMatrix, int n) {
        if (abstractDataMatrix instanceof FoldMatrix) {
            abstractDataMatrix = ((FoldMatrix)abstractDataMatrix).getReferencedMatrix();
        }
        DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(abstractDataMatrix, DataSet.class);
        Case case_ = (Case)DataTreeManager.getAncestorNull(abstractDataMatrix, Case.class);
        if (dataSet != null || case_ != null) {
            AbstractDataInfo abstractDataInfo = dataSet != null ? dataSet.getDataInfo(n) : case_.getDataInfo(n);
            Transformations transformations = (Transformations)abstractDataInfo.getGroupColumnByType(10);
            int n2 = this.classComboBox.getSelectedIndex();
            this.classComboBox.removeAllItems();
            this.subClassComboBox.removeAllItems();
            this.subClassComboBox.setEnabled(false);
            int n3 = transformations.getColumnCount();
            for (int i = 0; i < n3; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                this.classComboBox.addItem(transformations.getInnerColumn(i));
            }
            PredictionClasses predictionClasses = (PredictionClasses)abstractDataInfo.getGroupColumnByType(11);
            if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
                if (this.classComboBox.getItemCount() > 0) {
                    this.classComboBox.addSeparator();
                }
                for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                    this.classComboBox.addItem(predictionClasses.getInnerColumn(i));
                }
            }
            if (n2 >= 0 && n2 < this.classComboBox.getItemCount()) {
                this.classComboBox.setSelectedIndex(n2);
            }
        }
        this.classComboBox.setEnabled(this.classComboBox.getItemCount() > 1);
    }

    private void subClassComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.radioButtonChanged();
        }
    }
}

