/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.image.count.algorithm.IdentifiedObjectDataClass;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.DataImage;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnImageResource;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.GroupMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptHelper;

public class CountDataSetGroup
extends DataSetGroup
implements DataTreeExtLibInterface {
    private final IdentifiedObjectListWithSummary countDataClass;
    private final int sK = 9;
    private int spec_object = 1;
    private double spec_factor = 1.0;
    private int spec_type = TYPE_AVERAGE;
    private double random_factor = 0.9;

    public CountDataSetGroup(IdentifiedObjectListWithSummary identifiedObjectListWithSummary) {
        super("DataSet (Object Identification)");
        this.countDataClass = identifiedObjectListWithSummary;
        this.addTreeNode(identifiedObjectListWithSummary);
    }

    public CountDataSetGroup(DataSet dataSet, IdentifiedObjectListWithSummary identifiedObjectListWithSummary, Properties properties) {
        this(identifiedObjectListWithSummary);
        this.referenceDataSet = dataSet;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "spectrum_per_object")) {
                this.spec_object = ScriptHelper.getPropertyInt(properties, "spectrum_per_object");
            }
            if (ScriptHelper.hasKey(properties, "spectrum_factor")) {
                this.spec_factor = ScriptHelper.getPropertyDouble(properties, "spectrum_factor");
            }
            if (ScriptHelper.hasKey(properties, "spectrum_type")) {
                String string = ScriptHelper.getProperty(properties, "spectrum_type");
                String[] stringArray = new String[]{"average", "median", "random"};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    this.spec_type = i;
                    break;
                }
            }
            if (ScriptHelper.hasKey(properties, "random_factor")) {
                this.random_factor = ScriptHelper.getPropertyDouble(properties, "random_factor");
            }
        }
        this.initiateDataSetGroup();
    }

    public CountDataSetGroup(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.countDataClass = (IdentifiedObjectListWithSummary)mapProperty.resolveNodeFromName(randomInputStream, "cdc");
    }

    public IdentifiedObjectListWithSummary getCountDataClass() {
        return this.countDataClass;
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 14;
    }

    @Override
    public Object[] list(String string) {
        if (string.equalsIgnoreCase("objects")) {
            List<IdentifiedObjectDataClass> list = this.countDataClass.createObjectList();
            Object[] objectArray = new IdentifiedObjectDataClass[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = list.get(i);
            }
            return objectArray;
        }
        return super.list(string);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("cdc", this.countDataClass);
    }

    public void updateAverageLocal() {
        int n = 0;
        GroupMatrix groupMatrix = (GroupMatrix)this.getParentMatrix();
        List<IdentifiedObjectDataClass> list = this.countDataClass.createObjectList();
        for (IdentifiedObjectDataClass identifiedObjectDataClass : list) {
            identifiedObjectDataClass.createDataValues(this.referenceDataSet, this.spec_object, this.spec_factor, this.spec_type, this.random_factor);
            for (int i = 0; i < this.spec_object; ++i) {
                this.setRowData(groupMatrix, this.getObsDataInfo(), this.getVarDataInfo(), identifiedObjectDataClass, n, i);
                ++n;
            }
        }
    }

    @Override
    public void updateAverages() {
        this.updateAverageLocal();
        this.setChanged();
    }

    @Override
    protected DataSet cloneThisDataSet() {
        AbstractDataInfo[] abstractDataInfoArray = new AbstractDataInfo[]{(AbstractDataInfo)this.getObsDataInfo().clone(), (AbstractDataInfo)this.getVarDataInfo().clone()};
        IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)this.countDataClass.clone();
        CountDataSetGroup countDataSetGroup = new CountDataSetGroup(identifiedObjectListWithSummary);
        countDataSetGroup.initiateDataSet(this.referenceDataSet, abstractDataInfoArray, this.transformMatrixGroup);
        return countDataSetGroup;
    }

    @Override
    protected void groupLocal(int[] nArray) {
        List<IdentifiedObjectDataClass> list = this.countDataClass.createObjectList();
        ArrayList arrayList = null;
        int n = 0;
        DataTreeInterface dataTreeInterface = null;
        for (int n2 : nArray) {
            IdentifiedObjectDataClass identifiedObjectDataClass = list.get(n2);
            arrayList.add(identifiedObjectDataClass);
            n += identifiedObjectDataClass.getInteractionArray().length;
            dataTreeInterface = identifiedObjectDataClass.getTreeParent();
            dataTreeInterface.removeTreeNode(identifiedObjectDataClass);
            ((DataTreeClass)arrayList).addTreeNode(identifiedObjectDataClass);
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        for (int n4 : nArray) {
            IdentifiedObjectDataClass identifiedObjectDataClass = list.get(n4);
            int[] nArray3 = identifiedObjectDataClass.getInteractionArray();
            System.arraycopy(nArray3, 0, nArray2, n3, nArray3.length);
            n3 += nArray3.length;
        }
        ((IdentifiedObjectDataClass)arrayList).setInteractionArray(nArray2);
        if (dataTreeInterface instanceof DataTreeClass) {
            ((DataTreeClass)dataTreeInterface).insertTreeNode(nArray[0], (DataTreeInterface)((Object)arrayList));
        } else {
            dataTreeInterface.addTreeNode((DataTreeInterface)((Object)arrayList));
        }
        try {
            Object object = (GroupMatrix)this.getParentMatrix();
            int[] nArray4 = Case.createIndex(nArray, ((AbstractMVmatrix)object).getN(), 1);
            ((AbstractDataMatrix)object).deleteData(nArray4, null);
            this.removeIndex(nArray4, null, false);
            this.updateAverageLocal();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    protected void ungroupLocal(int[] nArray) {
        List<IdentifiedObjectDataClass> list = this.countDataClass.createObjectList();
        int n = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            IdentifiedObjectDataClass identifiedObjectDataClass = list.remove(nArray[i]);
            DataTreeInterface dataTreeInterface = identifiedObjectDataClass.getTreeParent();
            for (int j = identifiedObjectDataClass.getTreeNodeCount() - 1; j >= 0; --j) {
                IdentifiedObjectDataClass identifiedObjectDataClass2 = (IdentifiedObjectDataClass)identifiedObjectDataClass.getTreeNodeAt(j);
                identifiedObjectDataClass.removeTreeNode(identifiedObjectDataClass2);
                dataTreeInterface.addTreeNode(identifiedObjectDataClass2);
                list.add(identifiedObjectDataClass2);
                ++n;
            }
            identifiedObjectDataClass.cleanUp();
        }
        GroupMatrix groupMatrix = (GroupMatrix)this.getParentMatrix();
        groupMatrix.addData(n -= nArray.length, 0);
        this.addData(0, n, 0, 0, true);
        this.updateAverageLocal();
    }

    private Double[] createArray(int n, int n2) {
        Double[] doubleArray = new Double[n2 - n];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            doubleArray[n3++] = (double)i + 1.0;
        }
        return doubleArray;
    }

    private int getMaxGroupID(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof DataSetGroup) {
            DataSetGroup dataSetGroup = (DataSetGroup)dataTreeInterface;
            return dataSetGroup.getGroupID();
        }
        int n = 0;
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            int n2 = this.getMaxGroupID(dataTreeInterface2);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private void initiateDataSetGroup() {
        int n;
        List<IdentifiedObjectDataClass> list = this.countDataClass.createObjectList();
        int n2 = list.size() * this.spec_object;
        AbstractDataMatrix abstractDataMatrix = this.referenceDataSet.getOriginalMatrix();
        int n3 = 9 + abstractDataMatrix.getK();
        int n4 = this.getMaxGroupID(this.referenceDataSet.getCase()) + 1;
        ObservationInfo observationInfo = new ObservationInfo(n2, n4);
        VariablesInfo variablesInfo = new VariablesInfo(n3, n4);
        Description description = (Description)observationInfo.getGroupColumnByType(0);
        description.addColumn("Name");
        DataImage dataImage = (DataImage)observationInfo.getGroupColumnByType(12);
        InnerColumnImageResource innerColumnImageResource = (InnerColumnImageResource)dataImage.addColumn("Object");
        this.addTreeNode(innerColumnImageResource.getResourceNode());
        Description description2 = (Description)variablesInfo.getGroupColumnByType(0);
        InnerColumnString innerColumnString = (InnerColumnString)description2.addColumn("Name");
        String[] stringArray = new String[]{"Area", "D1", "D2", "Circumference", "Regularity", "Roundness", "Orientation", "X", "Y"};
        for (int i = 0; i < stringArray.length; ++i) {
            innerColumnString.setValueLocal(i, stringArray[i]);
        }
        GroupMatrix groupMatrix = (GroupMatrix)this.getParentMatrix();
        if (groupMatrix == null) {
            groupMatrix = new GroupMatrix(n2, n3, n4);
        } else {
            groupMatrix.resize(n2, n3);
        }
        groupMatrix.setName("Object Matrix");
        groupMatrix.setRowDescription(description);
        groupMatrix.setColumnDescription(description2);
        this.addTreeNode(groupMatrix);
        this.initiateDataSet(this.referenceDataSet, new AbstractDataInfo[]{observationInfo, variablesInfo}, groupMatrix);
        int n5 = 0;
        for (IdentifiedObjectDataClass cloneable2 : list) {
            if (!cloneable2.createDataValues(this.referenceDataSet, this.spec_object, this.spec_factor, this.spec_type, this.random_factor)) continue;
            for (int innerColumnBoolean = 0; innerColumnBoolean < this.spec_object; ++innerColumnBoolean) {
                this.setRowData(groupMatrix, observationInfo, variablesInfo, cloneable2, n5, innerColumnBoolean);
                if (n5 == 0) {
                    double[][] dArray = cloneable2.getMeanValues();
                    for (n = 0; n < dArray[0].length; ++n) {
                        innerColumnString.setValueLocal(9 + n, abstractDataMatrix.getColumnDescription(n, 0));
                    }
                }
                ++n5;
            }
        }
        for (int i = 0; i < observationInfo.getAllColumnCount(); ++i) {
            AbstractInnerColumn abstractInnerColumn = observationInfo.getAllInnerColumn(i);
            if (!(abstractInnerColumn instanceof InnerColumnClass)) continue;
            InnerColumnClass innerColumnClass = (InnerColumnClass)abstractInnerColumn;
            observationInfo.triggerGlobalEvent(new DataInfoClassEvent((AbstractDataInfo)observationInfo, 0, innerColumnClass.getCategory(), innerColumnClass.getObject(), 0));
        }
        try {
            this.createModification(null, "var", "center");
            this.createModification(null, "var", "uvscale", this.createArray(0, 9));
            Double[] doubleArray = this.createArray(9, groupMatrix.getK());
            this.createModification(null, "var", "snv", doubleArray);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)this.referenceDataSet.getVarDataInfo().getPrimaryColumnByType(1);
            for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
                if (!innerColumnBoolean.getValueBool(i)) continue;
                arrayList.add(i);
            }
            Double[] doubleArray2 = new Double[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                doubleArray2[n] = 9.0 + (double)((Integer)arrayList.get(n)).intValue() + 1.0;
            }
            this.includeOnly("var", doubleArray2);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void setRowData(GroupMatrix groupMatrix, ObservationInfo observationInfo, VariablesInfo variablesInfo, IdentifiedObjectDataClass identifiedObjectDataClass, int n, int n2) {
        AbstractInnerColumn abstractInnerColumn;
        IdentifiedObject identifiedObject = identifiedObjectDataClass.getIdentifiedObject();
        int n3 = 0;
        groupMatrix.setValue(n, n3++, identifiedObject.getArea());
        groupMatrix.setValue(n, n3++, identifiedObject.getD1());
        groupMatrix.setValue(n, n3++, identifiedObject.getD2());
        groupMatrix.setValue(n, n3++, identifiedObject.getCircumference());
        groupMatrix.setValue(n, n3++, identifiedObject.getRegularity());
        groupMatrix.setValue(n, n3++, identifiedObject.getRoundness());
        groupMatrix.setValue(n, n3++, identifiedObject.getOrientation());
        groupMatrix.setValue(n, n3++, identifiedObject.getCenterPoint2().x);
        groupMatrix.setValue(n, n3++, identifiedObject.getCenterPoint2().y);
        double[][] dArray = identifiedObjectDataClass.getMeanValues();
        for (int i = 0; i < dArray[n2].length; ++i) {
            groupMatrix.setValue(n, 9 + i, dArray[n2][i]);
        }
        groupMatrix.setGroup(n, identifiedObjectDataClass.getInteractionArray());
        Description description = groupMatrix.getRowDescription();
        InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumnByName("name");
        innerColumnString.setValueLocal(n, identifiedObjectDataClass.getName());
        ObservationInfo observationInfo2 = this.referenceDataSet.getObsDataInfo();
        for (int i = 0; i < observationInfo2.getAllColumnCount(); ++i) {
            int n4;
            CleanUpInterface cleanUpInterface;
            abstractInnerColumn = observationInfo2.getAllInnerColumn(i);
            if (!(abstractInnerColumn instanceof InnerColumnClass)) continue;
            InnerColumnClass innerColumnClass = (InnerColumnClass)abstractInnerColumn;
            innerColumnClass.toString();
            InnerColumnClass innerColumnClass2 = observationInfo.getClassByNameOrIndex(innerColumnClass.toString(), -1);
            if (innerColumnClass2 == null) {
                try {
                    cleanUpInterface = (Category)this.createModification(null, "obs", "category");
                    ((AbstractTransform)cleanUpInterface).setName(innerColumnClass.toString());
                    innerColumnClass2 = ((Category)cleanUpInterface).getInnerColumn();
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
            if (innerColumnClass2 == null) continue;
            cleanUpInterface = innerColumnClass.getObject();
            int[] nArray = groupMatrix.getGroup(n);
            int[] nArray2 = new int[((ArrayList)((Object)cleanUpInterface)).size()];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                short s = innerColumnClass.getValueShort(nArray[n4]);
                nArray2[s] = nArray2[s] + 1;
            }
            n4 = 0;
            int n5 = 0;
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] <= n5) continue;
                n5 = nArray2[j];
                n4 = j;
            }
            ClassSettings classSettings = ((ClassTypes)cleanUpInterface).getClassSettings(n4);
            ClassTypes classTypes = innerColumnClass2.getObject();
            ClassSettings classSettings2 = classTypes.getClassSettingsByName(classSettings.getName());
            if (classSettings2 == null) {
                classSettings2 = classTypes.getClassSettings(classTypes.addString(classSettings.getName()));
            }
            classSettings2.setColor(classSettings.getColor());
            innerColumnClass2.setValueShort(n, (byte)classSettings2.getRefindex());
            Category category = innerColumnClass2.getCategory();
            if (category == null) continue;
            category.updateClasses();
        }
        DataImage dataImage = (DataImage)observationInfo.getGroupColumnByType(12);
        abstractInnerColumn = (InnerColumnImageResource)dataImage.getPrimaryColumn();
        abstractInnerColumn.setValue(n, new ImageResource(identifiedObjectDataClass.getObjectImage(), identifiedObjectDataClass.getName()));
    }
}

