/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.algorithm;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.dataimport.image.Pixel;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.type.DataSetGroup;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.AbstractScriptDataClass;
import se.prediktera.map.main.script.AbstractScriptDataTreeMemoryClass;

public class IdentifiedObjectDataClass
extends AbstractScriptDataTreeMemoryClass
implements DataTreeExtLibInterface,
InteractionInterface {
    private static final ImageIcon objectIcon = new ImageIcon(IdentifiedObjectDataClass.class.getResource("gif/particlegray.gif"));
    private static final double CONVCRITSQ = 1.0E-12;
    private static final int NITMAX = 200;
    private int[] interactionArray;
    private int interactionCenterPoint;
    private int interactionSize;
    private double[][] spec_mean;
    private BufferedImage objectImage;
    private IdentifiedObject identifiedObject;

    public IdentifiedObjectDataClass(String string, IdentifiedObject identifiedObject) {
        super("Object " + (String)(string != null ? string + " " : "") + identifiedObject.getId());
        this.identifiedObject = identifiedObject;
    }

    public IdentifiedObjectDataClass(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        int n = mapProperty.getPropertyInt("id");
        int n2 = mapProperty.getPropertyInt("min");
        int n3 = mapProperty.getPropertyInt("max");
        int n4 = mapProperty.getPropertyInt("width");
        int n5 = mapProperty.getPropertyInt("height");
        double d = mapProperty.getPropertyDouble("d1");
        double d2 = mapProperty.getPropertyDouble("d2");
        int n6 = mapProperty.getPropertyInt("circumference");
        double d3 = mapProperty.getPropertyDouble("regularity");
        double d4 = mapProperty.getPropertyDouble("roundness");
        double d5 = mapProperty.getPropertyDouble("orientation");
        double d6 = mapProperty.getPropertyDouble("radius");
        this.interactionArray = mapProperty.getPropertyIntArray("iarray", null);
        this.interactionSize = mapProperty.getPropertyInt("isize", 0);
        this.interactionCenterPoint = mapProperty.getPropertyInt("icp", 0);
        double d7 = mapProperty.getPropertyDouble("ssx");
        double d8 = mapProperty.getPropertyDouble("areadivcirc");
        boolean bl = mapProperty.getPropertyBoolean("tb", false);
        int[][] nArray = mapProperty.getPropertyIntArray2d("parray", null);
        this.identifiedObject = new IdentifiedObject(n, n2, n3, n4, n5, d, d2, n6, d3, d4, d5, d6, d7, d8, bl);
        if (nArray != null) {
            List<Pixel> list = this.identifiedObject.getPointList();
            for (int[] nArray2 : nArray) {
                list.add(new Pixel(nArray2[0], nArray2[1]));
            }
        }
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        CMenuItem cMenuItem = new CMenuItem("Select objects", true);
        cMenuItem.addActionListener(actionEvent -> project_GUI.doInteraction(this));
        jPopupMenu.add(cMenuItem);
        return true;
    }

    @Override
    public Object clone() {
        IdentifiedObjectDataClass identifiedObjectDataClass = (IdentifiedObjectDataClass)super.clone();
        try {
            identifiedObjectDataClass.identifiedObject = (IdentifiedObject)this.identifiedObject.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        identifiedObjectDataClass.interactionArray = (int[])this.interactionArray.clone();
        if (this.spec_mean != null) {
            identifiedObjectDataClass.spec_mean = (double[][])this.spec_mean.clone();
        }
        return identifiedObjectDataClass;
    }

    public double[][] getMeanValues() {
        return this.spec_mean;
    }

    public void createInteractionArray(boolean bl, int[] nArray, int[] nArray2, int n) {
        List<Pixel> list = this.identifiedObject.getPointList();
        this.interactionArray = new int[list.size()];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Pixel pixel : list) {
            int n5 = pixel.x * n + pixel.y;
            if (nArray2 != null && nArray != null && bl && pixel.x < nArray2.length && pixel.y < nArray.length) {
                n5 = nArray2[pixel.x] * n + nArray[pixel.y];
            }
            n3 += pixel.x;
            n4 += pixel.y;
            this.interactionArray[n2] = n5;
            if (this.interactionSize < this.interactionArray[n2]) {
                this.interactionSize = this.interactionArray[n2];
            }
            ++n2;
        }
        this.interactionCenterPoint = (n3 /= list.size()) * n + (n4 /= list.size());
        if (nArray2 != null && nArray != null && bl && n3 < nArray2.length && n4 < nArray.length) {
            this.interactionCenterPoint = nArray2[n3] * n + nArray[n4];
        }
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof IdentifiedObjectDataClass) {
            return this.getId() == ((IdentifiedObjectDataClass)object).getId() && super.equals(object);
        }
        return super.equals(object);
    }

    @Override
    public void finishInteraction() {
    }

    @Override
    public Object get(String string) throws Exception {
        if (string.equalsIgnoreCase("indexarray")) {
            return this.getInteractionArray();
        }
        if (string.equalsIgnoreCase("pixels")) {
            int[] nArray = this.getInteractionArray();
            Double[] doubleArray = new Double[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                doubleArray[i] = (double)nArray[i] + 1.0;
            }
            return doubleArray;
        }
        if (string.equalsIgnoreCase("boundingbox")) {
            return this.identifiedObject.getBoundingBox();
        }
        if (string.equalsIgnoreCase("path")) {
            return this.identifiedObject.getPath();
        }
        if (string.equalsIgnoreCase("pointlist")) {
            return this.identifiedObject.getPointList();
        }
        if (string.equalsIgnoreCase("name")) {
            return this.toString();
        }
        if (string.equalsIgnoreCase("id")) {
            return (double)this.identifiedObject.getId();
        }
        if (string.equalsIgnoreCase("centrumindex")) {
            return (double)this.interactionCenterPoint;
        }
        if (string.equalsIgnoreCase("index")) {
            AbstractScriptDataClass abstractScriptDataClass = (AbstractScriptDataClass)this.getTreeParent();
            return (double)(abstractScriptDataClass.indexOf(this) + 1);
        }
        if (string.equalsIgnoreCase("area")) {
            return (double)this.getArea();
        }
        if (string.equalsIgnoreCase("d1")) {
            return this.identifiedObject.getD1();
        }
        if (string.equalsIgnoreCase("d2")) {
            return this.identifiedObject.getD2();
        }
        if (string.equalsIgnoreCase("width")) {
            return (double)this.identifiedObject.getWidth();
        }
        if (string.equalsIgnoreCase("height")) {
            return (double)this.identifiedObject.getHeight();
        }
        if (string.equalsIgnoreCase("roundness")) {
            return this.identifiedObject.getRoundness();
        }
        if (string.equalsIgnoreCase("orientation")) {
            return this.identifiedObject.getOrientation();
        }
        if (string.equalsIgnoreCase("radius")) {
            return this.identifiedObject.getRadius();
        }
        if (string.equalsIgnoreCase("regularity")) {
            return this.identifiedObject.getRegularity();
        }
        if (string.equalsIgnoreCase("areadivcirc")) {
            return this.identifiedObject.getAreadivcirc();
        }
        if (string.equalsIgnoreCase("ssx")) {
            return this.identifiedObject.getSsx();
        }
        if (string.equalsIgnoreCase("touchborder")) {
            return this.identifiedObject.isTouchborder() ? 1.0 : 0.0;
        }
        if (string.equalsIgnoreCase("centerpoint")) {
            return this.identifiedObject.getCenterPoint();
        }
        return super.get(string);
    }

    public int getArea() {
        if (this.interactionArray != null) {
            return this.interactionArray.length;
        }
        return this.identifiedObject.getArea();
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return objectIcon;
    }

    public int getId() {
        return this.identifiedObject.getId();
    }

    @Override
    public String getInformation() {
        IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)this.getTreeParent();
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD><B>Object:</B</TD><TD>");
        stringBuilder.append("<TR><TD>Area:</TD><TD>").append(identifiedObjectListWithSummary.getArea(this.getArea())).append("</TD></TR>");
        Pixel pixel = this.identifiedObject.getCenterPoint2();
        stringBuilder.append("<TR><TD>Center point:</TD><TD>").append(pixel.x + ", " + pixel.y).append("</TD></TR>");
        stringBuilder.append("<TR><TD>D1:</TD><TD>").append(identifiedObjectListWithSummary.getDistance(this.identifiedObject.getD1())).append("</TD></TR>");
        stringBuilder.append("<TR><TD>D2:</TD><TD>").append(identifiedObjectListWithSummary.getDistance(this.identifiedObject.getD2())).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Circumference:</TD><TD>").append(identifiedObjectListWithSummary.getDistance(this.identifiedObject.getCircumference())).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Regularity:</TD><TD>").append(NiceDataFormat.toPercent(this.identifiedObject.getRegularity())).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Roundness:</TD><TD>").append(NiceDataFormat.toPercent(this.identifiedObject.getRoundness())).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Orientation:</TD><TD>").append(NiceDataFormat.toString(this.identifiedObject.getOrientation(), 3)).append(" degrees</TD></TR>");
        stringBuilder.append("</BODY></HTML>");
        return stringBuilder.toString();
    }

    public int[] getInteractionArray() {
        return this.interactionArray;
    }

    public int getInteractionCenterPoint() {
        return this.interactionCenterPoint;
    }

    public int getInteractionSize() {
        return this.interactionSize;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 10;
    }

    @Override
    public void prepareInteraction() {
        if (this.interactionArray != null) {
            Project_GUI project_GUI = this.getProject_GUI();
            InteractionArray interactionArray = project_GUI.getInteractionArray(this.getCase(), 1, this.interactionSize, 0);
            for (int n : this.interactionArray) {
                interactionArray.set(n);
            }
        }
    }

    public void setClassification(InnerColumnClass innerColumnClass, short s) {
        if (this.interactionArray != null) {
            for (int n : this.interactionArray) {
                innerColumnClass.setValueShort(n, s);
            }
        }
    }

    public void setInteractionArray(int[] nArray) {
        this.interactionArray = nArray;
        this.interactionSize = 0;
        for (int n : nArray) {
            if (this.interactionSize >= n) continue;
            this.interactionSize = n;
        }
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.identifiedObject.cleanUp();
        this.interactionArray = null;
        this.spec_mean = null;
    }

    @Override
    protected void ClearDataLocal() throws IOException {
    }

    @Override
    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
    }

    @Override
    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("id", this.identifiedObject.getId());
        randomOutputStream.writePropertyInt("min", this.identifiedObject.getMin());
        randomOutputStream.writePropertyInt("max", this.identifiedObject.getMax());
        randomOutputStream.writePropertyInt("width", this.identifiedObject.getWidth());
        randomOutputStream.writePropertyInt("height", this.identifiedObject.getHeight());
        randomOutputStream.writePropertyDouble("d1", this.identifiedObject.getD1());
        randomOutputStream.writePropertyDouble("d2", this.identifiedObject.getD2());
        randomOutputStream.writePropertyInt("circumference", this.identifiedObject.getCircumference());
        randomOutputStream.writePropertyDouble("regularity", this.identifiedObject.getRegularity());
        randomOutputStream.writePropertyDouble("roundness", this.identifiedObject.getRoundness());
        randomOutputStream.writePropertyDouble("orientation", this.identifiedObject.getOrientation());
        randomOutputStream.writePropertyDouble("radius", this.identifiedObject.getRadius());
        randomOutputStream.writePropertyIntArray("iarray", this.interactionArray);
        randomOutputStream.writePropertyInt("icp", this.interactionCenterPoint);
        randomOutputStream.writePropertyInt("isize", this.interactionSize);
        randomOutputStream.writePropertyDouble("ssx", this.identifiedObject.getSsx());
        randomOutputStream.writePropertyDouble("areadivcirc", this.identifiedObject.getAreadivcirc());
        randomOutputStream.writePropertyBoolean("tb", this.identifiedObject.isTouchborder());
        List<Pixel> list = this.identifiedObject.getPointList();
        int[][] nArray = new int[list.size()][2];
        for (int i = 0; i < list.size(); ++i) {
            Pixel pixel = list.get(i);
            nArray[i][0] = pixel.x;
            nArray[i][1] = pixel.y;
        }
        randomOutputStream.writePropertyIntArray("parray", nArray);
    }

    public BufferedImage getObjectImage() {
        if (this.objectImage == null) {
            this.objectImage = this.identifiedObject.createObjectImage();
        }
        return this.objectImage;
    }

    private DenseVector[][] createPCA(DenseMatrix denseMatrix, int n) {
        DenseVector[] denseVectorArray = new DenseVector[n];
        DenseVector[] denseVectorArray2 = new DenseVector[n];
        for (int i = 0; i < n; ++i) {
            double d;
            int n2 = denseMatrix.numRows();
            DenseVector denseVector = denseVectorArray[i] = new DenseVector(n2);
            for (int j = 0; j < n2; ++j) {
                denseVector.set(j, (denseMatrix.get(j, 0) + denseMatrix.get(j, 1)) / 2.0);
            }
            DenseVector denseVector2 = new DenseVector(n2);
            DenseVector denseVector3 = null;
            DenseVector denseVector4 = denseVectorArray2[i] = new DenseVector(denseMatrix.numColumns());
            int n3 = 0;
            for (double d2 = 42.0; n3 < 200 && d2 > 1.0E-12; d2 /= d, ++n3) {
                denseVector3 = denseVector2;
                denseVector2 = denseVector;
                denseVector = denseVector3;
                MatrixExtensions.transMult(denseVector4, (Matrix)denseMatrix, denseVector2);
                denseVector4.scale(1.0 / denseVector4.norm(Vector.Norm.Two));
                MatrixExtensions.mult(denseVector, (Matrix)denseMatrix, denseVector4);
                d2 = 0.0;
                double[] dArray = denseVector2.getData();
                double[] dArray2 = denseVector.getData();
                d = 0.0;
                double d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d3 = dArray2[j];
                    d += d3 * d3;
                    d2 += (d3 -= dArray[j]) * d3;
                }
            }
            for (int j = 0; j < denseMatrix.numRows(); ++j) {
                for (int k = 0; k < denseMatrix.numColumns(); ++k) {
                    denseMatrix.set(j, k, denseMatrix.get(j, k) - denseVector.get(j) * denseVector4.get(k));
                }
            }
        }
        return new DenseVector[][]{denseVectorArray, denseVectorArray2};
    }

    public boolean createDataValues(DataSet dataSet, int n, double d, int n2, double d2) {
        int n3;
        double d3;
        int n4;
        double d4;
        int n5;
        int n6;
        AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(1);
        int n7 = abstractDataMatrix.getK();
        double[] dArray = new double[n7];
        int[] nArray = new int[n7];
        boolean bl = abstractDataMatrix.hasMissing();
        Arrays.sort(this.interactionArray);
        int[] nArray2 = abstractDataMatrix.getNrefOrig(this.interactionArray, null);
        int n8 = nArray2.length;
        int n9 = 0;
        for (int i = 0; i < n8; ++i) {
            int n10 = nArray2[i];
            if (!innerColumnBoolean.getValueBool(n10)) continue;
            ++n9;
        }
        if (n9 == 0) {
            return false;
        }
        DenseMatrix denseMatrix = new DenseMatrix(n9, n7);
        DenseMatrix denseMatrix2 = new DenseMatrix(n9, n7);
        int n11 = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = nArray2[n6];
            if (!innerColumnBoolean.getValueBool(n5)) continue;
            double d5 = 0.0;
            for (int i = 0; i < n7; ++i) {
                if (bl && abstractDataMatrix.isMissing(n5, i)) continue;
                double d6 = abstractDataMatrix.getValue(n5, i);
                denseMatrix.set(n11, i, d6);
                d5 += d6;
            }
            d5 /= (double)(n7 - 0);
            d4 = 0.0;
            for (int i = 0; i < n7; ++i) {
                double d7 = d5 - denseMatrix.get(n11, i);
                d4 += d7 * d7;
            }
            double d8 = Math.sqrt(d4 / (double)(n7 - 1 - 0));
            if (d8 != 0.0) {
                n4 = 0;
                while (n4 < n7) {
                    double d9 = denseMatrix.get(n11, n4) - d5;
                    double d10 = d9 / d8;
                    denseMatrix2.set(n11, n4, d10);
                    int n12 = n4;
                    dArray[n12] = dArray[n12] + d10;
                    int n13 = n4++;
                    nArray[n13] = nArray[n13] + 1;
                }
            }
            ++n11;
        }
        for (n6 = 0; n6 < n7; ++n6) {
            if (nArray[n6] <= 0) continue;
            int n14 = n6;
            dArray[n14] = dArray[n14] / (double)nArray[n6];
        }
        ArrayList<IndexValue> arrayList = null;
        if (d < 1.0) {
            for (n5 = 0; n5 < n9; ++n5) {
                for (int i = 0; i < n7; ++i) {
                    denseMatrix2.set(n5, i, denseMatrix2.get(n5, i) - dArray[i]);
                }
            }
            DenseVector[][] denseVectorArray = this.createPCA(denseMatrix2, 1);
            DenseVector[] denseVectorArray2 = denseVectorArray[0];
            arrayList = new ArrayList<IndexValue>(n9);
            for (int i = 0; i < n9; ++i) {
                arrayList.add(new IndexValue(i, denseVectorArray2[0].get(i)));
            }
            Collections.sort(arrayList, (indexValue, indexValue2) -> Double.compare(indexValue.v, indexValue2.v));
        }
        int n15 = (int)Math.max(1.0, d * (double)n9);
        double d11 = (1.0 - d) / 2.0;
        d4 = d3 = (double)n15 / (double)n;
        int[][] nArray3 = null;
        if (n2 == DataSetGroup.TYPE_MEDIAN) {
            d4 = 1.0;
        } else if (n2 == DataSetGroup.TYPE_RANDOM) {
            d4 = (int)((double)n15 * d2);
            nArray3 = new int[n][(int)d4];
            Random random = new Random(0L);
            for (n4 = 0; n4 < n; ++n4) {
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                for (n3 = 0; n3 < n15; ++n3) {
                    linkedList.add(n3);
                }
                n3 = 0;
                while ((double)n3 < d4) {
                    int n16;
                    nArray3[n4][n3] = n16 = ((Integer)linkedList.remove(random.nextInt(linkedList.size()))).intValue();
                    ++n3;
                }
            }
            d3 = 0.0;
        }
        this.spec_mean = new double[n][n7];
        int n17 = (int)(d11 * (double)n15);
        for (n4 = 0; n4 < n; ++n4) {
            int n18 = 0;
            while ((double)n18 < d4) {
                n3 = n17 + n18;
                if (nArray3 != null) {
                    n3 = n17 + nArray3[n4][n18];
                }
                if (arrayList != null) {
                    n3 = ((IndexValue)arrayList.get((int)n3)).i;
                }
                for (int i = 0; i < n7; ++i) {
                    double[] dArray2 = this.spec_mean[n4];
                    int n19 = i;
                    dArray2[n19] = dArray2[n19] + denseMatrix.get(n3, i);
                }
                ++n18;
            }
            n18 = 0;
            while (n18 < n7) {
                double[] dArray3 = this.spec_mean[n4];
                int n20 = n18++;
                dArray3[n20] = dArray3[n20] / d4;
            }
            n17 = (int)((double)n17 + d3);
        }
        return true;
    }

    public IdentifiedObject getIdentifiedObject() {
        return this.identifiedObject;
    }

    private static class IndexValue {
        public int i;
        public double v;

        public IndexValue(int n, double d) {
            this.i = n;
            this.v = d;
        }
    }
}

