/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.algorithm;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.image.count.algorithm.IdentifiedObjectDataClass;
import se.prediktera.image.count.algorithm.IdentifiedObjectListContinuesWithSummary;
import se.prediktera.image.count.algorithm.ObjectIdentificationTableModel;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionGroupInterface;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.data.modeltable.ModelTableInterface;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.dataimport.breeze.image.count.ObjectIdentificationHelper;
import se.prediktera.map.dataimport.image.Pixel;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.AbstractScriptDataClass;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.ModelListener;

public class IdentifiedObjectListWithSummary
extends AbstractScriptDataClass
implements DataTreeExtLibInterface,
ModelTableInterface,
InteractionGroupInterface {
    private boolean isholder;
    private int number;
    private int min;
    private int max;
    private int mean;
    private int median;
    private int total;
    private int circumference;
    private double d1;
    private double d2;
    private double regularity;
    private double std;
    private double roundness;
    private double orientation;
    private double ssx;
    private double areadivcirc;
    private double[] interactionCenterPoint;
    private String objectName = null;
    private ArrayList<ModelListener> listeners = new ArrayList();
    private MVmatrix sizeVector;
    private InteractionArray interactionGroupArray;
    private DataSet dataSet;
    private double[] isize;
    private double[] iroundness;
    private double[] iorientation;
    private double distribution;
    private double balance;
    private double balanceangle;
    private double pixelarea;
    private String pixelunit;
    private IdentifiedObjectListContinuesWithSummary continuesClass;

    public IdentifiedObjectListWithSummary(double d, String string) {
        super("Object Identification");
        this.pixelarea = d;
        this.pixelunit = string;
        this.isholder = true;
    }

    public IdentifiedObjectListWithSummary(double d, String string, List<IdentifiedObject> list, boolean bl, int[] nArray, int[] nArray2, int n, boolean bl2) {
        super("Object Identification");
        this.pixelarea = d;
        this.pixelunit = string;
        this.setName("Object Identification");
        this.isholder = false;
        if (!list.isEmpty()) {
            int n2 = 0;
            for (IdentifiedObject identifiedObject : list) {
                IdentifiedObjectDataClass identifiedObjectDataClass = new IdentifiedObjectDataClass("", identifiedObject);
                identifiedObjectDataClass.setName("Object " + (n2 + 1));
                identifiedObjectDataClass.createInteractionArray(bl, nArray, nArray2, n);
                identifiedObject.analyseObject(bl2);
                this.addTreeNode(identifiedObjectDataClass);
                ++n2;
            }
        }
    }

    public IdentifiedObjectListWithSummary(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.isholder = mapProperty.getPropertyBoolean("isholder");
        this.number = mapProperty.getPropertyInt("number");
        this.min = mapProperty.getPropertyInt("min");
        this.max = mapProperty.getPropertyInt("max");
        this.mean = mapProperty.getPropertyInt("mean");
        this.median = mapProperty.getPropertyInt("median");
        this.std = mapProperty.getPropertyDouble("std");
        this.total = mapProperty.getPropertyInt("total");
        this.circumference = mapProperty.getPropertyInt("circumference");
        this.regularity = mapProperty.getPropertyDouble("regularty");
        this.d1 = mapProperty.getPropertyDouble("d1");
        this.d2 = mapProperty.getPropertyDouble("d2");
        this.roundness = mapProperty.getPropertyDouble("roundness");
        this.orientation = mapProperty.getPropertyDouble("orientation");
        this.objectName = mapProperty.getPropertyStringUTF("on");
        this.interactionCenterPoint = mapProperty.getPropertyDoubleArray("coord", null);
        this.sizeVector = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "sv");
        this.dataSet = (DataSet)mapProperty.resolveNodeFromName(randomInputStream, "dataSet");
        this.pixelarea = mapProperty.getPropertyDouble("pixelarea", 1.0);
        this.pixelunit = mapProperty.getPropertyStringUTF("pixelunit", "px");
        this.ssx = mapProperty.getPropertyDouble("ssx");
        this.areadivcirc = mapProperty.getPropertyDouble("areadivcirc");
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    @Override
    public boolean addToPopup(final Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        if (this.isholder) {
            CMenuItem cMenuItem = new CMenuItem(this, "Set pixel area", true){
                final /* synthetic */ IdentifiedObjectListWithSummary this$0;
                {
                    this.this$0 = identifiedObjectListWithSummary;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(project_GUI, "Set pixel area", this.this$0.pixelarea);
                    if (string != null) {
                        double d = NiceDataFormat.toNumber(string);
                        if (!Double.isNaN(d)) {
                            this.this$0.setSi(d, this.this$0.pixelunit);
                        } else {
                            JOptionPane.showConfirmDialog(project_GUI, "Not a valid number: " + string, "Invalid number", 1);
                        }
                    }
                }
            };
            jPopupMenu.add(cMenuItem);
            cMenuItem = new CMenuItem(this, "Set pixel unit", true){
                final /* synthetic */ IdentifiedObjectListWithSummary this$0;
                {
                    this.this$0 = identifiedObjectListWithSummary;
                    super(string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(project_GUI, "Set pixel unit", this.this$0.pixelunit);
                    if (string != null) {
                        this.this$0.setSi(this.this$0.pixelarea, string);
                    }
                }
            };
            jPopupMenu.add(cMenuItem);
            cMenuItem = new CMenuItem(this, "Delete", new ImageIcon(Main_GUI.class.getResource("gif/delete.gif"))){
                final /* synthetic */ IdentifiedObjectListWithSummary this$0;
                {
                    this.this$0 = identifiedObjectListWithSummary;
                    super(string, imageIcon);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Really delete \"" + String.valueOf(this.this$0) + "\"?", "Really delete?", 2);
                    if (n == 0) {
                        this.this$0.cleanUp();
                        if (project_GUI != null) {
                            project_GUI.purgeSignal();
                        }
                    }
                }
            };
            jPopupMenu.add(cMenuItem);
            return true;
        }
        CMenuItem cMenuItem = new CMenuItem("Select objects", true);
        cMenuItem.addActionListener(actionEvent -> {
            this.interactionGroupArray = null;
            project_GUI.doInteraction(this);
        });
        jPopupMenu.add(cMenuItem);
        return false;
    }

    public void calcDistribution(double[] dArray, double[] dArray2, IdentifiedObjectListContinuesWithSummary identifiedObjectListContinuesWithSummary, double d) {
        this.continuesClass = identifiedObjectListContinuesWithSummary;
        double[] dArray3 = identifiedObjectListContinuesWithSummary.getGridtot();
        double[] dArray4 = identifiedObjectListContinuesWithSummary.getReference_center();
        double d2 = identifiedObjectListContinuesWithSummary.getMaxdist();
        int n = dArray3.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(dArray3[i] > 0.0)) continue;
            int n3 = i;
            dArray[n3] = dArray[n3] / dArray3[i];
            ++n2;
        }
        double d3 = d;
        double d4 = 0.0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!(dArray3[i] > 0.0)) continue;
            double d5 = dArray[i];
            if (bl) {
                d4 = d5;
                bl = false;
                continue;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(dArray3[i] > 0.0)) continue;
            double d7 = dArray[i];
            d6 += d7 - d3;
        }
        this.distribution = d6 <= 0.0 ? 1.0 : d6 / ((double)n2 * (d4 - d3));
        double d8 = dArray2[0] - dArray4[0];
        double d9 = dArray2[1] - dArray4[1];
        this.balance = 1.0 - Math.sqrt(d8 * d8 + d9 * d9) / Math.sqrt(d2);
        this.balanceangle = Math.toDegrees(Math.atan2(-d9, d8));
        if (this.balanceangle < 0.0) {
            this.balanceangle += 360.0;
        }
    }

    public void calcGrid(Properties properties, IdentifiedObjectListContinuesWithSummary identifiedObjectListContinuesWithSummary, int[][] nArray) {
        if (ScriptHelper.hasKey(properties, "grid")) {
            String string = ScriptHelper.getProperty(properties, "grid");
            double[] dArray = ScriptHelper.breakIntoNumberTokens(string, "x");
            int n = (int)dArray[0] * (int)dArray[1];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[2];
            int n2 = 0;
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                int n3;
                Object object = this.getTreeNodeAt(i);
                if (!(object instanceof IdentifiedObject)) continue;
                IdentifiedObject identifiedObject = (IdentifiedObject)object;
                int n4 = 0;
                while ((double)n4 < dArray[1]) {
                    n3 = 0;
                    while ((double)n3 < dArray[0]) {
                        int n5 = (int)((double)nArray[0].length / dArray[0]) * n3;
                        int n6 = (int)((double)nArray[0].length / dArray[0]) * (n3 + 1);
                        int n7 = (int)((double)nArray.length / dArray[1]) * n4;
                        int n8 = (int)((double)nArray.length / dArray[1]) * (n4 + 1);
                        int n9 = identifiedObject.getAreaIn(n5, n6, n7, n8);
                        int n10 = n4 * (int)dArray[0] + n3;
                        dArray2[n10] = dArray2[n10] + (double)n9;
                        ++n3;
                    }
                    ++n4;
                }
                object = identifiedObject.getCenterPoint2();
                n3 = identifiedObject.getArea();
                dArray3[0] = dArray3[0] + (double)(((Pixel)object).x * n3);
                dArray3[1] = dArray3[1] + (double)(((Pixel)object).y * n3);
                n2 += n3;
            }
            if (n2 > 0) {
                dArray3[0] = dArray3[0] / (double)n2;
                dArray3[1] = dArray3[1] / (double)n2;
            }
            this.calcDistribution(dArray2, dArray3, identifiedObjectListContinuesWithSummary, 0.0);
        }
    }

    public void calculateStatistics(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, int[][] nArray, IdentifiedObjectListContinuesWithSummary identifiedObjectListContinuesWithSummary, Properties properties) {
        this.continuesClass = identifiedObjectListContinuesWithSummary;
        ArrayList<IdentifiedObjectListWithSummary> arrayList = new ArrayList<IdentifiedObjectListWithSummary>();
        if (ScriptHelper.hasKey(properties, "area")) {
            PredictionClasses predictionClasses;
            this.isholder = true;
            Object object = abstractDataMatrix.getDataInfo(0);
            Object dataTreeClass = null;
            if (abstractDataMatrix instanceof FoldMatrix) {
                DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(((FoldMatrix)abstractDataMatrix).getReferencedMatrix(), DataSet.class);
                object = dataSet.getDataInfo(0);
            }
            if ((predictionClasses = (PredictionClasses)((AbstractDataInfo)object).getGroupColumnByType(11)) == null) {
                predictionClasses = new PredictionClasses(((AbstractDataInfo)object).getRowCount());
                ((AbstractDataInfo)object).addTreeNode(predictionClasses);
            }
            InnerColumnPredClass innerColumnPredClass = predictionClasses.getPredictionClass(this, "Pred. Areas");
            ClassTypes classTypes = innerColumnPredClass.getObject();
            innerColumnPredClass.beginUpdate();
            progressManager.setInfoText("Calculating sub areas");
            int n = abstractDataMatrix.getFoldN();
            boolean bl = abstractDataMatrix instanceof FoldMatrixInterface;
            int[] nArray2 = abstractDataMatrix.getNref();
            int[] nArray3 = abstractDataMatrix.getKref();
            String string = ScriptHelper.getProperty(properties, "area");
            String[] stringArray = ScriptHelper.breakIntoTokens(string, ";");
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2;
                String[] stringArray2;
                IdentifiedObjectListWithSummary identifiedObjectListWithSummary = new IdentifiedObjectListWithSummary(this.pixelarea, this.pixelunit);
                identifiedObjectListWithSummary.isholder = false;
                identifiedObjectListWithSummary.objectName = stringArray[i];
                short s = classTypes.addString(stringArray[i]);
                for (String string2 : stringArray2 = new String[]{"size", "roundness", "orientation"}) {
                    object2 = "area" + (i + 1) + "_" + string2;
                    if (!ScriptHelper.hasKey(properties, (String)object2)) continue;
                    String string3 = ScriptHelper.getProperty(properties, (String)object2);
                    double[] dArray = ScriptHelper.breakIntoNumberTokens(string3, "-");
                    if (dArray.length == 1) {
                        dArray = new double[]{dArray[0], Double.MAX_VALUE};
                    }
                    if (string2.equalsIgnoreCase("size")) {
                        identifiedObjectListWithSummary.isize = dArray;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("roundness")) {
                        identifiedObjectListWithSummary.iroundness = dArray;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("orientation")) continue;
                    identifiedObjectListWithSummary.iorientation = dArray;
                }
                double[] dArray = identifiedObjectListWithSummary.getIsize();
                double[] dArray2 = identifiedObjectListWithSummary.getIroundness();
                double[] dArray3 = identifiedObjectListWithSummary.getIorientation();
                for (int j = this.getTreeNodeCount() - 1; j >= 0; --j) {
                    DataTreeInterface dataTreeInterface = this.getTreeNodeAt(j);
                    if (!(dataTreeInterface instanceof IdentifiedObjectDataClass)) continue;
                    object2 = (IdentifiedObjectDataClass)dataTreeInterface;
                    double d = ((IdentifiedObjectDataClass)object2).getArea();
                    IdentifiedObject identifiedObject = ((IdentifiedObjectDataClass)object2).getIdentifiedObject();
                    double d2 = identifiedObject.getRoundness() * 100.0;
                    double d3 = identifiedObject.getOrientation();
                    if (dArray != null && (!(d >= dArray[0]) || !(d < dArray[1])) || dArray2 != null && (!(d2 >= dArray2[0]) || !(d2 < dArray2[1])) || dArray3 != null && (!(d3 >= dArray3[0]) || !(d3 < dArray3[1]))) continue;
                    this.removeTreeNode((DataTreeInterface)object2);
                    identifiedObjectListWithSummary.insertTreeNode((DataTreeInterface)object2);
                    List<Pixel> list = identifiedObject.getPointList();
                    for (Pixel pixel : list) {
                        int n2 = pixel.y;
                        int n3 = pixel.x;
                        int n4 = bl ? nArray3[n3] * n + nArray2[n2] : nArray2[n3 * n + n2];
                        if (n4 < 0) continue;
                        innerColumnPredClass.setValueShort(n4, s);
                    }
                }
                identifiedObjectListWithSummary.calculateStatistics();
                this.addTreeNode(identifiedObjectListWithSummary);
                arrayList.add(identifiedObjectListWithSummary);
            }
            innerColumnPredClass.endUpdate();
            ((AbstractDataInfo)object).triggerGlobalEvent(new DataInfoClassEvent((AbstractDataInfo)object, 7, null, classTypes, 2));
        }
        arrayList.add(this);
        for (IdentifiedObjectListWithSummary identifiedObjectListWithSummary : arrayList) {
            identifiedObjectListWithSummary.calculateStatistics();
            identifiedObjectListWithSummary.calcGrid(properties, identifiedObjectListContinuesWithSummary, nArray);
        }
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.dataSet != null) {
            PredictionClasses predictionClasses;
            ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
            if (observationInfo != null && (predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11)) != null) {
                Object object = "Pred. " + String.valueOf(this);
                predictionClasses.removePredictionClass(this, (String)object);
                object = "Pred. Areas";
                predictionClasses.removePredictionClass(this, (String)object);
            }
            this.dataSet = null;
        }
        this.interactionCenterPoint = null;
        if (this.sizeVector != null) {
            this.sizeVector.cleanUp();
            this.sizeVector = null;
        }
        if (this.continuesClass != null) {
            this.continuesClass.cleanUp();
            this.continuesClass = null;
        }
        this.isize = null;
        this.iroundness = null;
        this.iorientation = null;
        this.listeners = null;
        this.interactionGroupArray = null;
    }

    @Override
    public Object clone() {
        IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)super.clone();
        identifiedObjectListWithSummary.setID(null);
        identifiedObjectListWithSummary.clear();
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof DataTreeClass)) continue;
            DataTreeClass dataTreeClass = (DataTreeClass)dataTreeInterface;
            DataTreeClass dataTreeClass2 = (DataTreeClass)dataTreeClass.clone();
            dataTreeClass2.setID(null);
            identifiedObjectListWithSummary.addTreeNode(dataTreeClass2);
        }
        return identifiedObjectListWithSummary;
    }

    public List<IdentifiedObjectDataClass> createObjectList() {
        ArrayList<IdentifiedObjectDataClass> arrayList = new ArrayList<IdentifiedObjectDataClass>();
        if (this.isholder) {
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof IdentifiedObjectListWithSummary)) continue;
                arrayList.addAll(((IdentifiedObjectListWithSummary)this.getTreeNodeAt(i)).createObjectList());
            }
        } else {
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof IdentifiedObjectDataClass)) continue;
                arrayList.add((IdentifiedObjectDataClass)this.getTreeNodeAt(i));
            }
        }
        return arrayList;
    }

    @Override
    public AbstractTModel createTableModel() {
        if (this.isholder) {
            int n = 0;
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof IdentifiedObjectListWithSummary)) continue;
                ++n;
            }
            IdentifiedObjectListWithSummary[] identifiedObjectListWithSummaryArray = new IdentifiedObjectListWithSummary[n];
            int n2 = 0;
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof IdentifiedObjectListWithSummary)) continue;
                identifiedObjectListWithSummaryArray[n2++] = (IdentifiedObjectListWithSummary)this.getTreeNodeAt(i);
            }
            return new ObjectIdentificationTableModel(identifiedObjectListWithSummaryArray);
        }
        return new ObjectIdentificationTableModel(new IdentifiedObjectListWithSummary[]{this});
    }

    public void doFinish(DataSet dataSet) {
        int n;
        this.dataSet = dataSet;
        this.mean = 0;
        this.median = 0;
        this.std = 0.0;
        this.total = 0;
        this.number = 0;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.circumference = 0;
        this.regularity = 0.0;
        this.orientation = 0.0;
        this.roundness = 0.0;
        this.distribution = 0.0;
        this.balance = 0.0;
        this.balanceangle = 0.0;
        this.ssx = 0.0;
        this.areadivcirc = 0.0;
        this.d1 = 0.0;
        this.d2 = 0.0;
        int n2 = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n = 0; n < this.getTreeNodeCount(); ++n) {
            double[] dArray;
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(n);
            if (!(dataTreeInterface instanceof IdentifiedObjectListWithSummary)) continue;
            IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)dataTreeInterface;
            if (identifiedObjectListWithSummary.isholder) {
                identifiedObjectListWithSummary.doFinish(dataSet);
            }
            int n3 = identifiedObjectListWithSummary.getNumber();
            this.number += n3;
            this.total += identifiedObjectListWithSummary.getTotal();
            if (this.min > identifiedObjectListWithSummary.getMin()) {
                this.min = identifiedObjectListWithSummary.getMin();
            }
            if (this.max < identifiedObjectListWithSummary.getMax()) {
                this.max = identifiedObjectListWithSummary.getMax();
            }
            this.mean += identifiedObjectListWithSummary.getMean() * n3;
            this.median += identifiedObjectListWithSummary.getMedian() * n3;
            this.std += identifiedObjectListWithSummary.getStd() * (double)n3;
            this.circumference += identifiedObjectListWithSummary.getCircumference() * n3;
            this.regularity += identifiedObjectListWithSummary.getRegularity() * (double)n3;
            this.d1 += identifiedObjectListWithSummary.getD1() * (double)n3;
            this.d2 += identifiedObjectListWithSummary.getD2() * (double)n3;
            this.roundness += identifiedObjectListWithSummary.getRoundness() * (double)n3;
            this.orientation += identifiedObjectListWithSummary.getOrientation() * (double)n3;
            this.distribution += identifiedObjectListWithSummary.getDistribution() * (double)n3;
            this.balance += identifiedObjectListWithSummary.getBalance() * (double)n3;
            this.balanceangle += identifiedObjectListWithSummary.getAngle() * (double)n3;
            this.ssx += identifiedObjectListWithSummary.getSsx() * (double)n3;
            this.areadivcirc += identifiedObjectListWithSummary.getAreadivcirc() * (double)n3;
            n2 += n3;
            for (double d : dArray = identifiedObjectListWithSummary.getInteractionCenterPoint()) {
                arrayList.add(d);
            }
        }
        if (n2 > 0) {
            this.mean /= n2;
            this.median /= n2;
            this.std /= (double)n2;
            this.circumference /= n2;
            this.regularity /= (double)n2;
            this.d1 /= (double)n2;
            this.d2 /= (double)n2;
            this.roundness /= (double)n2;
            this.orientation /= (double)n2;
            this.distribution /= (double)n2;
            this.balance /= (double)n2;
            this.balanceangle /= (double)n2;
            this.ssx /= (double)n2;
            this.areadivcirc /= (double)n2;
        }
        this.interactionCenterPoint = new double[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.interactionCenterPoint[n] = (Double)arrayList.get(n);
        }
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void doInteractionGroup(InteractionArray interactionArray) {
        this.interactionGroupArray = interactionArray;
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null) {
            project_GUI.doInteraction(this);
        }
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    @Override
    public void finishInteraction() {
    }

    @Override
    public Object get(String string) throws Exception {
        return this.get(string, null);
    }

    public Object get(String string, Properties properties) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "unit")) {
                bl = ScriptHelper.getPropertyBool(properties, "unit");
            }
            if (ScriptHelper.hasKey(properties, "relative")) {
                bl2 = ScriptHelper.getPropertyBool(properties, "relative");
            }
        }
        if (string.equalsIgnoreCase("name")) {
            return this.objectName;
        }
        if (string.equalsIgnoreCase("dataset")) {
            return DataTreeManager.getAncestorNull(this, DataSet.class);
        }
        if (string.equalsIgnoreCase("area_all")) {
            return this.getArea(this.continuesClass.getArea(), properties);
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getDistance(this.continuesClass.getXabs(), properties);
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getDistance(this.continuesClass.getYabs(), properties);
        }
        if (string.equalsIgnoreCase("number")) {
            if (bl2 && this.continuesClass != null) {
                return NiceDataFormat.toString((double)this.number / (double)this.continuesClass.getArea());
            }
            return NiceDataFormat.toString(this.number);
        }
        if (string.equalsIgnoreCase("min")) {
            return this.getArea(this.min, properties);
        }
        if (string.equalsIgnoreCase("max")) {
            return this.getArea(this.max, properties);
        }
        if (string.equalsIgnoreCase("mean")) {
            return this.getArea(this.mean, properties);
        }
        if (string.equalsIgnoreCase("median")) {
            return this.getArea(this.median, properties);
        }
        if (string.equalsIgnoreCase("std")) {
            if (bl2 && this.continuesClass != null) {
                return NiceDataFormat.toString(this.std / (double)this.continuesClass.getArea());
            }
            return NiceDataFormat.toString(this.std);
        }
        if (string.equalsIgnoreCase("total")) {
            return this.getArea(this.total, properties);
        }
        if (string.equalsIgnoreCase("circumference")) {
            return this.getDistance(this.circumference, properties);
        }
        if (string.equalsIgnoreCase("regularity")) {
            return NiceDataFormat.toPercent(this.regularity, bl);
        }
        if (string.equalsIgnoreCase("d1")) {
            return this.getDistance(this.d1, properties);
        }
        if (string.equalsIgnoreCase("d2")) {
            return this.getDistance(this.d2, properties);
        }
        if (string.equalsIgnoreCase("distribution")) {
            return NiceDataFormat.toString(this.distribution);
        }
        if (string.equalsIgnoreCase("balance")) {
            return NiceDataFormat.toString(this.balance);
        }
        if (string.equalsIgnoreCase("angle")) {
            return ObjectIdentificationHelper.toDirection(this.balanceangle, this.balance);
        }
        if (string.equalsIgnoreCase("roundness")) {
            return NiceDataFormat.toPercent(this.roundness, bl);
        }
        if (string.equalsIgnoreCase("orientation")) {
            return NiceDataFormat.toString(this.orientation, 3);
        }
        if (string.equalsIgnoreCase("centrumindex")) {
            return this.interactionCenterPoint;
        }
        if (string.equalsIgnoreCase("ssx")) {
            return this.ssx;
        }
        if (string.equalsIgnoreCase("areadivcirc")) {
            return NiceDataFormat.toPercent(this.areadivcirc, bl);
        }
        if (string.equalsIgnoreCase("pixels")) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            List<IdentifiedObjectDataClass> list = this.createObjectList();
            for (IdentifiedObjectDataClass identifiedObjectDataClass : list) {
                int[] nArray;
                for (int n : nArray = identifiedObjectDataClass.getInteractionArray()) {
                    arrayList.add((double)n + 1.0);
                }
            }
            Double[] doubleArray = new Double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                doubleArray[i] = (Double)arrayList.get(i);
            }
            return doubleArray;
        }
        if (string.equalsIgnoreCase("objects")) {
            return this.getObjects();
        }
        if (string.equalsIgnoreCase("summary") || string.equalsIgnoreCase("summary_short")) {
            boolean bl3 = string.equalsIgnoreCase("summary_short");
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl4 = true;
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof IdentifiedObjectListWithSummary)) continue;
                IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)dataTreeInterface;
                if (!bl3 && stringBuilder.length() != 0) {
                    stringBuilder.append("\n");
                }
                if (bl3 && !bl4) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(identifiedObjectListWithSummary.getNumber());
                if (!bl3) {
                    stringBuilder.append(" x ");
                    stringBuilder.append(identifiedObjectListWithSummary.getObjectName());
                }
                bl4 = false;
            }
            return stringBuilder.toString();
        }
        if (string.startsWith("areanames")) {
            StringBuilder stringBuilder = new StringBuilder();
            IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)this.getTreeNodeAt(0);
            int n = 0;
            for (int i = 0; i < identifiedObjectListWithSummary.getTreeNodeCount(); ++i) {
                if (!(identifiedObjectListWithSummary.getTreeNodeAt(i) instanceof IdentifiedObjectListWithSummary)) continue;
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("area" + (n + 1));
                ++n;
            }
            return stringBuilder.toString();
        }
        if (string.startsWith("area")) {
            IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)this.getTreeNodeAt(0);
            int n = (int)NiceDataFormat.toNumber(string.substring(4));
            int n2 = 1;
            for (int i = 0; i < identifiedObjectListWithSummary.getTreeNodeCount(); ++i) {
                if (!(identifiedObjectListWithSummary.getTreeNodeAt(i) instanceof IdentifiedObjectListWithSummary) || n2++ != n) continue;
                return identifiedObjectListWithSummary.getTreeNodeAt(i);
            }
            return identifiedObjectListWithSummary;
        }
        if (string.equals("continues")) {
            return this.continuesClass;
        }
        return super.get(string);
    }

    public IdentifiedObjectDataClass[] getObjects() {
        List<IdentifiedObjectDataClass> list = this.createObjectList();
        return list.toArray(new IdentifiedObjectDataClass[list.size()]);
    }

    public double getAngle() {
        return this.balanceangle;
    }

    public String getArea(double d) {
        return this.getSIunit(d, null, true);
    }

    public String getArea(double d, Properties properties) {
        return this.getSIunit(d, properties, true);
    }

    public double getAreadivcirc() {
        return this.areadivcirc;
    }

    public double getBalance() {
        return this.balance;
    }

    public int getCircumference() {
        return this.circumference;
    }

    public IdentifiedObjectListContinuesWithSummary getContinuesClass() {
        return this.continuesClass;
    }

    public double getD1() {
        return this.d1;
    }

    public double getD2() {
        return this.d2;
    }

    public String getDistance(double d) {
        return this.getSIunit(d, null, false);
    }

    public String getDistance(double d, Properties properties) {
        return this.getSIunit(d, properties, false);
    }

    public double getDistribution() {
        return this.distribution;
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public int getGroupID() {
        return 1;
    }

    public int getHeight() {
        if (this.continuesClass != null) {
            return this.continuesClass.getYabs();
        }
        return 0;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD><B>Objects:</B></TD><TD>");
        stringBuilder.append("<TR><TD>No. object:</TD><TD>").append(this.number).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Min area:</TD><TD>").append(this.getArea(this.min)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Max area:</TD><TD>").append(this.getArea(this.max)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Mean area:</TD><TD>").append(this.getArea(this.mean)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Median area:</TD><TD>").append(this.getArea(this.median)).append("</TD></TR>");
        String string = "N/A";
        if (!Double.isNaN(this.std)) {
            string = NiceDataFormat.toString(this.std);
        }
        stringBuilder.append("<TR><TD>Std:</TD><TD>").append(string).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Total area:</TD><TD>").append(this.getArea(this.total)).append("</TD></TR>");
        if (this.interactionCenterPoint != null && this.interactionCenterPoint.length == 2) {
            stringBuilder.append("<TR><TD>Center point:</TD><TD>").append(this.interactionCenterPoint[0] + ", " + this.interactionCenterPoint[1]).append("</TD></TR>");
        }
        stringBuilder.append("<TR><TD>D1:</TD><TD>").append(this.getDistance(this.d1)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>D2:</TD><TD>").append(this.getDistance(this.d2)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Circumference:</TD><TD>").append(this.getDistance(this.circumference)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Regularity:</TD><TD>").append(NiceDataFormat.toPercent(this.regularity)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Roundness:</TD><TD>").append(NiceDataFormat.toPercent(this.roundness)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Orientation:</TD><TD>").append(NiceDataFormat.toString(this.orientation, 3)).append(" degrees</TD></TR>");
        stringBuilder.append("<TR><TD>Distribution:</TD><TD>").append(NiceDataFormat.toPercent(this.distribution)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Balance:</TD><TD>").append(NiceDataFormat.toPercent(this.balance)).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Direction:</TD><TD>").append(ObjectIdentificationHelper.toDirection(this.balanceangle, this.balance)).append("</TD></TR>");
        stringBuilder.append("</BODY></HTML>");
        return stringBuilder.toString();
    }

    public double[] getInteractionCenterPoint() {
        return this.interactionCenterPoint;
    }

    public double[] getIorientation() {
        return this.iorientation;
    }

    public double[] getIroundness() {
        return this.iroundness;
    }

    public double[] getIsize() {
        return this.isize;
    }

    public int getMax() {
        return this.max;
    }

    public int getMean() {
        return this.mean;
    }

    public int getMedian() {
        return this.median;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    public int getNumber() {
        return this.number;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public double getPixelarea() {
        return this.pixelarea;
    }

    public String getPixelunit() {
        return this.pixelunit;
    }

    public double getRegularity() {
        return this.regularity;
    }

    public double getRoundness() {
        return this.roundness;
    }

    public String getSIunit(double d, Properties properties, boolean bl) {
        Case case_;
        boolean bl2 = true;
        boolean bl3 = false;
        if (properties != null) {
            try {
                if (ScriptHelper.hasKey(properties, "unit")) {
                    bl2 = ScriptHelper.getPropertyBool(properties, "unit");
                }
                if (ScriptHelper.hasKey(properties, "relative")) {
                    bl3 = ScriptHelper.getPropertyBool(properties, "relative");
                }
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        if (bl3 && this.continuesClass != null) {
            d /= (double)this.continuesClass.getArea();
        }
        if ((case_ = this.getCase()) != null) {
            if (bl2) {
                if (bl3) {
                    return case_.getSIunit(d, this.pixelarea, "%", false);
                }
                return case_.getSIunit(d, this.pixelarea, this.pixelunit, bl);
            }
            return case_.getSIunit(d, this.pixelarea, null, bl);
        }
        return String.valueOf(d);
    }

    public DataTreeInterface getSizeVector() {
        return this.sizeVector;
    }

    public double getSsx() {
        return this.ssx;
    }

    public double getStd() {
        return this.std;
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public byte getTreeType() {
        return 9;
    }

    public int getWidth() {
        if (this.continuesClass != null) {
            return this.continuesClass.getXabs();
        }
        return 0;
    }

    @Override
    public void prepareInteraction() {
        int n = 0;
        List<IdentifiedObjectDataClass> list = this.createObjectList();
        for (IdentifiedObjectDataClass basicTreeInterface2 : list) {
            if (n >= basicTreeInterface2.getInteractionSize()) continue;
            n = basicTreeInterface2.getInteractionSize();
        }
        Project_GUI project_GUI = this.getProject_GUI();
        InteractionArray interactionArray = project_GUI.getInteractionArray(this.getCase(), 1, n, 0);
        int n2 = 0;
        for (IdentifiedObjectDataClass identifiedObjectDataClass : list) {
            if (this.interactionGroupArray == null || n2 <= this.interactionGroupArray.getLastSet() && this.interactionGroupArray.get(n2)) {
                int[] nArray;
                for (int n3 : nArray = identifiedObjectDataClass.getInteractionArray()) {
                    interactionArray.set(n3);
                }
            }
            ++n2;
        }
        this.interactionGroupArray = null;
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners != null) {
            this.listeners.remove(modelListener);
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyBoolean("isholder", this.isholder);
        randomOutputStream.writePropertyInt("number", this.number);
        randomOutputStream.writePropertyInt("min", this.min);
        randomOutputStream.writePropertyInt("max", this.max);
        randomOutputStream.writePropertyInt("mean", this.mean);
        randomOutputStream.writePropertyInt("median", this.median);
        randomOutputStream.writePropertyDouble("std", this.std);
        randomOutputStream.writePropertyInt("total", this.total);
        randomOutputStream.writePropertyInt("circumference", this.circumference);
        randomOutputStream.writePropertyDouble("regularty", this.regularity);
        randomOutputStream.writePropertyDouble("d1", this.d1);
        randomOutputStream.writePropertyDouble("d2", this.d2);
        randomOutputStream.writePropertyDouble("roundness", this.roundness);
        randomOutputStream.writePropertyDouble("orientation", this.orientation);
        randomOutputStream.writePropertyStringUTF("on", this.objectName);
        randomOutputStream.writePropertyDoubleArray("coord", this.interactionCenterPoint);
        randomOutputStream.writePropertyNode("sv", this.sizeVector);
        randomOutputStream.writePropertyNode("dataSet", this.dataSet);
        randomOutputStream.writePropertyDouble("pixelarea", this.pixelarea);
        randomOutputStream.writePropertyStringUTF("pixelunit", this.pixelunit);
        randomOutputStream.writePropertyDouble("ssx", this.ssx);
        randomOutputStream.writePropertyDouble("areadivcirc", this.areadivcirc);
    }

    public void setCountContinuesClass(IdentifiedObjectListContinuesWithSummary identifiedObjectListContinuesWithSummary) {
        this.continuesClass = identifiedObjectListContinuesWithSummary;
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public void setPixelarea(double d) {
        this.pixelarea = d;
    }

    public void setPixelunit(String string) {
        this.pixelunit = string;
    }

    public void setSi(double d, String string) {
        this.pixelarea = d;
        this.pixelunit = string;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof IdentifiedObjectListWithSummary)) continue;
            IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)dataTreeInterface;
            identifiedObjectListWithSummary.setSi(d, string);
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (!this.isholder) {
            return string + " (" + this.objectName + ")";
        }
        return string;
    }

    private void calculateStatistics() {
        this.mean = 0;
        this.median = 0;
        this.std = 0.0;
        this.total = 0;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.circumference = 0;
        this.regularity = 0.0;
        this.roundness = 0.0;
        this.orientation = 0.0;
        this.ssx = 0.0;
        this.areadivcirc = 0.0;
        this.d1 = 0.0;
        this.d2 = 0.0;
        List<IdentifiedObjectDataClass> list = this.createObjectList();
        Collections.sort(list, (identifiedObjectDataClass, identifiedObjectDataClass2) -> Double.compare(identifiedObjectDataClass.getArea(), identifiedObjectDataClass2.getArea()));
        this.interactionCenterPoint = new double[list.size()];
        int n = 0;
        for (IdentifiedObjectDataClass identifiedObjectDataClass3 : list) {
            int n2 = identifiedObjectDataClass3.getArea();
            this.mean += n2;
            this.total += n2;
            if (this.min > n2) {
                this.min = n2;
            }
            if (this.max < n2) {
                this.max = n2;
            }
            IdentifiedObject identifiedObject = identifiedObjectDataClass3.getIdentifiedObject();
            this.circumference += identifiedObject.getCircumference();
            this.regularity += identifiedObject.getRegularity();
            this.d1 += identifiedObject.getD1();
            this.d2 += identifiedObject.getD2();
            this.roundness += identifiedObject.getRoundness();
            this.orientation += identifiedObject.getOrientation();
            this.ssx += identifiedObject.getSsx();
            this.areadivcirc += identifiedObject.getAreadivcirc();
            this.interactionCenterPoint[n] = identifiedObjectDataClass3.getInteractionCenterPoint();
            ++n;
        }
        this.number = list.size();
        if (this.number > 0) {
            this.mean /= this.number;
            this.median = list.get(this.number / 2).getArea();
            this.circumference /= this.number;
            this.regularity /= (double)this.number;
            this.d1 /= (double)this.number;
            this.d2 /= (double)this.number;
            this.roundness /= (double)this.number;
            this.orientation /= (double)this.number;
            this.ssx /= (double)this.number;
            this.areadivcirc /= (double)this.number;
            for (IdentifiedObjectDataClass identifiedObjectDataClass3 : list) {
                double d = identifiedObjectDataClass3.getArea() - this.mean;
                this.std += d * d;
                ++n;
            }
            if (this.std > 0.0) {
                this.std = Math.sqrt(this.std / (double)(this.number - 1));
            }
        }
    }
}

