/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.algorithm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.image.count.algorithm.IdentifiedObjectListContinuesWithSummary;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.image.process.ImageProcessMatrix;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.dataimport.breeze.image.count.ObjectIdentificationHelper;
import se.prediktera.map.dataimport.image.Pixel;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrixInterface;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixInterface;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.register.RegisterKeyManager;

public class ObjectIdentificationAlgorithm {
    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0}};
        MVmatrix mVmatrix = new MVmatrix(dArrayArray, dArrayArray.length, dArrayArray[0].length);
        ObjectIdentificationHelper.calculateDistance(mVmatrix, 9, 9);
        try {
            LinkedList<IdentifiedObject> linkedList = ObjectIdentificationAlgorithm.identifyAreas(mVmatrix, new Properties());
            ObjectIdentificationHelper.printMatrix(mVmatrix);
            System.out.println("");
            for (IdentifiedObject identifiedObject : linkedList) {
                Pixel pixel = identifiedObject.getCenterPoint2();
                System.out.println(pixel.x + ", " + pixel.y + ", " + identifiedObject.getMax());
                System.out.println("Area: " + identifiedObject.getArea());
                System.out.println("Roundness: " + identifiedObject.getRoundness());
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)objectArray[0];
        return ObjectIdentificationAlgorithm.performAnalysis(progressManager, abstractDataMatrix, properties);
    }

    public static IdentifiedObjectListWithSummary performAnalysis(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, Properties properties) {
        Object object;
        boolean bl = false;
        if (!(abstractDataMatrix instanceof FoldMatrixInterface) && abstractDataMatrix.isFoldable()) {
            abstractDataMatrix = new FoldMatrix(abstractDataMatrix);
            if (ScriptHelper.hasKey(properties, "index")) {
                ((FoldMatrix)abstractDataMatrix).setFold((int)(ScriptHelper.getPropertyDouble(properties, "index") - 1.0));
            }
            bl = true;
        }
        double d = 1.0;
        String string = "px";
        double d2 = -2.147483647E9;
        double d3 = 2.147483647E9;
        if (ScriptHelper.hasKey(properties, "pixelarea")) {
            d = ScriptHelper.getPropertyDouble(properties, "pixelarea");
        }
        if (ScriptHelper.hasKey(properties, "pixelunit")) {
            string = ScriptHelper.getProperty(properties, "pixelunit");
        }
        List<MVmatrix> list = null;
        if (ScriptHelper.hasKey(properties, "distancematrix")) {
            list = new ArrayList<MVmatrix>();
            list.add((MVmatrix)abstractDataMatrix);
        } else if (ScriptHelper.hasKey(properties, "category") || ScriptHelper.hasKey(properties, "predcategory")) {
            String string2;
            boolean bl2 = false;
            if (ScriptHelper.hasKey(properties, "category")) {
                string2 = ScriptHelper.getProperty(properties, "category");
            } else {
                string2 = ScriptHelper.getProperty(properties, "predcategory");
                bl2 = true;
            }
            String string3 = null;
            if (ScriptHelper.hasKey(properties, "type")) {
                string3 = ScriptHelper.getProperty(properties, "type");
            }
            list = ObjectIdentificationAlgorithm.createBinaryMatrixFromClass(abstractDataMatrix, bl2, string2, string3);
        } else if (ScriptHelper.hasKey(properties, "threshold") || ScriptHelper.hasKey(properties, "minthreshold") || ScriptHelper.hasKey(properties, "minthresholdpercent")) {
            double d4;
            double d5 = 0.0;
            if (ScriptHelper.hasKey(properties, "threshold")) {
                d4 = ScriptHelper.getPropertyDouble(properties, "threshold");
            } else if (ScriptHelper.hasKey(properties, "minthresholdpercent")) {
                d5 = ScriptHelper.getPropertyDouble(properties, "minthresholdpercent");
                d4 = ScriptHelper.getPropertyDouble(properties, "maxthresholdpercent");
                object = abstractDataMatrix.calculateMinMax();
                if (object != null) {
                    d5 = d5 / 100.0 * (object[1] - object[0]) + object[0];
                    d4 = d4 / 100.0 * (object[1] - object[0]) + object[0];
                }
            } else {
                d5 = ScriptHelper.getPropertyDouble(properties, "minthreshold");
                d4 = ScriptHelper.getPropertyDouble(properties, "maxthreshold");
            }
            list = ObjectIdentificationAlgorithm.createBinaryMatrixFromThreshold(abstractDataMatrix, d5, d4);
        } else if (ScriptHelper.hasKey(properties, "continues")) {
            list = new ArrayList();
            if (ScriptHelper.hasKey(properties, "ymin")) {
                d2 = ScriptHelper.getPropertyDouble(properties, "ymin");
            }
            if (ScriptHelper.hasKey(properties, "ymax")) {
                d3 = ScriptHelper.getPropertyDouble(properties, "ymax");
            }
        } else if (ScriptHelper.hasKey(properties, "process")) {
            list = ObjectIdentificationAlgorithm.createBinaryMatrixFromProcess(progressManager, abstractDataMatrix, properties);
        }
        if (list == null) {
            throw new RuntimeException("Incomplete properties");
        }
        IdentifiedObjectListWithSummary identifiedObjectListWithSummary = new IdentifiedObjectListWithSummary(d, string);
        IdentifiedObjectListContinuesWithSummary identifiedObjectListContinuesWithSummary = ObjectIdentificationAlgorithm.calculateContinues(abstractDataMatrix, properties, d2, d3, d, string);
        identifiedObjectListWithSummary.setCountContinuesClass(identifiedObjectListContinuesWithSummary);
        progressManager.setInfoText("Performing object identification");
        for (MVmatrix mVmatrix : list) {
            object = null;
            object = ScriptHelper.hasKey(properties, "blob") && ScriptHelper.getPropertyBool(properties, "blob") ? (Object)ObjectIdentificationAlgorithm.identifyBlobs(mVmatrix, properties) : (Object)ObjectIdentificationAlgorithm.identifyAreas(mVmatrix, properties);
            boolean bl3 = abstractDataMatrix instanceof FoldMatrixInterface;
            boolean bl4 = true;
            if (ScriptHelper.hasKey(properties, "rotateobject")) {
                bl4 = ScriptHelper.getPropertyBool(properties, "rotateobject");
            }
            IdentifiedObjectListWithSummary identifiedObjectListWithSummary2 = new IdentifiedObjectListWithSummary(d, string, (List<IdentifiedObject>)object, bl3, abstractDataMatrix.getNref(), abstractDataMatrix.getKref(), abstractDataMatrix.getFoldN(), bl4);
            identifiedObjectListWithSummary2.calculateStatistics(progressManager, abstractDataMatrix, ObjectIdentificationHelper.idMatrix, identifiedObjectListContinuesWithSummary, properties);
            identifiedObjectListWithSummary2.setObjectName(mVmatrix.toString());
            mVmatrix.setName("Distance matrix");
            mVmatrix.setVisibleInTree(RegisterKeyManager.isPredikteraDevelopmentLicense());
            identifiedObjectListWithSummary2.addTreeNode(mVmatrix);
            identifiedObjectListWithSummary.add(identifiedObjectListWithSummary2);
        }
        identifiedObjectListWithSummary.doFinish((DataSet)DataTreeManager.getAncestorNull(abstractDataMatrix, DataSet.class));
        if (ScriptHelper.hasKey(properties, "createclass")) {
            ObjectIdentificationAlgorithm.createClassFromIdMatrix(progressManager, abstractDataMatrix, ObjectIdentificationHelper.idMatrix);
        }
        if (bl) {
            abstractDataMatrix.cleanUp();
        }
        return identifiedObjectListWithSummary;
    }

    public static LinkedList<IdentifiedObject> identifyBlobs(MatrixInterface matrixInterface, Properties properties) {
        double d = 0.2;
        if (ScriptHelper.hasKey(properties, "ratio")) {
            d = ScriptHelper.getPropertyDouble(properties, "ratio");
        }
        int n = 0;
        if (ScriptHelper.hasKey(properties, "minarea")) {
            n = ScriptHelper.getPropertyInt(properties, "minarea");
        }
        return ObjectIdentificationHelper.identifyBlobs(matrixInterface, d, n);
    }

    public static LinkedList<IdentifiedObject> identifyAreas(MatrixInterface matrixInterface, Properties properties) {
        int n = 0;
        if (ScriptHelper.hasKey(properties, "shrink")) {
            n = ScriptHelper.getPropertyInt(properties, "shrink");
        }
        int n2 = 0;
        if (ScriptHelper.hasKey(properties, "minarea")) {
            n2 = ScriptHelper.getPropertyInt(properties, "minarea");
        }
        return ObjectIdentificationHelper.identifyAreas(matrixInterface, n, n2);
    }

    public static IdentifiedObjectListContinuesWithSummary calculateContinues(AbstractDataMatrix abstractDataMatrix, Properties properties, double d, double d2, double d3, String string) {
        if (ScriptHelper.hasKey(properties, "grid")) {
            String string2 = ScriptHelper.getProperty(properties, "grid");
            double[] dArray = ScriptHelper.breakIntoNumberTokens(string2, "x");
            int n = (int)dArray[0] * (int)dArray[1];
            int n2 = abstractDataMatrix.getK();
            int n3 = abstractDataMatrix.getN();
            int n4 = (int)((double)n2 / dArray[0]);
            int n5 = (int)((double)n3 / dArray[1]);
            int n6 = Integer.MAX_VALUE;
            int n7 = 0;
            int n8 = Integer.MAX_VALUE;
            int n9 = 0;
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (n5 > 0 && n4 > 0) {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n13;
                        int n14 = (int)Math.min((double)(i / n5), dArray[1] - 1.0);
                        int n15 = (int)Math.min((double)(j / n4), dArray[0] - 1.0);
                        if (abstractDataMatrix.isMissing(i, j)) continue;
                        int n16 = n13 = n14 * (int)dArray[1] + n15;
                        dArray2[n16] = dArray2[n16] + ObjectIdentificationAlgorithm.getMatrixValue(abstractDataMatrix, i, j, d, d2);
                        n10 += j;
                        n11 += i;
                        int n17 = n13;
                        dArray3[n17] = dArray3[n17] + 1.0;
                        ++n12;
                        if (j < n6) {
                            n6 = j;
                        }
                        if (j > n7) {
                            n7 = j;
                        }
                        if (i < n8) {
                            n8 = i;
                        }
                        if (i <= n9) continue;
                        n9 = i;
                    }
                }
            }
            double[] dArray4 = new double[]{0.0, 0.0};
            if (n12 > 0) {
                dArray4 = new double[]{n10 / n12, n11 / n12};
            }
            double[] dArray5 = new double[2];
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = d != -2.147483647E9 ? d : 0.0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d8;
                    if (abstractDataMatrix.isMissing(i, j)) continue;
                    double d9 = ObjectIdentificationAlgorithm.getMatrixValue(abstractDataMatrix, i, j, d, d2) - d7;
                    double d10 = (double)j - dArray4[0];
                    double d11 = (double)i - dArray4[1];
                    double d12 = d10 * d10 + d11 * d11;
                    if (d12 > d5) {
                        d5 = d12;
                    }
                    if ((d8 = (d10 *= d9) * d10 + (d11 *= d9) * d11) > d6) {
                        d6 = d8;
                    }
                    dArray5[0] = dArray5[0] + d10;
                    dArray5[1] = dArray5[1] + d11;
                    d4 += d9;
                }
            }
            dArray5[0] = dArray4[0] + dArray5[0] / d4;
            dArray5[1] = dArray4[1] + dArray5[1] / d4;
            IdentifiedObjectListContinuesWithSummary identifiedObjectListContinuesWithSummary = new IdentifiedObjectListContinuesWithSummary(d3, string);
            identifiedObjectListContinuesWithSummary.setReference_center(dArray4);
            identifiedObjectListContinuesWithSummary.setDimensions(n12, n6, n7, n8, n9);
            identifiedObjectListContinuesWithSummary.setGridtot(dArray3);
            identifiedObjectListContinuesWithSummary.setMaxdist(d5);
            identifiedObjectListContinuesWithSummary.setMaxdistneg(d6);
            identifiedObjectListContinuesWithSummary.calcDistribution(dArray2, dArray5, identifiedObjectListContinuesWithSummary, d7);
            return identifiedObjectListContinuesWithSummary;
        }
        return null;
    }

    private static double getMatrixValue(AbstractDataMatrix abstractDataMatrix, int n, int n2, double d, double d2) {
        double d3 = abstractDataMatrix.getValue(n, n2);
        if (d3 < d) {
            return d;
        }
        if (d3 > d2) {
            return d2;
        }
        return d3;
    }

    public static void createClassFromIdMatrix(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, int[][] nArray) {
        AbstractDataInfo abstractDataInfo = abstractDataMatrix.getDataInfo(0);
        DataSet dataSet = null;
        if (abstractDataMatrix instanceof FoldMatrix) {
            dataSet = (DataSet)DataTreeManager.getAncestorNull(((FoldMatrix)abstractDataMatrix).getReferencedMatrix(), DataSet.class);
            abstractDataInfo = dataSet.getDataInfo(0);
        }
        Category category = (Category)dataSet.createModification(progressManager, "obs", "category");
        category.setLayerName(DataTreeManager.getUniqueName(category.getTreeParent(), "Cluster"));
        InnerColumnClass innerColumnClass = category.getInnerColumn();
        ClassTypes classTypes = innerColumnClass.getObject();
        innerColumnClass.beginUpdate();
        short s = classTypes.addString("Objects");
        progressManager.setInfoText("Calculating clusters");
        int n = abstractDataMatrix.getFoldN();
        boolean bl = abstractDataMatrix instanceof FoldMatrix;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int[] nArray2 = abstractDataMatrix.getNref();
        int[] nArray3 = abstractDataMatrix.getKref();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (nArray[i][j] <= 0) continue;
                int n4 = bl ? nArray3[j] * n + nArray2[i] : nArray2[j * n + i];
                innerColumnClass.setValueShort(n4, s);
            }
        }
        innerColumnClass.endUpdate();
        category.updateClasses();
        abstractDataInfo.triggerGlobalEvent(new DataInfoEvent(abstractDataInfo, 0, category));
    }

    public static List<MVmatrix> createBinaryMatrixFromThreshold(AbstractDataMatrix abstractDataMatrix, double d, double d2) {
        boolean bl;
        int n = abstractDataMatrix.getFoldN();
        boolean bl2 = false;
        boolean bl3 = bl = abstractDataMatrix instanceof FoldMatrixInterface || n <= 0;
        if (!bl) {
            abstractDataMatrix = new FoldMatrix(abstractDataMatrix);
            bl2 = true;
            bl = true;
        }
        int n2 = abstractDataMatrix.getN();
        String string = "Threshold " + NiceDataFormat.toString(d, 4) + "-" + NiceDataFormat.toString(d2, 4);
        MVmatrix mVmatrix = bl ? new MVmatrix(abstractDataMatrix.getN(), abstractDataMatrix.getK(), string) : new MVmatrix(n, n2 / n, string);
        int n3 = mVmatrix.getN();
        int n4 = mVmatrix.getK();
        Matrix matrix = mVmatrix.getInternalMatrixPublic();
        abstractDataMatrix.beginCalculations();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                double d3;
                if (bl) {
                    d3 = abstractDataMatrix.getValue(i, j);
                } else {
                    int n5 = j * n + i;
                    d3 = abstractDataMatrix.getValue(n5, 0);
                }
                if (abstractDataMatrix.isMissing(i, j) || !(d3 >= d) || !(d3 <= d2)) continue;
                matrix.set(i, j, 1.0);
            }
        }
        abstractDataMatrix.endCalculations();
        ArrayList<MVmatrix> arrayList = new ArrayList<MVmatrix>();
        arrayList.add(mVmatrix);
        if (bl2) {
            abstractDataMatrix.cleanUp();
        }
        return arrayList;
    }

    public static List<MVmatrix> createBinaryMatrixFromProcess(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, Properties properties) {
        if (!ScriptHelper.hasKey(properties, "variablename")) {
            properties.put("variablename", "1203");
        }
        ImageProcessMatrix imageProcessMatrix = ImageProcessMatrix.processImage(progressManager, abstractDataMatrix, (byte)3, 0.0, 5, properties);
        ImageProcessMatrix imageProcessMatrix2 = ImageProcessMatrix.processImage(progressManager, imageProcessMatrix, (byte)4, 0.0, 7, null);
        ImageProcessMatrix imageProcessMatrix3 = ImageProcessMatrix.processImage(progressManager, imageProcessMatrix2, (byte)5, 0.07, 0, null);
        ImageProcessMatrix imageProcessMatrix4 = ImageProcessMatrix.processImage(progressManager, imageProcessMatrix3, (byte)8, 0.0, 0, null);
        MVmatrix mVmatrix = new MVmatrix(imageProcessMatrix4.getN(), imageProcessMatrix4.getK());
        for (int i = 0; i < imageProcessMatrix4.getN(); ++i) {
            for (int j = 0; j < imageProcessMatrix4.getK(); ++j) {
                mVmatrix.setValue(i, j, imageProcessMatrix4.isMissing(i, j) ? 0.0 : 1.0);
            }
        }
        ArrayList<MVmatrix> arrayList = new ArrayList<MVmatrix>();
        arrayList.add(mVmatrix);
        return arrayList;
    }

    public static List<MVmatrix> createBinaryMatrixFromClass(AbstractDataMatrix abstractDataMatrix, boolean bl, String string, String string2) {
        int n;
        ArrayList arrayList;
        Cloneable cloneable;
        AbstractDataInfo abstractDataInfo = abstractDataMatrix.getDataInfo(0);
        if (abstractDataMatrix instanceof FoldMatrix) {
            cloneable = (DataSet)DataTreeManager.getAncestorNull(((FoldMatrix)abstractDataMatrix).getReferencedMatrix(), DataSet.class);
            abstractDataInfo = ((DataSet)cloneable).getDataInfo(0);
        }
        cloneable = null;
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)abstractDataInfo.getGroupColumnByType(1).getPrimaryColumn();
        if (bl) {
            arrayList = (PredictionClasses)abstractDataInfo.getGroupColumnByType(11);
            if (arrayList == null) {
                throw new RuntimeException("No prediction category for matrix");
            }
            cloneable = (InnerColumnClass)((DataGroupValues)arrayList).getInnerColumnByName(string);
        } else {
            arrayList = (Transformations)abstractDataInfo.getGroupColumnByType(10);
            int n2 = ((Transformations)arrayList).getColumnCount();
            for (n = 0; n < n2; ++n) {
                if (((Transformations)arrayList).getColumnType(n) != 4 || !((Transformations)arrayList).getInnerColumn(n).toString().equals(string)) continue;
                cloneable = (InnerColumnClass)((Transformations)arrayList).getInnerColumn(n);
                break;
            }
        }
        if (cloneable == null) {
            throw new RuntimeException("No such category name: " + string);
        }
        arrayList = new ArrayList();
        ClassTypes classTypes = ((InnerColumnClass)cloneable).getObject();
        if (string2 != null) {
            n = classTypes.getTypeDescriptionIndex(string2);
            if (n < 0) {
                throw new RuntimeException("No such class type: " + string2);
            }
            arrayList.add(ObjectIdentificationAlgorithm.createDistanceMatrix(abstractDataMatrix, innerColumnBoolean, (InnerColumnClass)cloneable, (short)n, string2));
        } else {
            for (n = 0; n < classTypes.size(); n = (short)(n + 1)) {
                if (classTypes.getTypeDescription(n).equals("-")) continue;
                arrayList.add(ObjectIdentificationAlgorithm.createDistanceMatrix(abstractDataMatrix, innerColumnBoolean, (InnerColumnClass)cloneable, (short)n, classTypes.getTypeDescription(n)));
            }
        }
        return arrayList;
    }

    private static MVmatrix createDistanceMatrix(AbstractDataMatrix abstractDataMatrix, InnerColumnBoolean innerColumnBoolean, InnerColumnClass innerColumnClass, short s, String string) {
        boolean bl = abstractDataMatrix instanceof FoldMatrix;
        int n = abstractDataMatrix.getFoldN();
        int n2 = innerColumnClass.getSize();
        MVmatrix mVmatrix = bl || n <= 0 ? new MVmatrix(abstractDataMatrix.getN(), abstractDataMatrix.getK(), string) : new MVmatrix(n, n2 / n, string);
        int n3 = mVmatrix.getN();
        int n4 = mVmatrix.getK();
        int[] nArray = abstractDataMatrix.getNref();
        int[] nArray2 = abstractDataMatrix.getKref();
        Matrix matrix = mVmatrix.getInternalMatrixPublic();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = j * n + i;
                if (bl && j < nArray2.length && i < nArray.length) {
                    n5 = nArray2[j] * n + nArray[i];
                }
                if (!innerColumnBoolean.getValueBool(n5) || innerColumnClass.getValueShort(n5) != s) continue;
                matrix.set(i, j, 1.0);
            }
        }
        return mVmatrix;
    }
}

