/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.algorithm;

import java.util.List;
import java.util.Properties;
import javax.swing.ListSelectionModel;
import se.prediktera.image.count.algorithm.IdentifiedObjectDataClass;
import se.prediktera.image.count.algorithm.IdentifiedObjectListWithSummary;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.data.modeltable.ModelTable;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;

public class ObjectIdentificationTableModel
extends AbstractTModel {
    private final IdentifiedObjectListWithSummary[] cdc;

    public ObjectIdentificationTableModel(IdentifiedObjectListWithSummary[] identifiedObjectListWithSummaryArray) {
        this.cdc = identifiedObjectListWithSummaryArray;
    }

    @Override
    public boolean doInteraction(ModelTable modelTable, InteractionInterface interactionInterface, ListSelectionModel listSelectionModel) {
        InteractionArray interactionArray;
        if (interactionInterface.equals(modelTable.getModelTable()) && (interactionArray = modelTable.getInteractionArray(1, 1, false)) != null) {
            listSelectionModel.clearSelection();
            for (int i = 0; i < interactionArray.size(); ++i) {
                if (!interactionArray.get(i)) continue;
                for (int j = 0; j < this.getRowCount(); ++j) {
                    IdentifiedObjectDataClass identifiedObjectDataClass;
                    int n;
                    Object object = this.getValueAt(j, 1);
                    if (!(object instanceof IdentifiedObjectDataClass) || (n = DataTreeManager.getStartIndex((DataTreeInterface)(object = (IdentifiedObjectListWithSummary)(identifiedObjectDataClass = (IdentifiedObjectDataClass)object).getTreeParent()), IdentifiedObjectListWithSummary.class, IdentifiedObject.class) + DataTreeManager.indexOfTreeNode((DataTreeInterface)object, identifiedObjectDataClass, IdentifiedObject.class)) != i) continue;
                    listSelectionModel.addSelectionInterval(j, j);
                }
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int n) {
        return switch (n) {
            case 0 -> "Name";
            case 1 -> "Objects";
            case 2 -> "Area";
            case 3 -> "D1";
            case 4 -> "D2";
            case 5 -> "Circumference";
            case 6 -> "Regularity";
            case 7 -> "Roundness";
            case 8 -> "Orientation";
            default -> "N/A";
        };
    }

    @Override
    public int getRowCount() {
        int n = 0;
        for (IdentifiedObjectListWithSummary identifiedObjectListWithSummary : this.cdc) {
            n += identifiedObjectListWithSummary.getNumber() + 1;
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = 0;
        Object object = null;
        for (IdentifiedObjectListWithSummary cloneable : this.cdc) {
            int n4 = cloneable.getNumber() + 1;
            if (n < n3 + n4) {
                object = cloneable;
                break;
            }
            n3 += n4;
        }
        if ((n -= n3) == 0) {
            return switch (n2) {
                case 0 -> object;
                case 1 -> ((IdentifiedObjectListWithSummary)object).getNumber() + " Objects";
                case 2 -> ((IdentifiedObjectListWithSummary)object).getArea(((IdentifiedObjectListWithSummary)object).getTotal());
                case 3 -> ((IdentifiedObjectListWithSummary)object).getDistance(((IdentifiedObjectListWithSummary)object).getD1());
                case 4 -> ((IdentifiedObjectListWithSummary)object).getDistance(((IdentifiedObjectListWithSummary)object).getD2());
                case 5 -> ((IdentifiedObjectListWithSummary)object).getDistance(((IdentifiedObjectListWithSummary)object).getCircumference());
                case 6 -> NiceDataFormat.toPercent(((IdentifiedObjectListWithSummary)object).getRegularity());
                case 7 -> NiceDataFormat.toPercent(((IdentifiedObjectListWithSummary)object).getRoundness());
                case 8 -> NiceDataFormat.toString(((IdentifiedObjectListWithSummary)object).getOrientation(), 3) + " degrees";
                default -> "";
            };
        }
        List<IdentifiedObjectDataClass> list = ((IdentifiedObjectListWithSummary)object).createObjectList();
        Properties properties = new Properties();
        properties.put("unit", "false");
        if (--n < list.size()) {
            IdentifiedObjectDataClass identifiedObjectDataClass = (IdentifiedObjectDataClass)list.get(n);
            IdentifiedObject identifiedObject = identifiedObjectDataClass.getIdentifiedObject();
            switch (n2) {
                case 1: {
                    return identifiedObjectDataClass;
                }
                case 2: {
                    return ((IdentifiedObjectListWithSummary)object).getArea(identifiedObjectDataClass.getArea(), properties);
                }
                case 3: {
                    return ((IdentifiedObjectListWithSummary)object).getDistance(identifiedObject.getD1(), properties);
                }
                case 4: {
                    return ((IdentifiedObjectListWithSummary)object).getDistance(identifiedObject.getD2(), properties);
                }
                case 5: {
                    return NiceDataFormat.toString(identifiedObject.getCircumference());
                }
                case 6: {
                    return NiceDataFormat.toString(identifiedObject.getRegularity() * 100.0, 3);
                }
                case 7: {
                    return NiceDataFormat.toString(identifiedObject.getRoundness() * 100.0, 3);
                }
                case 8: {
                    return NiceDataFormat.toString(identifiedObject.getOrientation(), 3);
                }
            }
        }
        return "";
    }

    @Override
    public void prepareInteraction(ModelTable modelTable, int[] nArray) {
        InteractionArray interactionArray = modelTable.getInteractionArray(1, 0, true);
        for (int n : nArray) {
            int[] nArray2 = this.getIndecis(n);
            if (nArray2 == null) continue;
            for (int n2 : nArray2) {
                interactionArray.set(n2);
            }
        }
        Object object = (IdentifiedObjectListWithSummary)modelTable.getModelTable();
        ((IdentifiedObjectListWithSummary)object).doInteractionGroup(interactionArray);
    }

    private int[] getIndecis(int n) {
        if (this.getValueAt(n, 0) instanceof IdentifiedObjectListWithSummary) {
            IdentifiedObjectListWithSummary identifiedObjectListWithSummary = (IdentifiedObjectListWithSummary)this.getValueAt(n, 0);
            int n2 = DataTreeManager.getStartIndex(identifiedObjectListWithSummary, IdentifiedObjectListWithSummary.class, IdentifiedObject.class);
            int[] nArray = new int[DataTreeManager.getTreeNodeCount(identifiedObjectListWithSummary, IdentifiedObject.class)];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n2 + i;
            }
            return nArray;
        }
        Object object = this.getValueAt(n, 1);
        if (object instanceof IdentifiedObjectDataClass) {
            IdentifiedObjectDataClass identifiedObjectDataClass = (IdentifiedObjectDataClass)object;
            object = (IdentifiedObjectListWithSummary)identifiedObjectDataClass.getTreeParent();
            return new int[]{DataTreeManager.getStartIndex((DataTreeInterface)object, IdentifiedObjectListWithSummary.class, IdentifiedObject.class) + DataTreeManager.indexOfTreeNode((DataTreeInterface)object, identifiedObjectDataClass, IdentifiedObject.class)};
        }
        return null;
    }
}

