/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.image.count.grid;

import java.util.Properties;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2D;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.register.RegisterKeyManager;

public class GridAnalysisInfo
extends AbstractAnalysisInfo {
    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        FoldMatrix foldMatrix;
        DataTreeClass dataTreeClass;
        progressManager.setInfoText("Calculating grids");
        String string = "4x4";
        boolean bl = true;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "grid")) {
                string = ScriptHelper.getProperty(properties, "grid");
            }
            if (ScriptHelper.hasKey(properties, "rowwise")) {
                bl = ScriptHelper.getPropertyBool(properties, "rowwise");
            }
        }
        String[] stringArray = string.split("x");
        int n = Integer.parseInt(stringArray[0].trim());
        int n2 = Integer.parseInt(stringArray[1].trim());
        DataSet dataSet = (DataSet)objectArray[0];
        if (objectArray.length == 1) {
            dataTreeClass = dataSet.getMatrix(0);
            foldMatrix = new FoldMatrix((AbstractDataMatrix)dataTreeClass);
        } else {
            foldMatrix = (FoldMatrix)objectArray[1];
        }
        dataTreeClass = dataSet.getObsDataInfo();
        Category category = (Category)dataSet.createModification(progressManager, "obs", "category");
        category.setLayerName(DataTreeManager.getUniqueName(category.getTreeParent(), "Grid"));
        InnerColumnClass innerColumnClass = category.getInnerColumn();
        ClassTypes classTypes = innerColumnClass.getObject();
        classTypes.clear();
        int n3 = 1;
        if (bl) {
            for (var16_16 = 0; var16_16 < n2; ++var16_16) {
                for (var17_18 = 0; var17_18 < n; ++var17_18) {
                    classTypes.addString(String.valueOf(n3++));
                }
            }
        } else {
            for (var16_16 = 0; var16_16 < n; ++var16_16) {
                for (var17_18 = 0; var17_18 < n2; ++var17_18) {
                    classTypes.addString(String.valueOf(n3++));
                }
            }
        }
        innerColumnClass.beginUpdate();
        int[] nArray = foldMatrix.getFNref();
        int[] nArray2 = foldMatrix.getPref();
        int n4 = foldMatrix.getN();
        int n5 = foldMatrix.getK();
        int n6 = foldMatrix.getYmax();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n7 = i * n6 + j;
                int n8 = j * n / n4;
                int n9 = i * n2 / n5;
                if (nArray[n7] < 0) continue;
                if (bl) {
                    innerColumnClass.setValueShort(nArray2[nArray[n7]], (short)(n9 * n + n8));
                    continue;
                }
                innerColumnClass.setValueShort(nArray2[nArray[n7]], (short)(n8 * n2 + n9));
            }
        }
        innerColumnClass.endUpdate();
        category.updateClasses();
        ((AbstractDataInfo)dataTreeClass).triggerEvent(new DataInfoEvent((AbstractDataInfo)dataTreeClass, 0, category));
        return category;
    }

    @Override
    public void showAnalysisDialog(Project_GUI project_GUI, final DataTreeInterface dataTreeInterface) {
        String string;
        try {
            string = (String)EvinceScriptCommands.showInputDialog(null, "string", "Enter grid resolution (Rows x Columns)", "4x4");
            if (string == null) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        final FloatWindowPlot2D floatWindowPlot2D = (FloatWindowPlot2D)dataTreeInterface;
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
            final /* synthetic */ GridAnalysisInfo this$0;
            {
                this.this$0 = gridAnalysisInfo;
            }

            @Override
            public Object doWork() {
                try {
                    FoldMatrix foldMatrix = this.this$0.getFoldMatrix(dataTreeInterface);
                    DataSet dataSet = floatWindowPlot2D.getDataSet();
                    Properties properties = new Properties();
                    properties.put("grid", string);
                    Category category = (Category)this.this$0.performAnalysis((ProgressManager)this, new Object[]{dataSet, foldMatrix}, properties);
                    floatWindowPlot2D.setSettingBoxOption((byte)3, new Object[]{"category", category.toString()});
                    if (floatWindowPlot2D.getLegends() != null && floatWindowPlot2D.getLegends().isEmpty()) {
                        floatWindowPlot2D.addLegend(new Object[]{"color"});
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
                return null;
            }
        };
        progressManagerImpl.invokeLater();
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        if (RegisterKeyManager.isPredikteraLicense() && objectArray.length == 1 && objectArray[0] instanceof FloatWindow) {
            DataTreeInterface dataTreeInterface = (DataTreeInterface)objectArray[0];
            return this.getFoldMatrix(dataTreeInterface) != null;
        }
        return false;
    }

    public String toString() {
        return "Create category from grid";
    }

    private FoldMatrix getFoldMatrix(DataTreeInterface dataTreeInterface) {
        DataTreeInterface dataTreeInterface2;
        DataTreeInterface dataTreeInterface3 = dataTreeInterface.getTreeParent();
        if (dataTreeInterface3 instanceof Contour2D && (dataTreeInterface2 = ((AbstractPlotBaseWindow)dataTreeInterface3).getPlotInit().getDataTreeInterface()) instanceof FoldMatrix) {
            return (FoldMatrix)dataTreeInterface2;
        }
        return null;
    }
}

